/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.process.make;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.workflow.bpmn.model.AuditTask;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.FlowNode;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.SequenceFlow;
import kd.bos.workflow.devops.process.make.IMigrator;
import kd.bos.workflow.devops.process.make.MigrateContext;
import kd.bos.workflow.devops.process.make.NodeOperation;
import kd.bos.workflow.domain.model.NodeForkJoinModel;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.VariableScope;
import kd.bos.workflow.engine.dynprocess.AddSignInfo;
import kd.bos.workflow.engine.impl.agenda.ForkJoinUtils;
import kd.bos.workflow.engine.impl.bpmn.helper.BPMNUtil;
import kd.bos.workflow.engine.impl.dynprocess.DynProcessProcessorHelper;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.util.DynamicFlowUtil;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.impl.util.condition.ConditionUtil;
import kd.bos.workflow.engine.process.NodeData;
import kd.bos.workflow.exception.WFException;

public class DefaultMaker
implements IMigrator {
    private static final String JOINSTR = "%s_%s";
    protected MigrateContext context;
    protected ExecutionEntity execution;
    protected NodeData nodeData;
    protected FlowElement flowElement;

    protected void init(MigrateContext context, NodeOperation operation) {
        this.context = context;
        this.execution = operation.getExecution();
        this.nodeData = operation.getNodeData();
        this.flowElement = context.getProcess().getFlowElement(this.nodeData.getActId());
        if (this.flowElement == null) {
            throw new WFException(ResManager.loadKDString((String)"\u8fc1\u79fb\u63a5\u53e3\u6682\u4e0d\u652f\u6301\u542b\u81ea\u7531\u6d41\u7684\u6d41\u7a0b", (String)"DefaultMaker_2", (String)"bos-wf-devops", (Object[])new Object[0]));
        }
        this.execution.setCurrentFlowElement(this.flowElement);
        if (this.execution.getCurrentTask() != null) {
            this.execution.setCurrentTask(null);
            this.execution.setCurrentTaskId(null);
        }
    }

    @Override
    public boolean migrate(MigrateContext context, NodeOperation operation) {
        this.init(context, operation);
        if (!this.dealJionNode()) {
            return false;
        }
        this.doMigrate();
        if (this.nodeData.getEndDate() != null) {
            this.takeNodeGoOut();
            this.planNextNodes();
        }
        return true;
    }

    protected void planNextNodes() {
        if (this.nodeData.getEndDate() == null) {
            return;
        }
        CommandContext commandContext = this.context.getCommandContext();
        List<NodeData> nextNodes = this.getNextNodeDatas(this.nodeData);
        int i = 1;
        for (NodeData nextNode : nextNodes) {
            ExecutionEntity executionNext = null;
            if (i > 1) {
                executionNext = commandContext.getExecutionEntityManager().createChildExecution(this.execution.getParent());
                executionNext.setCurrentActInstId(this.execution.getCurrentActInstId());
                executionNext.setCurrentFlowElement(this.execution.getCurrentFlowElement());
                executionNext.setCreateDate(nextNode.getCreateDate());
                executionNext.setModifyDate(nextNode.getCreateDate());
                commandContext.getExecutionEntityManager().update((Entity)executionNext);
            } else {
                executionNext = this.execution;
            }
            this.context.planNodeOperation(executionNext, nextNode);
            ++i;
        }
        this.execution.setModifyDate(this.nodeData.getEndDate());
        commandContext.getExecutionEntityManager().update((Entity)this.execution);
    }

    private List<NodeData> getNextNodeDatas(NodeData curNodeData) {
        ArrayList<NodeData> list = new ArrayList<NodeData>(10);
        List nextNodeIds = curNodeData.getNextNodeIds();
        if (WfUtils.isEmptyForCollection((Collection)nextNodeIds)) {
            return list;
        }
        for (Long nextNodeId : nextNodeIds) {
            if (this.context.getAllNodes().get(nextNodeId) == null) continue;
            list.add(this.context.getAllNodes().get(nextNodeId));
        }
        return list;
    }

    protected void doMigrate() {
        this.recordActStart();
        this.selfBehave();
        this.recordActEnd();
    }

    protected void takeNodeGoOut() {
        this.execution.setVariableLocal("lastUserDealNode", (Object)this.flowElement.getId());
        if (this.flowElement instanceof SequenceFlow) {
            SequenceFlow sequenceFlow = (SequenceFlow)this.flowElement;
            FlowElement targetFlowElement = sequenceFlow.getTargetFlowElement();
            this.context.getCommandContext().getHistoryManager().insertOrUpdateLastCurrentNodeMapper(this.execution, sequenceFlow, targetFlowElement);
        } else {
            DynamicFlowUtil.removeVariableWhenIncoming((ExecutionEntity)this.execution, (String)((FlowNode)this.flowElement).getId());
            this.context.getCommandContext().getHistoryManager().updateNodeHiUserActInst(this.execution, (FlowNode)this.execution.getCurrentFlowElement(), this.nodeData.getEndDate());
            this.takeOutGoing();
            this.dealForkNode();
        }
    }

    protected boolean dealJionNode() {
        if (this.flowElement instanceof SequenceFlow) {
            return true;
        }
        Map models = this.context.getProcess().getForkJoinModels();
        NodeForkJoinModel forkJoinModel = (NodeForkJoinModel)models.get(this.flowElement.getId());
        FlowNode flowNode = (FlowNode)this.flowElement;
        if (flowNode.getJoin() != null && flowNode.getJoin().booleanValue() && "enterwhenallarrive".equals(flowNode.getInSet())) {
            String forkNodeId = forkJoinModel.getPairForkNodeId();
            int cycle = ForkJoinUtils.getEnterForkCycle((String)forkNodeId, (ExecutionEntity)this.context.getProcessInstanceExecution());
            String joinFlag = forkNodeId + "$" + cycle + "$" + flowNode.getId();
            int noOfArrived = 1;
            Object tmp = ForkJoinUtils.getNoOfArrived((String)joinFlag, (ExecutionEntity)this.context.getProcessInstanceExecution());
            if (tmp != null) {
                noOfArrived = (Integer)tmp + 1;
            }
            ForkJoinUtils.setNoOfArrived((String)joinFlag, (ExecutionEntity)this.context.getProcessInstanceExecution(), (int)noOfArrived);
            tmp = ForkJoinUtils.getNoOfShouldSurvive((String)joinFlag, (ExecutionEntity)this.context.getProcessInstanceExecution());
            int noOfShouldSurvive = 0;
            if (tmp != null) {
                noOfShouldSurvive = (Integer)tmp;
            }
            if (!ForkJoinUtils.meetJoinCondition((FlowNode)flowNode, (int)noOfShouldSurvive, (int)noOfArrived, (ExecutionEntity)this.execution)) {
                this.recordActStart();
                this.recordActEnd();
                return false;
            }
            this.deleteOtherBranch(joinFlag);
        }
        return true;
    }

    private void deleteOtherBranch(String joinFlag) {
        CommandContext commandContext = this.context.getCommandContext();
        List actInsts = commandContext.getHistoricActivityInstanceEntityManager().findByProInstIdAndJoinFlag(this.execution.getProcessInstanceId(), joinFlag, this.execution.getId());
        if (WfUtils.isEmptyForCollection((Collection)actInsts)) {
            return;
        }
        for (HistoricActivityInstanceEntity actInst : actInsts) {
            Long executionId = actInst.getExecutionId();
            if (WfUtils.isEmpty((Long)executionId) || executionId.equals(this.execution.getId())) continue;
            ExecutionEntity executionEntity = (ExecutionEntity)commandContext.getExecutionEntityManager().findById(actInst.getExecutionId());
            commandContext.getExecutionEntityManager().deleteExecutionAndRelatedData(executionEntity, null, false);
            Long currentTaskId = this.execution.getCurrentTaskId();
            if (!WfUtils.isNotEmpty((Long)currentTaskId)) continue;
            actInst.setTaskId(currentTaskId);
            commandContext.getHistoricActivityInstanceEntityManager().update((Entity)actInst);
        }
    }

    private void dealForkNode() {
        Map models = this.context.getProcess().getForkJoinModels();
        NodeForkJoinModel forkJoinModel = (NodeForkJoinModel)models.get(this.flowElement.getId());
        String outSet = ((FlowNode)this.flowElement).getOutSet();
        if (forkJoinModel.isForkNode() && "leavewhenallmeet".equals(outSet) && !"reject".equals(this.nodeData.getAuditType()) && !"forceReject".equals(this.nodeData.getAuditType())) {
            String flowNodeId = this.flowElement.getId();
            String nextNodeId = this.context.getAllNodes().get(this.nodeData.getNextNodeIds().get(0)).getActId();
            SequenceFlow curSequenceFlow = (SequenceFlow)this.context.getProcess().getFlowElement(nextNodeId);
            String targetNodeId = curSequenceFlow.getTargetFlowElement().getId();
            NodeForkJoinModel nextNodeModel = (NodeForkJoinModel)models.get(targetNodeId);
            int enteredCycle = ForkJoinUtils.getEnterForkCycle((String)this.flowElement.getId(), (ExecutionEntity)this.context.getProcessInstanceExecution()) + 1;
            ForkJoinUtils.setEnterForkCycle((String)this.flowElement.getId(), (ExecutionEntity)this.context.getProcessInstanceExecution(), (int)enteredCycle);
            String joinFlag = String.format("%s$%s$%s", flowNodeId, enteredCycle, nextNodeModel.getLatestJoinNode());
            ForkJoinUtils.setNoOfShouldSurvive((String)joinFlag, (ExecutionEntity)this.context.getProcessInstanceExecution(), (int)this.nodeData.getNextNodeIds().size());
        }
    }

    protected void selfBehave() {
    }

    private void takeOutGoing() {
        Object nextNodeId2;
        if (WfUtils.isEmptyForCollection((Collection)this.nodeData.getNextNodeIds())) {
            return;
        }
        ArrayList<SequenceFlow> outgoingSequenceFlows = new ArrayList<SequenceFlow>(1);
        StringJoiner nextNodeIdJoiner = new StringJoiner(",");
        ArrayList<NodeData> targetFlows = new ArrayList<NodeData>(1);
        for (Object nextNodeId2 : this.nodeData.getNextNodeIds()) {
            NodeData targetFlow = this.context.getAllNodes().get(nextNodeId2);
            targetFlows.add(targetFlow);
        }
        NodeData targetNode = null;
        for (NodeData targetFlow : targetFlows) {
            targetNode = this.context.getAllNodes().get(targetFlow.getNextNodeIds().get(0));
            nextNodeIdJoiner.add(targetNode.getActId());
        }
        nextNodeId2 = nextNodeIdJoiner.toString();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("nextnodeid", nextNodeId2);
        if (this.execution.getCurrentTask() != null) {
            this.execution.getCurrentTask().setVariableLocal("nextNodeId", nextNodeId2);
        }
        if (WfUtils.isNotEmpty((String)this.nodeData.getDynType())) {
            String key;
            SequenceFlow dynSequenceFlow;
            this.execution.setVariable("dynType", (Object)this.nodeData.getDynType());
            this.buildAndSetVariableOfAddSignInfo(targetNode);
            if (DynamicFlowUtil.isNextNodeTerminate((ExecutionEntity)this.execution)) {
                dynSequenceFlow = DynProcessProcessorHelper.createDynProcess((ExecutionEntity)this.execution, (FlowNode)((FlowNode)this.flowElement), (String)"terminateEvent", null);
                outgoingSequenceFlows.add(dynSequenceFlow);
            } else if (DynamicFlowUtil.isNextNodeDynamicJump((ExecutionEntity)this.execution)) {
                dynSequenceFlow = this.findSuitableSequence((FlowNode)this.flowElement, (String)nextNodeId2);
                if (dynSequenceFlow == null) {
                    dynSequenceFlow = DynProcessProcessorHelper.createDynProcess((ExecutionEntity)this.execution, (FlowNode)((FlowNode)this.flowElement), (String)"sequenceFlow", params);
                }
                outgoingSequenceFlows.add(dynSequenceFlow);
                key = String.format(JOINSTR, dynSequenceFlow.getSourceRef(), "rejectToForkInnerAndSkip");
                this.execution.getProcessInstance().removeVariable(key);
            } else if (DynamicFlowUtil.isAddSignBefore((ExecutionEntity)this.execution)) {
                dynSequenceFlow = DynProcessProcessorHelper.createDynProcess((ExecutionEntity)this.execution, (FlowNode)((FlowNode)this.flowElement), (String)"addsignbefore", null);
                outgoingSequenceFlows.add(dynSequenceFlow);
                key = String.format(JOINSTR, dynSequenceFlow.getSourceRef(), "rejectToForkInnerAndSkip");
                this.execution.getProcessInstance().removeVariable(key);
            } else if ("addsignafter".equalsIgnoreCase(this.nodeData.getDynType())) {
                dynSequenceFlow = DynProcessProcessorHelper.createDynProcess((ExecutionEntity)this.execution, (FlowNode)((FlowNode)this.flowElement), (String)"addsignafter", null);
                outgoingSequenceFlows.add(dynSequenceFlow);
                key = String.format(JOINSTR, dynSequenceFlow.getSourceRef(), "rejectToForkInnerAndSkip");
                this.execution.getProcessInstance().removeVariable(key);
            } else if (DynamicFlowUtil.isRejectToForkInner((ExecutionEntity)this.execution)) {
                this.dealRejectToForkInner((FlowNode)this.flowElement, outgoingSequenceFlows, (String)nextNodeId2, this.context.getProcessInstanceExecution());
            } else if ("dynReject".equals(this.nodeData.getDynType())) {
                dynSequenceFlow = DynProcessProcessorHelper.createDynProcess((ExecutionEntity)this.execution, (FlowNode)((FlowNode)this.flowElement), (String)"sequenceFlow", params);
                outgoingSequenceFlows.add(dynSequenceFlow);
            }
            this.context.setProcess(ProcessDefinitionUtil.getProcess((Long)this.context.getProcessDefinition().getId(), (Long)this.context.getProcessInstanceExecution().getProcessInstanceId()));
            block2: for (int i = 0; i < outgoingSequenceFlows.size(); ++i) {
                FlowElement dynNode = (FlowElement)outgoingSequenceFlows.get(i);
                NodeData nodeDataTemp = this.context.getAllNodes().get(this.nodeData.getNextNodeIds().get(i));
                while (nodeDataTemp.getIsDynamic()) {
                    nodeDataTemp.setActId(dynNode.getId());
                    nodeDataTemp.setActType(dynNode.getType());
                    if (WfUtils.isEmptyForCollection((Collection)nodeDataTemp.getNextNodeIds()) || WfUtils.isNotEmpty((String)nodeDataTemp.getDynType())) continue block2;
                    nodeDataTemp = this.context.getAllNodes().get(nodeDataTemp.getNextNodeIds().get(0));
                    if (dynNode instanceof SequenceFlow) {
                        dynNode = ((SequenceFlow)dynNode).getTargetFlowElement();
                        continue;
                    }
                    dynNode = (FlowElement)((FlowNode)dynNode).getOutgoingFlows().get(0);
                }
            }
        }
        this.setRejectKeyForkResultAndOtherBranchsIfNeed((FlowNode)this.flowElement, outgoingSequenceFlows, (String)nextNodeId2, this.context.getProcessInstanceExecution());
        DynamicFlowUtil.transferDynInfo((ExecutionEntity)this.execution, (FlowNode)((FlowNode)this.flowElement), (String)nextNodeId2);
        this.execution.removeVariable("dynType");
        this.execution.removeVariable("addsigninfo");
    }

    private void buildAndSetVariableOfAddSignInfo(NodeData targetNode) {
        if ("addsignafter".equals(this.nodeData.getDynType()) || "addsignbefore".equals(this.nodeData.getDynType())) {
            AddSignInfo addSignInfo = new AddSignInfo();
            ArrayList<LocaleString> nodeNameList = null;
            Object addSingMsg = null;
            String addSignYunzhijiaBusinessMode = "";
            if (this.nodeData.getExtraParams() != null) {
                Map extraParams = this.nodeData.getExtraParams();
                nodeNameList = (ArrayList<LocaleString>)extraParams.get("addSignNodeNames");
                addSingMsg = (Map)extraParams.get("addSingMsg");
                addSignYunzhijiaBusinessMode = (String)extraParams.get("addSignYunzhijiaBusinessMode");
            }
            if (WfUtils.isEmpty((String)addSignYunzhijiaBusinessMode)) {
                addSignYunzhijiaBusinessMode = "passByOne";
            }
            if (WfUtils.isEmptyForCollection(nodeNameList)) {
                nodeNameList = new ArrayList<LocaleString>(1);
                nodeNameList.add(WfConfigurationUtil.getAddSignNameLocaleString());
            }
            if (WfUtils.isEmptyForMap(addSingMsg)) {
                addSingMsg = WfMultiLangUtils.getMultiLangValue((String)" ");
            }
            addSignInfo.setAddSingMsg((Map)addSingMsg);
            addSignInfo.setNodeNames(nodeNameList);
            addSignInfo.setAddSignType(this.nodeData.getDynType());
            addSignInfo.setAllowAddSign(Boolean.TRUE);
            addSignInfo.setUserIds(this.nodeData.getParticipants());
            if ("YunzhijiaTask".equals(targetNode.getActId())) {
                addSignInfo.setAddSignDealType("yzj");
                addSignInfo.setYzjType(addSignYunzhijiaBusinessMode);
            } else {
                addSignInfo.setAddSignDealType("anyone");
            }
            this.execution.setVariable("addsigninfo", (Object)SerializationUtils.toJsonString((Object)addSignInfo));
        }
    }

    private void setRejectKeyForkResultAndOtherBranchsIfNeed(FlowNode flowNode, List<SequenceFlow> outgoingSequenceFlows, String nextNodeId, ExecutionEntity proinst) {
        Process process = ProcessDefinitionUtil.getProcess((Long)this.execution.getProcessDefinitionId(), (Long)this.execution.getProcessInstanceId());
        String auditType = "";
        if (this.execution.getCurrentTask() != null) {
            auditType = (String)this.execution.getCurrentTask().getVariable("auditType");
            if (flowNode.getJoin() != null && flowNode.getJoin().booleanValue() && "enterwhenallarrive".equals(flowNode.getInSet())) {
                ForkJoinUtils.setJoinNodeRejectKey((Process)process, (FlowNode)flowNode, (ExecutionEntity)proinst);
            }
            if ("reject".equals(auditType)) {
                ForkJoinUtils.markOtherBranchsEnd((Process)process, (FlowNode)flowNode, (ExecutionEntity)this.execution, outgoingSequenceFlows);
            }
            ForkJoinUtils.updateForkResultVar((FlowNode)flowNode, (ExecutionEntity)proinst, (Process)process, (String)auditType, (String)nextNodeId);
        }
    }

    private SequenceFlow findSuitableSequence(FlowNode flowNode, String elemId) {
        SequenceFlow ret = null;
        ExecutionEntity scope = this.execution;
        if (this.execution.getCurrentTask() != null) {
            scope = this.execution.getCurrentTask();
        }
        boolean isDynamicReject = flowNode instanceof AuditTask && ((AuditTask)flowNode).isDynamicReject();
        String markKey = "";
        for (SequenceFlow sequenceFlow : flowNode.getOutgoingFlows()) {
            String condition;
            if (sequenceFlow.getTargetRef() == null || !sequenceFlow.getTargetRef().equals(elemId)) continue;
            boolean hasTrueCondition = false;
            String string = condition = isDynamicReject ? sequenceFlow.getOrignalExpression() : sequenceFlow.getConditionExpression();
            if (WfUtils.isNotEmpty((String)condition)) {
                markKey = ConditionUtil.getConInstKey((String)flowNode.getNumber(), (String)sequenceFlow.getId());
                hasTrueCondition = ConditionUtil.hasTrueCondition((String)condition, (VariableScope)scope, (String)markKey);
            } else {
                hasTrueCondition = true;
            }
            if (!hasTrueCondition) continue;
            ret = sequenceFlow;
            break;
        }
        return ret;
    }

    private void dealRejectToForkInner(FlowNode flowNode, List<SequenceFlow> outgoingSequenceFlows, String nextNodeId, ExecutionEntity proinst) {
        Long procInstId = this.execution.getProcessInstanceId();
        Process process = ProcessDefinitionUtil.getProcess((Long)this.execution.getProcessDefinitionId(), (Long)procInstId);
        Map models = process.getForkJoinModels();
        HashMap<String, String> params = new HashMap<String, String>(16);
        NodeForkJoinModel nextNodeModel = null;
        String skipToNode = DynamicFlowUtil.getDynamicVariableValue((ExecutionEntity)this.execution, (String)String.format("%s-%s", nextNodeId, "rejectToForkInnerAndSkip"));
        HistoricActivityInstanceEntityManager hiActInstManager = this.context.getCommandContext().getHistoricActivityInstanceEntityManager();
        boolean isSkip = WfUtils.isNotEmpty((String)skipToNode);
        ArrayList dynamicPant = new ArrayList();
        for (String nodeId : nextNodeId.split("\\,")) {
            List actInsts;
            params.put("nextnodeid", nodeId);
            SequenceFlow dynSequenceFlow = DynProcessProcessorHelper.createDynProcess((ExecutionEntity)this.execution, (FlowNode)flowNode, (String)"sequenceFlow", params);
            outgoingSequenceFlows.add(dynSequenceFlow);
            nextNodeModel = (NodeForkJoinModel)models.get(nodeId);
            if (isSkip) {
                String key = String.format(JOINSTR, nodeId, "rejectToForkInnerAndSkip");
                proinst.setVariable(key, (Object)String.format("%s-%s", nodeId, skipToNode));
            }
            if ((actInsts = hiActInstManager.findByActivityId(procInstId, nodeId)).isEmpty()) continue;
            Long assigneeId = null;
            for (HistoricActivityInstanceEntity actInst : actInsts) {
                String activityType = actInst.getActivityType();
                if ("YunzhijiaTask".equals(activityType) || "AuditTask".equals(activityType) && "skip".equals(actInst.getExecutionType())) continue;
                assigneeId = actInst.getAssigneeId();
            }
            if (!WfUtils.isNotEmpty(assigneeId)) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("nodeId", nodeId);
            map.put("userIds", String.valueOf(assigneeId));
            dynamicPant.add(map);
        }
        this.execution.getCurrentTask().setTransientVariableLocal("dynParticipant", (Object)SerializationUtils.toJsonString(dynamicPant));
        if (nextNodeModel != null) {
            String forkNodeId = nextNodeModel.getLatestForkNode();
            int cycle = ForkJoinUtils.getEnterForkCycle((String)forkNodeId, (ExecutionEntity)proinst);
            ForkJoinUtils.setEnterForkCycle((String)forkNodeId, (ExecutionEntity)proinst, (int)(++cycle));
            String joinFlag = String.format("%s$%s$%s", forkNodeId, cycle, nextNodeModel.getLatestJoinNode());
            ForkJoinUtils.setNoOfShouldSurvive((String)joinFlag, (ExecutionEntity)proinst, (int)outgoingSequenceFlows.size());
            ForkJoinUtils.setForkResult((FlowNode)flowNode, outgoingSequenceFlows, (ExecutionEntity)proinst);
        }
    }

    protected void recordActStart() {
        CommandContext commandContext = this.context.getCommandContext();
        commandContext.getHistoryManager().recordActivityStart(this.execution);
        Long actInstId = this.execution.getCurrentActInstId();
        HistoricActivityInstanceEntity historicActivityInstanceEntity = (HistoricActivityInstanceEntity)commandContext.getHistoricActivityInstanceEntityManager().findById(actInstId);
        historicActivityInstanceEntity.setExecutionType(this.nodeData.getExecutionType());
        this.execution.setActivityName(historicActivityInstanceEntity.getActivityName());
    }

    protected void recordActEnd() {
        CommandContext commandContext = this.context.getCommandContext();
        Long actInstId = this.execution.getCurrentActInstId();
        HistoricActivityInstanceEntity historicActivityInstanceEntity = (HistoricActivityInstanceEntity)commandContext.getHistoricActivityInstanceEntityManager().findById(actInstId);
        historicActivityInstanceEntity.setCreateDate(this.nodeData.getCreateDate());
        historicActivityInstanceEntity.setModifyDate(this.nodeData.getCreateDate());
        if (this.nodeData.getEndDate() != null) {
            commandContext.getHistoryManager().recordActivityEnd(this.execution, " ");
            historicActivityInstanceEntity.setEndTime(this.nodeData.getEndDate());
            historicActivityInstanceEntity.setDurationInMillis(Long.valueOf(this.nodeData.getEndDate().getTime() - this.nodeData.getCreateDate().getTime()));
            historicActivityInstanceEntity.setRealDurationInMillis(Long.valueOf(this.nodeData.getEndDate().getTime() - this.nodeData.getCreateDate().getTime()));
        } else {
            BPMNUtil.updateExecutionActivityName((ExecutionEntity)this.execution);
            BPMNUtil.updateHitaskInstPresentAssignee((ExecutionEntity)this.execution, null);
        }
        commandContext.getHistoricActivityInstanceEntityManager().update((Entity)historicActivityInstanceEntity);
    }
}

