/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.process.make;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.bpmn.model.AuditTask;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.bpmn.model.Variable;
import kd.bos.workflow.bpmn.model.YunzhijiaTask;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricIdentityLinkEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricVariableInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricVariableInstanceEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.DynamicResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntity;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.process.NodeData;
import kd.bos.workflow.engine.process.ProcessInstData;
import kd.bos.workflow.engine.process.ProcessVariableData;
import kd.bos.workflow.exception.WFException;

public class GetProcessMakeDataCmd
implements Command<ProcessInstData> {
    private Long procInstId;
    private List<Long> currentActIds;
    private Set<Long> dynNodes = new HashSet<Long>(16);
    private LinkedList<HistoricActivityInstanceEntity> nodeDataLink = new LinkedList();
    private Map<Long, Boolean> isCurrentSubProcess = new HashMap<Long, Boolean>(16);

    public GetProcessMakeDataCmd(Long procInstId, List<Long> currentActIds) {
        this.procInstId = procInstId;
        this.currentActIds = currentActIds;
    }

    public ProcessInstData execute(CommandContext commandContext) {
        if (WfUtils.isEmpty((Long)this.procInstId) || WfUtils.isEmptyForCollection(this.currentActIds)) {
            throw new WFException(String.format(ResManager.loadKDString((String)"\u6d41\u7a0b\u5b9e\u4f8bID[%1$s]\u6216\u5f53\u524d\u6d3b\u52a8\u5b9e\u4f8bID[%2$s]\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (String)"GetProcessMakeDataCmd_1", (String)"bos-wf-devops", (Object[])new Object[0]), this.procInstId, this.currentActIds));
        }
        return this.initProcessInstData(commandContext, this.procInstId);
    }

    private ProcessInstData initProcessInstData(CommandContext commandContext, Long processInstId) {
        this.checkProcess(commandContext, processInstId);
        ProcessInstData processInstData = new ProcessInstData();
        boolean isCurrentProc = false;
        HistoricProcessInstanceEntityManager hiProcInstManager = commandContext.getHistoricProcessInstanceEntityManager();
        HistoricActivityInstanceEntityManager hiActInstManager = commandContext.getHistoricActivityInstanceEntityManager();
        List hiActInsts = hiActInstManager.findByProcessInstanceId(processInstId);
        List allCommentEntitys = commandContext.getCommentEntityManager().findByQueryFilters(new QFilter[]{new QFilter("processInstanceId", "=", (Object)processInstId)});
        List allHiTaskEntitys = commandContext.getHistoricTaskInstanceEntityManager().findByQueryFilters(new QFilter[]{new QFilter("processInstanceId", "=", (Object)processInstId)});
        List allHiParticipants = commandContext.getHistoricIdentityLinkEntityManager().findByProcInstIdAndType(processInstId, "participant");
        HistoricProcessInstanceEntity hiProcInst = (HistoricProcessInstanceEntity)hiProcInstManager.findById(processInstId);
        Process process = ProcessDefinitionUtil.getProcessBySchemeId((Long)hiProcInst.getSchemeId());
        Process realProcess = ProcessDefinitionUtil.getProcessByProcInstId((Long)processInstId);
        if (WfUtils.isNotEmpty((Long)hiProcInst.getSuperProcessInstanceId())) {
            processInstData.setIsSubProcess(true);
        } else {
            processInstData.setIsSubProcess(false);
        }
        processInstData.setBusinessKey(hiProcInst.getBusinessKey());
        processInstData.setEntityNumber(hiProcInst.getEntitynumber());
        processInstData.setInitor(hiProcInst.getStartUserId());
        processInstData.setProcDefId(hiProcInst.getProcessDefinitionId());
        processInstData.setSchemeId(hiProcInst.getSchemeId());
        processInstData.setSubject(hiProcInst.getSubject());
        processInstData.setCreateDate(hiProcInst.getCreateDate());
        this.putProcessVariables(commandContext, processInstId, processInstData, process);
        ArrayList<NodeData> nodeList = new ArrayList<NodeData>(10);
        if (WfUtils.isNotEmptyForCollection((Collection)hiActInsts)) {
            this.nodeDataLink.add((HistoricActivityInstanceEntity)hiActInsts.get(0));
        }
        boolean isFirstUserNode = true;
        boolean isEndNode = false;
        while (!this.nodeDataLink.isEmpty()) {
            HashSet<Long> sourceElementIds = new HashSet<Long>(5);
            HistoricActivityInstanceEntity hiActInst = this.nodeDataLink.poll();
            this.checkNode(hiActInst);
            String actType = hiActInst.getActivityType();
            NodeData node = new NodeData();
            node.setCreateDate(hiActInst.getCreateDate());
            node.setEndDate(hiActInst.getEndTime());
            switch (actType) {
                case "YunzhijiaTask": {
                    this.initYunzhijiaNode(node, hiActInst, sourceElementIds, hiActInsts, allHiTaskEntitys, allCommentEntitys, allHiParticipants);
                    break;
                }
                case "CallActivity": {
                    this.initDefaultNode(node, hiActInst, sourceElementIds, allHiTaskEntitys, allCommentEntitys, allHiParticipants);
                    this.initActivityNode(commandContext, hiActInst, allCommentEntitys, node);
                    break;
                }
                case "EndNoneEvent": 
                case "EndErrorEvent": 
                case "EndCancelEvent": 
                case "EndTerminateEvent": {
                    isEndNode = true;
                    this.initDefaultNode(node, hiActInst, sourceElementIds, allHiTaskEntitys, allCommentEntitys, allHiParticipants);
                    break;
                }
                default: {
                    this.initDefaultNode(node, hiActInst, sourceElementIds, allHiTaskEntitys, allCommentEntitys, allHiParticipants);
                }
            }
            if (WfUtils.isNotEmpty((String)node.getAuditNumber()) && isFirstUserNode) {
                if (isFirstUserNode) {
                    processInstData.setOperation(node.getAuditNumber());
                }
                isFirstUserNode = false;
            }
            if (this.currentActIds.contains(hiActInst.getId()) && !isEndNode) {
                node.setEndDate(null);
            }
            this.dealDynNodeAndContinue(process, realProcess, node, hiActInst, hiActInsts, sourceElementIds);
            nodeList.add(node);
            if (node.getEndDate() != null) continue;
            isCurrentProc = true;
        }
        this.isCurrentSubProcess.put(processInstId, isCurrentProc);
        processInstData.setNodeList(nodeList);
        return processInstData;
    }

    private void initDefaultNode(NodeData node, HistoricActivityInstanceEntity hiActInst, Set<Long> sourceElementIds, List<HistoricTaskInstanceEntity> allHiTaskEntitys, List<CommentEntity> allCommentEntitys, List<HistoricIdentityLinkEntity> allHiParticipants) {
        sourceElementIds.add(hiActInst.getId());
        node.setId(hiActInst.getId());
        node.setActId(hiActInst.getActivityId());
        node.setActType(hiActInst.getActivityType());
        node.setAssigneeId(hiActInst.getAssigneeId());
        node.setExecutionType(hiActInst.getExecutionType());
        node.setSkipReason(this.getSkipReasonCode(hiActInst.getSkipReason()));
        Long taskId = hiActInst.getTaskId();
        if (WfUtils.isNotEmpty((Long)taskId)) {
            HistoricTaskInstanceEntity historicTaskInstanceEntity;
            CommentEntity comment = this.findCommentByTaskId(hiActInst.getTaskId(), allCommentEntitys);
            if (comment != null) {
                node.setAuditName(comment.getCommentResult());
                node.setApprovalMsg(comment.getCommentMessage());
                node.setAuditNumber(comment.getResultNumber());
                node.setAuditType(comment.getDecisionType());
            }
            if ((historicTaskInstanceEntity = this.getHiTaskInstById(allHiTaskEntitys, taskId)) != null) {
                node.setSubject(historicTaskInstanceEntity.getSubject());
            }
            List<Long> participants = this.findHistoricIdentityLinksByTaskId(allHiParticipants, taskId);
            node.setParticipants(participants);
        }
    }

    private void checkProcess(CommandContext commandContext, Long processInstId) {
        List dyns = commandContext.getDynamicResourceEntityManager().findByProcessInstanceId(processInstId);
        if (WfUtils.isNotEmptyForCollection((Collection)dyns)) {
            for (DynamicResourceEntity dyn : dyns) {
                if (!"freeflow".equals(dyn.getType()) && !"freeflowafternode".equals(dyn.getType())) continue;
                throw new WFException(ResManager.loadKDString((String)"\u8fc1\u79fb\u63a5\u53e3\u6682\u4e0d\u652f\u6301\u542b\u81ea\u7531\u6d41\u7684\u6d41\u7a0b", (String)"GetProcessMakeDataCmd_2", (String)"bos-wf-devops", (Object[])new Object[0]));
            }
        }
    }

    private void checkNode(HistoricActivityInstanceEntity hiActInst) {
        String activityType;
        switch (activityType = hiActInst.getActivityType()) {
            case "SSCImageUpload": 
            case "SSCImageUploadNew": {
                throw new WFException(ResManager.loadKDString((String)"\u8fc1\u79fb\u63a5\u53e3\u6682\u4e0d\u652f\u6301\u542b\u5f71\u50cf\u4e0a\u4f20\u8282\u70b9\u7684\u6d41\u7a0b", (String)"GetProcessMakeDataCmd_4", (String)"bos-wf-devops", (Object[])new Object[0]));
            }
        }
    }

    private void initActivityNode(CommandContext commandContext, HistoricActivityInstanceEntity hiActInst, List<CommentEntity> allCommentEntitys, NodeData node) {
        CommentEntity comment;
        node.setChildProcess(this.initProcessInstData(commandContext, hiActInst.getCalledProcessInstanceId()));
        if (this.isCurrentSubProcess.get(hiActInst.getCalledProcessInstanceId()).booleanValue()) {
            node.setEndDate(null);
        }
        if ((comment = this.findCalledProcessInstanceId(hiActInst.getCalledProcessInstanceId(), allCommentEntitys)) != null) {
            node.setAuditName(comment.getCommentResult());
            node.setApprovalMsg(comment.getCommentMessage());
            node.setAuditNumber(comment.getResultNumber());
            node.setAuditType(comment.getDecisionType());
        }
    }

    private void initYunzhijiaNode(NodeData node, HistoricActivityInstanceEntity hiActInst, Set<Long> sourceElementIds, List<HistoricActivityInstanceEntity> hiActInsts, List<HistoricTaskInstanceEntity> allHiTaskEntitys, List<CommentEntity> allCommentEntitys, List<HistoricIdentityLinkEntity> allHiParticipants) {
        if (WfUtils.isEmpty((Long)hiActInst.getParentTaskId())) {
            node.setId(hiActInst.getId());
            node.setActId(hiActInst.getActivityId());
            node.setActType(hiActInst.getActivityType());
            node.setAssigneeId(hiActInst.getAssigneeId());
            node.setExecutionType(hiActInst.getExecutionType());
            node.setSkipReason(this.getSkipReasonCode(hiActInst.getSkipReason()));
            return;
        }
        HistoricTaskInstanceEntity historicTaskInstanceEntity = this.getHiTaskInstById(allHiTaskEntitys, hiActInst.getParentTaskId());
        if (historicTaskInstanceEntity == null) {
            return;
        }
        node.setId(historicTaskInstanceEntity.getId());
        node.setSubject(historicTaskInstanceEntity.getSubject());
        node.setAssigneeId(null);
        node.setCreateDate(historicTaskInstanceEntity.getCreateDate());
        node.setEndDate(historicTaskInstanceEntity.getEndTime());
        node.setExecutionType(historicTaskInstanceEntity.getExecutionType());
        CommentEntity parentComment = this.findCommentByTaskId(hiActInst.getParentTaskId(), allCommentEntitys);
        if (parentComment != null) {
            node.setAuditName(parentComment.getCommentResult());
            node.setApprovalMsg(parentComment.getCommentMessage());
            node.setAuditNumber(parentComment.getResultNumber());
            node.setAuditType(parentComment.getDecisionType());
        }
        ArrayList<NodeData> childNodeDatas = new ArrayList<NodeData>(10);
        List<HistoricActivityInstanceEntity> childHiActs = this.getHiActInstsByParentTaskId(hiActInsts, hiActInst.getParentTaskId());
        node.setActId(childHiActs.get(0).getActivityId());
        node.setActType(childHiActs.get(0).getActivityType());
        for (HistoricActivityInstanceEntity act : childHiActs) {
            NodeData childNode = new NodeData();
            childNode.setId(act.getId());
            childNode.setActId(act.getActivityId());
            childNode.setActType(act.getActivityType());
            childNode.setCreateDate(act.getCreateDate());
            childNode.setAssigneeId(act.getAssigneeId());
            childNode.setExecutionType(act.getExecutionType());
            childNode.setSkipReason(this.getSkipReasonCode(act.getSkipReason()));
            childNode.setEndDate(act.getEndTime());
            CommentEntity childComment = this.findCommentByTaskId(act.getTaskId(), allCommentEntitys);
            if (childComment != null) {
                childNode.setAuditName(childComment.getCommentResult());
                childNode.setApprovalMsg(childComment.getCommentMessage());
                childNode.setAuditNumber(childComment.getResultNumber());
                childNode.setAuditType(childComment.getDecisionType());
            }
            List<Long> participants = this.findHistoricIdentityLinksByTaskId(allHiParticipants, act.getTaskId());
            childNode.setParticipants(participants);
            if (this.currentActIds.contains(act.getId())) {
                childNode.setEndDate(null);
                node.setEndDate(null);
            }
            if ((historicTaskInstanceEntity = this.getHiTaskInstById(allHiTaskEntitys, act.getTaskId())) != null) {
                childNode.setSubject(historicTaskInstanceEntity.getSubject());
            }
            if (this.dynNodes.contains(childNode.getId())) {
                this.dynNodes.add(node.getId());
            }
            childNodeDatas.add(childNode);
            sourceElementIds.add(act.getId());
            hiActInsts.remove(act);
        }
        node.setChildNodes(childNodeDatas);
    }

    private void putProcessVariables(CommandContext commandContext, Long procInstId, ProcessInstData processInstData, Process process) {
        HistoricVariableInstanceEntityManager variableInstanceManager = commandContext.getHistoricVariableInstanceEntityManager();
        List variableEntitys = variableInstanceManager.findHistoricVariableInstancesByExecutionId(procInstId);
        if (WfUtils.isEmptyForCollection((Collection)variableEntitys)) {
            return;
        }
        ArrayList<ProcessVariableData> processVariables = new ArrayList<ProcessVariableData>(variableEntitys.size());
        List processVars = process.getVariables();
        for (HistoricVariableInstanceEntity variableEntity : variableEntitys) {
            if ("_operation_".equals(variableEntity.getName())) {
                processInstData.setOperation((String)variableEntity.getValue());
            }
            if (WfUtils.isEmptyForCollection((Collection)processVars)) continue;
            for (Variable processVar : processVars) {
                if (!processVar.getName().equals(variableEntity.getName())) continue;
                ProcessVariableData var = new ProcessVariableData();
                var.setName(variableEntity.getName());
                var.setValue(variableEntity.getValue());
                processVariables.add(var);
            }
        }
        processInstData.setVariables(processVariables);
    }

    private void dealDynNodeAndContinue(Process process, Process realProcess, NodeData node, HistoricActivityInstanceEntity currentActInst, List<HistoricActivityInstanceEntity> hiActInsts, Set<Long> sourceElementIds) {
        if (this.dynNodes.contains(node.getId())) {
            node.setIsDynamic(true);
        }
        if (node.getEndDate() == null) {
            return;
        }
        Map<Long, HistoricActivityInstanceEntity> nextNodes = this.getNextNodes(hiActInsts, sourceElementIds);
        if (WfUtils.isEmptyForMap(nextNodes)) {
            return;
        }
        HashSet<Long> paramOfNextNodeIds = new HashSet<Long>(nextNodes.size());
        HistoricActivityInstanceEntity dynFlow = null;
        boolean isYunzhijiaFirstAct = true;
        for (HistoricActivityInstanceEntity flowNode : nextNodes.values()) {
            if ("YunzhijiaTask".equals(flowNode.getActivityType()) && WfUtils.isNotEmpty((Long)flowNode.getParentTaskId())) {
                paramOfNextNodeIds.add(flowNode.getParentTaskId());
                if (isYunzhijiaFirstAct) {
                    this.nodeDataLink.add(flowNode);
                    isYunzhijiaFirstAct = false;
                }
            } else {
                paramOfNextNodeIds.add(flowNode.getId());
                this.nodeDataLink.add(flowNode);
            }
            if (process.getFlowElement(flowNode.getActivityId()) != null || !"SequenceFlow".equals(flowNode.getActivityType())) continue;
            dynFlow = flowNode;
            break;
        }
        node.setNextNodeIds(new ArrayList(paramOfNextNodeIds));
        if (WfUtils.isEmptyForCollection(paramOfNextNodeIds) && WfUtils.isNotEmpty((Long)currentActInst.getTargetElementId())) {
            paramOfNextNodeIds.add(currentActInst.getTargetElementId());
            node.setNextNodeIds(new ArrayList(paramOfNextNodeIds));
        }
        if (dynFlow == null) {
            return;
        }
        ArrayList<HistoricActivityInstanceEntity> dynNextNodes = new ArrayList<HistoricActivityInstanceEntity>(5);
        Map<Long, HistoricActivityInstanceEntity> dynFlowNextNodes = this.getNextNodes(hiActInsts, new HashSet<Long>(nextNodes.keySet()));
        for (HistoricActivityInstanceEntity nextNode : dynFlowNextNodes.values()) {
            dynNextNodes.add(nextNode);
        }
        if ("reject".equals(node.getAuditType()) || "forceReject".equals(node.getAuditType())) {
            node.setDynType("dynReject");
            this.dynNodes.add(dynFlow.getId());
        } else if ("addsignbefore".equalsIgnoreCase(node.getExecutionType())) {
            node.setDynType("addsignbefore");
            this.dynNodes.add(dynFlow.getId());
            this.addDynNodes(dynNextNodes);
            this.setAddSignInfo(node, realProcess, dynNextNodes);
        } else if ("jump".equals(node.getExecutionType())) {
            node.setDynType("dynJump");
            this.dynNodes.add(dynFlow.getId());
        } else if (WfUtils.isNotEmptyForCollection(dynNextNodes)) {
            String stencilType = ((HistoricActivityInstanceEntity)dynNextNodes.get(0)).getActivityType();
            if ("EndTerminateEvent".equals(stencilType) || "EndErrorEvent".equals(stencilType) || "EndCancelEvent".equals(stencilType)) {
                node.setDynType("terminateEvent");
            } else {
                node.setDynType("addsignafter");
                this.setAddSignInfo(node, realProcess, dynNextNodes);
            }
            this.dynNodes.add(dynFlow.getId());
            this.addDynNodes(dynNextNodes);
        }
    }

    private void setAddSignInfo(NodeData node, Process realProcess, List<HistoricActivityInstanceEntity> dynNextNodes) {
        if (WfUtils.isEmptyForCollection(dynNextNodes)) {
            return;
        }
        ILocaleString dynNextNodeName = dynNextNodes.get(0).getActivityName();
        String dynNextNodeNumber = dynNextNodes.get(0).getActivityId();
        HashMap<String, Object> extraParams = new HashMap<String, Object>(3);
        FlowElement flowElement = realProcess.getFlowElement(dynNextNodeNumber);
        if (flowElement == null) {
            return;
        }
        if (flowElement instanceof YunzhijiaTask) {
            YunzhijiaTask yunzhijiaTask = (YunzhijiaTask)flowElement;
            extraParams.put("addSignYunzhijiaBusinessMode", yunzhijiaTask.getBusinessModel());
        }
        if (flowElement instanceof AuditTask) {
            AuditTask auditTask = (AuditTask)flowElement;
            extraParams.put("addSingMsg", auditTask.getAddSignMsg());
        }
        ArrayList<ILocaleString> addSignNodeNames = new ArrayList<ILocaleString>(1);
        addSignNodeNames.add(dynNextNodeName);
        extraParams.put("addSignNodeNames", addSignNodeNames);
        node.setExtraParams(extraParams);
    }

    private void addDynNodes(List<HistoricActivityInstanceEntity> dynNextNodes) {
        if (WfUtils.isNotEmptyForCollection(dynNextNodes)) {
            for (HistoricActivityInstanceEntity dynNode : dynNextNodes) {
                this.dynNodes.add(dynNode.getId());
            }
        }
    }

    private Map<Long, HistoricActivityInstanceEntity> getNextNodes(List<HistoricActivityInstanceEntity> hiActInsts, Set<Long> sourceElementIds) {
        HashMap<Long, HistoricActivityInstanceEntity> nextNodes = new HashMap<Long, HistoricActivityInstanceEntity>(5);
        if (WfUtils.isEmptyForCollection(hiActInsts) || WfUtils.isEmptyForCollection(sourceElementIds)) {
            return nextNodes;
        }
        for (HistoricActivityInstanceEntity hiActEntity : hiActInsts) {
            if (!sourceElementIds.contains(hiActEntity.getSourceElementId())) continue;
            nextNodes.put(hiActEntity.getId(), hiActEntity);
        }
        return nextNodes;
    }

    private List<Long> findHistoricIdentityLinksByTaskId(List<HistoricIdentityLinkEntity> allHiParticipants, Long taskId) {
        ArrayList<Long> participants = new ArrayList<Long>(10);
        if (WfUtils.isEmptyForCollection(allHiParticipants) || WfUtils.isEmpty((Long)taskId)) {
            return participants;
        }
        for (HistoricIdentityLinkEntity participant : allHiParticipants) {
            if (!taskId.equals(participant.getTaskId())) continue;
            participants.add(participant.getUserId());
        }
        return participants;
    }

    private List<HistoricActivityInstanceEntity> getHiActInstsByParentTaskId(List<HistoricActivityInstanceEntity> hiActInsts, Long parentTaskId) {
        ArrayList<HistoricActivityInstanceEntity> childHiActEntitys = new ArrayList<HistoricActivityInstanceEntity>(10);
        if (WfUtils.isEmptyForCollection(hiActInsts) || WfUtils.isEmpty((Long)parentTaskId)) {
            return childHiActEntitys;
        }
        for (HistoricActivityInstanceEntity hiActEntity : hiActInsts) {
            if (!parentTaskId.equals(hiActEntity.getParentTaskId())) continue;
            childHiActEntitys.add(hiActEntity);
        }
        return childHiActEntitys;
    }

    private HistoricTaskInstanceEntity getHiTaskInstById(List<HistoricTaskInstanceEntity> allHiTaskEntitys, Long taskId) {
        if (WfUtils.isEmptyForCollection(allHiTaskEntitys) || WfUtils.isEmpty((Long)taskId)) {
            return null;
        }
        for (HistoricTaskInstanceEntity hiTaskEntity : allHiTaskEntitys) {
            if (!taskId.equals(hiTaskEntity.getId())) continue;
            return hiTaskEntity;
        }
        return null;
    }

    private CommentEntity findCommentByTaskId(Long taskId, List<CommentEntity> allCommentEntitys) {
        if (WfUtils.isEmptyForCollection(allCommentEntitys) || WfUtils.isEmpty((Long)taskId)) {
            return null;
        }
        for (CommentEntity comment : allCommentEntitys) {
            if (!taskId.equals(comment.getTaskId()) || !"comment".equals(comment.getType())) continue;
            return comment;
        }
        return null;
    }

    private CommentEntity findCalledProcessInstanceId(Long calledProcessInstanceId, List<CommentEntity> allCommentEntitys) {
        if (WfUtils.isEmptyForCollection(allCommentEntitys) || WfUtils.isEmpty((Long)calledProcessInstanceId)) {
            return null;
        }
        for (CommentEntity comment : allCommentEntitys) {
            if (!calledProcessInstanceId.equals(comment.getSubProcessInstanceId())) continue;
            return comment;
        }
        return null;
    }

    private String getSkipReasonCode(ILocaleString skipReason) {
        String skipReasonZhCN;
        String skipReasonCode = " ";
        if (WfUtils.isEmpty((ILocaleString)skipReason)) {
            return skipReasonCode;
        }
        switch (skipReasonZhCN = (String)skipReason.get((Object)"zh_CN")) {
            case "\u7b2c\u4e00\u4e2a\u4eba\u5de5\u4efb\u52a1": {
                skipReasonCode = "FirstUserTask";
                break;
            }
            case "\u975e\u542f\u52a8\u8282\u70b9\u8df3\u8fc7": {
                skipReasonCode = "nonBootNode";
                break;
            }
            case "\u542f\u52a8\u8282\u70b9\u8df3\u8fc7": {
                skipReasonCode = "bootNode";
                break;
            }
            case "\u6ee1\u8db3\u5ffd\u7565\u6761\u4ef6": {
                skipReasonCode = "MeetSkipCondition";
                break;
            }
            case "\u65e0\u53c2\u4e0e\u4eba\u4e14\u8282\u70b9\u914d\u7f6e\u5141\u8bb8\u65e0\u53c2\u4e0e\u4eba": {
                skipReasonCode = "NoParticipant";
                break;
            }
            case "\u524d\u5e8f\u8282\u70b9\u76f8\u540c\u53c2\u4e0e\u4eba\u5df2\u5ba1\u6279": {
                skipReasonCode = "SameParticipant";
                break;
            }
            case "\u52a8\u6001\u8df3\u8fc7": {
                skipReasonCode = "DynamicJump";
                break;
            }
            case "\u5f3a\u5236\u7ec8\u6b62": {
                skipReasonCode = "ForceAbort";
                break;
            }
            case "\u7236\u6d41\u7a0b\u7ec8\u6b62": {
                skipReasonCode = "ParentProcessAbort";
                break;
            }
            case "\u7236\u6d41\u7a0b\u8df3\u8f6c": {
                skipReasonCode = "ParentProcessJump";
                break;
            }
            case "\u7236\u6d41\u7a0b\u6574\u5355\u64a4\u56de": {
                skipReasonCode = "parentProcessWithdraw";
                break;
            }
            case "\u4eba\u5de5\u8df3\u8f6c": {
                skipReasonCode = "PersonJump";
                break;
            }
            case "\u8fc7\u671f\u8df3\u8fc7": {
                skipReasonCode = "ExpireSkip";
                break;
            }
            case "\u81ea\u52a8\u5ba1\u6279": {
                skipReasonCode = "AUTOAUDIT";
                break;
            }
            case "\u51bb\u7ed3": {
                skipReasonCode = "FROZEN";
                break;
            }
            case "\u6574\u5355\u5f3a\u5236\u64a4\u56de": {
                skipReasonCode = "BillAbort";
                break;
            }
            case "\u6574\u5355\u64a4\u56de\u5f3a\u5236\u8df3\u8f6c\u81f3\u4eba\u5de5": {
                skipReasonCode = "BillWithdrawJump";
                break;
            }
            case "\u52a0\u7b7e\u8df3\u8f6c": {
                skipReasonCode = "AddSignBeforeJump";
                break;
            }
            case "\u5355\u636e\u4f8b\u5916\u7ec8\u6b62": {
                skipReasonCode = "BillExcepAbort";
                break;
            }
            case "\u5f02\u5e38\u7ec8\u6b62": {
                skipReasonCode = "TerminateProcWhenExceptionOccurs";
                break;
            }
            default: {
                skipReasonCode = " ";
            }
        }
        return skipReasonCode;
    }
}

