/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.process.make;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.devops.process.make.DefaultMaker;
import kd.bos.workflow.devops.process.make.IMigrator;
import kd.bos.workflow.devops.process.make.MigrateContext;
import kd.bos.workflow.devops.process.make.NodeOperation;
import kd.bos.workflow.devops.process.make.node.AuditTaskMaker;
import kd.bos.workflow.devops.process.make.node.CallActivityMultiInstanceMaker;
import kd.bos.workflow.devops.process.make.node.EndEventMaker;
import kd.bos.workflow.devops.process.make.node.UserTaskMaker;
import kd.bos.workflow.devops.process.make.node.WaitTaskMaker;
import kd.bos.workflow.devops.process.make.node.YunzhijiaMultiInstanceMaker;
import kd.bos.workflow.engine.WfPermUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.deploy.DeploymentManager;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.DynamicConfigSchemeEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.util.ProcessDefinitionUtil;
import kd.bos.workflow.engine.impl.util.ProcessInstanceHelper;
import kd.bos.workflow.engine.process.NodeData;
import kd.bos.workflow.engine.process.ProcessInstData;
import kd.bos.workflow.engine.process.ProcessVariableData;
import kd.bos.workflow.engine.repository.ProcessDefinition;
import kd.bos.workflow.exception.WFEngineException;
import kd.bos.workflow.exception.WFException;
import kd.bos.workflow.exception.WFObjectNotFoundException;

public class ProcessInstMakeCmd
implements Command<Void> {
    private static Log log = LogFactory.getLog(ProcessInstMakeCmd.class);
    private Long rootProInstId;
    private Long superExecutionId;
    private ProcessInstData processInstData;

    public ProcessInstMakeCmd(ProcessInstData processInstData) {
        this.processInstData = processInstData;
    }

    public ProcessInstMakeCmd(Long rootProInstId, Long superExecutionId, ProcessInstData processInstData) {
        this.rootProInstId = rootProInstId;
        this.superExecutionId = superExecutionId;
        this.processInstData = processInstData;
    }

    public Void execute(CommandContext commandContext) {
        if (!WfPermUtils.hasTaskHandlerPerm((String)"api_v2")) {
            throw new WFException(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u4efb\u52a1\u5904\u7406\u6743\u9650\uff0c\u4e0d\u80fd\u8c03\u7528\u6d41\u7a0b\u6570\u636e\u8fc1\u79fb\u63a5\u53e3\u3002", (String)"ProcessInstMakeCmd_1", (String)"bos-wf-devops", (Object[])new Object[0]));
        }
        if (this.processInstData == null || WfUtils.isEmptyForCollection((Collection)this.processInstData.getNodeList())) {
            throw new WFException(ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff0c\u6d41\u7a0b\u6570\u636e\u6216\u8282\u70b9\u6570\u636e\u4e3a\u7a7a\u3002", (String)"ProcessInstMakeCmd_2", (String)"bos-wf-devops", (Object[])new Object[0]));
        }
        MigrateContext context = this.initMigrateContext(commandContext);
        this.initProcdefInfo(context);
        log.debug(String.format("\u5f00\u59cb\u521d\u59cb\u5316\u6d41\u7a0b\u5b9e\u4f8b[businessKey = %s]", this.processInstData.getBusinessKey()));
        this.createProcInstInfo(context);
        log.debug(String.format("\u521d\u59cb\u5316\u6d41\u7a0b\u5b9e\u4f8b\u6210\u529f[businessKey = %s, procInstId = %s]", this.processInstData.getBusinessKey(), context.getProcessInstanceExecution().getId()));
        context.planNodeOperation((ExecutionEntity)context.getProcessInstanceExecution().getExecutions().get(0), this.getStartEventAct(context));
        this.planAndExecute(context);
        this.saveVariables(context);
        this.updateProcessInst(commandContext, context.getProcessInstanceExecution());
        return null;
    }

    private void saveVariables(MigrateContext context) {
        List vars = this.processInstData.getVariables();
        if (WfUtils.isEmptyForCollection((Collection)vars)) {
            return;
        }
        for (ProcessVariableData var : vars) {
            context.getProcessInstanceExecution().setVariable(var.getName(), var.getValue());
        }
        context.getProcessInstanceExecution().setVariable("migration", (Object)true);
    }

    private MigrateContext initMigrateContext(CommandContext commandContext) {
        MigrateContext migrateContext = new MigrateContext();
        migrateContext.setCommandContext(commandContext);
        migrateContext.setAllNodes(this.initNodeMap());
        return migrateContext;
    }

    private void planAndExecute(MigrateContext context) {
        LinkedList<NodeOperation> agenda = context.getAgenda();
        ArrayList<Long> migratedNodes = new ArrayList<Long>(this.processInstData.getNodeList().size());
        log.debug(String.format("\u6d41\u7a0b\u5b9e\u4f8b[id = %s]\u5f00\u59cb\u8fdb\u884c\u8282\u70b9\u8fc1\u79fb", context.getProcessInstanceExecution().getId()));
        int count = 0;
        while (!agenda.isEmpty()) {
            if (count > 5000) {
                throw new WFException(ResManager.loadKDString((String)"\u8fc1\u79fb\u7684\u8282\u70b9\u6570\u91cf\u5df2\u8fbe\u4e0a\u96505000\u6b21\uff0c\u8bf7\u6392\u67e5\u53c2\u6570\u662f\u5426\u51fa\u73b0\u6b7b\u5faa\u73af", (String)"ProcessInstMakeCmd_3", (String)"bos-wf-devops", (Object[])new Object[0]));
            }
            NodeOperation operation = agenda.poll();
            NodeData nodeData = operation.getNodeData();
            log.debug(String.format("\u5f00\u59cb\u8fc1\u79fb\u8282\u70b9\uff0cnodeId : %s", nodeData.getId()));
            if (migratedNodes.contains(nodeData.getId())) {
                throw new WFException(String.format(ResManager.loadKDString((String)"id\u4e3a[%s]\u7684\u8282\u70b9\u6570\u636e\u51fa\u73b0\u4e86\u4e24\u6b21\u53ca\u4e24\u6b21\u4ee5\u4e0a\uff0c\u8bf7\u68c0\u67e5\u8282\u70b9\u6570\u636e", (String)"ProcessInstMakeCmd_4", (String)"bos-wf-devops", (Object[])new Object[0]), nodeData.getId()));
            }
            IMigrator migrator = this.getMigrator(nodeData);
            if (migrator.migrate(context, operation)) {
                migratedNodes.add(nodeData.getId());
                log.debug(String.format("\u8282\u70b9\u8fc1\u79fb\u5b8c\u6210\uff0cnodeId : %s", nodeData.getId()));
            } else {
                log.debug(String.format("\u8282\u70b9\u8fc1\u79fb\u672a\u5b8c\u6210\uff0c\u7b49\u5f85\u6c47\u805a\u3002nodeId : %s", nodeData.getId()));
            }
            ++count;
        }
    }

    private IMigrator getMigrator(NodeData nodeData) {
        String stencilType;
        switch (stencilType = nodeData.getActType()) {
            case "CallActivity": {
                return new CallActivityMultiInstanceMaker();
            }
            case "UserTask": {
                return new UserTaskMaker();
            }
            case "AuditTask": 
            case "SSCApprove": {
                return new AuditTaskMaker();
            }
            case "EndNoneEvent": 
            case "EndErrorEvent": 
            case "EndCancelEvent": 
            case "EndTerminateEvent": {
                return new EndEventMaker();
            }
            case "YunzhijiaTask": {
                return new YunzhijiaMultiInstanceMaker();
            }
            case "WaitTask": {
                return new WaitTaskMaker();
            }
            case "SSCImageUpload": 
            case "SSCImageUploadNew": {
                throw new WFException(ResManager.loadKDString((String)"\u8fc1\u79fb\u63a5\u53e3\u6682\u4e0d\u652f\u6301\u542b\u5f71\u50cf\u4e0a\u4f20\u8282\u70b9\u7684\u6d41\u7a0b", (String)"ProcessInstMakeCmd_6", (String)"bos-wf-devops", (Object[])new Object[0]));
            }
        }
        return new DefaultMaker();
    }

    private Map<Long, NodeData> initNodeMap() {
        HashMap<Long, NodeData> allNodes = new HashMap<Long, NodeData>(this.processInstData.getNodeList().size());
        for (NodeData nodeData : this.processInstData.getNodeList()) {
            allNodes.put(nodeData.getId(), nodeData);
        }
        return allNodes;
    }

    private void initProcdefInfo(MigrateContext context) {
        CommandContext commandContext = context.getCommandContext();
        if (WfUtils.isEmpty((Long)this.processInstData.getProcDefId())) {
            throw new WFException(ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\uff0c\u6d41\u7a0b\u5b9a\u4e49ID\u4e3a\u7a7a", (String)"ProcessInstMakeCmd_7", (String)"bos-wf-devops", (Object[])new Object[0]));
        }
        Long schemeId = this.processInstData.getSchemeId();
        if (WfUtils.isEmpty((Long)schemeId)) {
            DynamicConfigSchemeEntity dynamicSchemeEntity = commandContext.getDynamicConfigSchemeEntityManager().getDefaultSchemeByProcDefId(this.processInstData.getProcDefId());
            if (dynamicSchemeEntity == null) {
                throw new WFObjectNotFoundException("No dynamicScheme found for procdefid = '" + this.processInstData.getProcDefId() + "'", DynamicConfigSchemeEntity.class);
            }
            schemeId = dynamicSchemeEntity.getId();
        }
        context.setSchemeId(schemeId);
        DeploymentManager deploymentCache = commandContext.getProcessEngineConfiguration().getDeploymentManager();
        ProcessDefinition processDefinition = deploymentCache.findDeployedProcessDefinitionById(this.processInstData.getProcDefId());
        if (processDefinition == null) {
            throw new WFObjectNotFoundException("No process definition found for id = '" + this.processInstData.getProcDefId() + "'", ProcessDefinition.class);
        }
        context.setProcessDefinition(processDefinition);
        Process process = ProcessDefinitionUtil.getProcessBySchemeId((Long)schemeId);
        if (process == null) {
            throw new WFEngineException("Cannot start process instance. Process model " + processDefinition.getName() + " (id = " + processDefinition.getId() + ") could not be found");
        }
        context.setProcess(process);
    }

    private void createProcInstInfo(MigrateContext context) {
        CommandContext commandContext = context.getCommandContext();
        ProcessDefinition processDefinition = context.getProcessDefinition();
        Process process = context.getProcess();
        HashMap<String, Object> variables = new HashMap<String, Object>(16);
        variables.put("entityNumber", this.processInstData.getEntityNumber());
        variables.put("_initiator_", this.processInstData.getInitor().toString());
        variables.put("SCHEMEID", context.getSchemeId());
        variables.put("_operation_", this.processInstData.getOperation());
        variables.put("processType", ((ProcessDefinitionEntityImpl)processDefinition).getType());
        variables.put("rootProcessInstanceId", this.rootProInstId);
        variables.put("superExecutionId", this.superExecutionId);
        ProcessInstanceHelper processInstanceHelper = commandContext.getProcessEngineConfiguration().getProcessInstanceHelper();
        ExecutionEntity processInstanceExecution = (ExecutionEntity)processInstanceHelper.createAndStartProcessInstanceWithInitialFlowElement(processDefinition, this.processInstData.getBusinessKey(), null, process.getInitialFlowElement(), process, variables, null, false);
        context.setProcessInstanceExecution(processInstanceExecution);
        BpmnModel bpm = ProcessDefinitionUtil.getBpmnModel((Long)processInstanceExecution.getProcessDefinitionId(), (Long)processInstanceExecution.getProcessInstanceId());
        boolean isAutoProcess = bpm.isAutoFlow();
        if (isAutoProcess) {
            context.setAutoProcess(isAutoProcess);
        }
        this.updateProcessInst(commandContext, processInstanceExecution);
        ExecutionEntity execution = (ExecutionEntity)processInstanceExecution.getExecutions().get(0);
        execution.setCreateDate(this.processInstData.getCreateDate());
        execution.setModifyDate(this.processInstData.getCreateDate());
        commandContext.getExecutionEntityManager().update((Entity)execution);
    }

    private void updateProcessInst(CommandContext commandContext, ExecutionEntity processInstanceExecution) {
        processInstanceExecution.setSubject(this.processInstData.getSubject());
        processInstanceExecution.setCreateDate(this.processInstData.getCreateDate());
        processInstanceExecution.setModifyDate(this.processInstData.getCreateDate());
        commandContext.getExecutionEntityManager().update((Entity)processInstanceExecution);
        HistoricProcessInstanceEntity hisEntity = (HistoricProcessInstanceEntity)commandContext.getHistoricProcessInstanceEntityManager().findById(processInstanceExecution.getId());
        hisEntity.setSubject(this.processInstData.getSubject());
        hisEntity.setCreateDate(this.processInstData.getCreateDate());
        hisEntity.setModifyDate(this.processInstData.getCreateDate());
        commandContext.getHistoricProcessInstanceEntityManager().update((Entity)hisEntity);
    }

    private NodeData getStartEventAct(MigrateContext context) {
        for (NodeData nodeData : this.processInstData.getNodeList()) {
            if (!context.getProcess().getInitialFlowElement().getType().equals(nodeData.getActType())) continue;
            return nodeData;
        }
        throw new WFEngineException(ResManager.loadKDString((String)"\u5728\u4f20\u5165\u7684\u8282\u70b9\u6570\u636e\u4e2d\u672a\u5339\u914d\u5230\u5f00\u59cb\u8282\u70b9", (String)"ProcessInstMakeCmd_8", (String)"bos-wf-devops", (Object[])new Object[0]));
    }
}

