/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.process.make.node;

import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.workflow.bpmn.model.Activity;
import kd.bos.workflow.bpmn.model.CallActivity;
import kd.bos.workflow.devops.process.make.NodeOperation;
import kd.bos.workflow.devops.process.make.node.CallActivityMaker;
import kd.bos.workflow.devops.process.make.node.MultiInstanceMaker;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntity;

public class CallActivityMultiInstanceMaker
extends MultiInstanceMaker {
    @Override
    public void doMigrate() {
        this.loopCharacteristics = ((Activity)this.flowElement).getLoopCharacteristics();
        if (this.skipNode()) {
            return;
        }
        this.createInstances();
        if (this.nodeData.getEndDate() != null) {
            this.leave((Activity)this.flowElement);
        }
    }

    @Override
    protected void handleTaskLeave(Activity flowElement) {
        CommandContext commandContext = this.context.getCommandContext();
        CallActivity callActivity = (CallActivity)flowElement;
        CommentEntity comment = (CommentEntity)commandContext.getCommentEntityManager().create();
        comment.setActivityId(this.execution.getCurrentActivityId());
        comment.setType("message");
        comment.setTime(this.nodeData.getEndDate());
        comment.setProcessInstanceId(this.execution.getProcessInstanceId());
        comment.setStep(commandContext.getCommentEntityManager().calculateStep(this.execution.getProcessInstanceId()));
        comment.setActivityName((ILocaleString)new LocaleString(callActivity.getCallProcessName()));
        Long callProcessInstId = (Long)this.execution.getVariable(String.format("%s.%s", this.execution.getCurrentActivityId(), "subProcessInstanceId"));
        if (WfUtils.isNotEmpty((Long)callProcessInstId)) {
            comment.setSubProcessInstanceId(callProcessInstId);
        }
        ILocaleString message = this.nodeData.getApprovalMsg();
        comment.setMessage(message);
        commandContext.getCommentEntityManager().insert((Entity)comment);
    }

    private boolean skipNode() {
        CommandContext commandContext = this.context.getCommandContext();
        if ("skip".equals(this.nodeData.getExecutionType())) {
            this.recordActStart();
            commandContext.getHistoryManager().recordActivityExecutionType(this.execution, "skip", this.nodeData.getSkipReason());
            this.recordActEnd();
            return true;
        }
        return false;
    }

    @Override
    protected void planChildExecution(ExecutionEntity subExecution, int loopCounter) {
        NodeOperation operation = new NodeOperation(this.nodeData, subExecution);
        new CallActivityMaker().migrate(this.context, operation);
    }

    @Override
    protected int getInstanceCount() {
        return 1;
    }
}

