/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.process.make.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.workflow.bpmn.model.Activity;
import kd.bos.workflow.bpmn.model.MultiInstanceLoopCharacteristics;
import kd.bos.workflow.devops.process.make.node.UserTaskMaker;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntityManager;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.bos.workflow.engine.impl.util.DynamicFlowUtil;
import kd.bos.workflow.engine.process.NodeData;
import kd.bos.workflow.exception.WFIllegalArgumentException;

public abstract class MultiInstanceMaker
extends UserTaskMaker {
    private static final String NUMBER_OF_INSTANCES = "nrOfInstances";
    private static final String NUMBER_OF_ACTIVE_INSTANCES = "nrOfActiveInstances";
    private static final String NUMBER_OF_COMPLETED_INSTANCES = "nrOfCompletedInstances";
    protected MultiInstanceLoopCharacteristics loopCharacteristics;

    protected int createInstances() {
        int nrOfInstances = this.getInstanceCount();
        if (nrOfInstances < 0) {
            throw new WFIllegalArgumentException("Invalid number of instances: must be non-negative integer value, but was " + nrOfInstances);
        }
        this.execution.setMultiInstanceRoot(true);
        this.setLoopVariable((DelegateExecution)this.execution, NUMBER_OF_INSTANCES, nrOfInstances);
        this.setLoopVariable((DelegateExecution)this.execution, NUMBER_OF_COMPLETED_INSTANCES, 0);
        this.setLoopVariable((DelegateExecution)this.execution, NUMBER_OF_ACTIVE_INSTANCES, nrOfInstances);
        ArrayList<ExecutionEntity> concurrentExecutions = new ArrayList<ExecutionEntity>(nrOfInstances);
        for (int loopCounter = 0; loopCounter < nrOfInstances; ++loopCounter) {
            ExecutionEntity concurrentExecution = Context.getCommandContext().getExecutionEntityManager().createChildExecution(this.execution);
            concurrentExecution.setCurrentFlowElement(this.flowElement);
            concurrentExecution.setActive(true);
            concurrentExecution.setScope(false);
            concurrentExecution.setActivityName(this.execution.getActivityName());
            concurrentExecutions.add(concurrentExecution);
        }
        String comingInWay = DynamicFlowUtil.getComingInWay((DelegateExecution)this.execution, (String)this.execution.getCurrentActivityId());
        for (int loopCounter = 0; loopCounter < nrOfInstances; ++loopCounter) {
            ExecutionEntity concurrentExecution = (ExecutionEntity)concurrentExecutions.get(loopCounter);
            if (!concurrentExecution.isActive() || concurrentExecution.isEnded() || !concurrentExecution.getParent().isActive() || concurrentExecution.getParent().isEnded()) continue;
            this.setLoopVariable((DelegateExecution)concurrentExecution, "comingInWay", comingInWay);
            this.setLoopVariable((DelegateExecution)concurrentExecution, this.loopCharacteristics.getElementIndexVariable(), loopCounter);
            if ("CallActivity".equals(this.nodeData.getActType())) {
                this.setLoopVariable((DelegateExecution)concurrentExecution, this.loopCharacteristics.getElementVariable(), this.nodeData.getChildProcess().getBusinessKey());
            } else {
                this.setLoopVariable((DelegateExecution)concurrentExecution, this.loopCharacteristics.getElementVariable(), ((NodeData)this.nodeData.getChildNodes().get(loopCounter)).getAssigneeId());
            }
            concurrentExecution.setCurrentFlowElement(this.flowElement);
            this.planChildExecution(concurrentExecution, loopCounter);
        }
        if (!concurrentExecutions.isEmpty()) {
            this.execution.setActive(false);
        }
        return nrOfInstances;
    }

    protected abstract int getInstanceCount();

    protected abstract void planChildExecution(ExecutionEntity var1, int var2);

    protected void setLoopVariable(DelegateExecution execution, String variableName, Object value) {
        execution.setVariableLocal(variableName, value);
    }

    protected void removeLocalLoopVariable(DelegateExecution execution, String variableName) {
        execution.removeVariableLocal(variableName);
    }

    protected void leave(Activity activity) {
        this.deleteChildExecutions(this.execution, false);
        this.removeLocalLoopVariable((DelegateExecution)this.execution, this.loopCharacteristics.getElementIndexVariable());
        this.execution.setScope(false);
        this.execution.setActive(true);
        this.execution.setMultiInstanceRoot(false);
        WfCacheHelper.removeSerialJobIds((String)this.execution.getId().toString());
        this.handleTaskLeave(activity);
    }

    protected void deleteChildExecutions(ExecutionEntity parentExecution, boolean deleteExecution) {
        CommandContext commandContext = this.context.getCommandContext();
        ExecutionEntityManager executionEntityManager = commandContext.getExecutionEntityManager();
        List childExecutions = executionEntityManager.findChildExecutionsByParentExecutionId(parentExecution.getId());
        if (CollectionUtil.isNotEmpty((Collection)childExecutions)) {
            for (ExecutionEntity childExecution : childExecutions) {
                this.deleteChildExecutions(childExecution, true);
            }
        }
        if (!(!deleteExecution || WfUtils.isNotEmpty((String)parentExecution.getActivityId()) && parentExecution.getActivityId().contains("BoundaryEvent"))) {
            executionEntityManager.deleteExecutionAndRelatedData(parentExecution, null, false);
            parentExecution.removeTransientVariable("endDate");
        }
    }

    protected abstract void handleTaskLeave(Activity var1);
}

