/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.process.make.node;

import java.util.Collection;
import java.util.HashMap;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.workflow.bizflow.util.BizFlowUtil;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.devops.process.make.DefaultMaker;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.impl.bpmn.behavior.TaskBehaviorUtil;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntityManager;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.TaskHelper;

public class UserTaskMaker
extends DefaultMaker {
    protected TaskEntity task;

    @Override
    protected void selfBehave() {
        CommandContext commandContext = this.context.getCommandContext();
        if (this.context.isAutoProcess()) {
            return;
        }
        this.startTask();
        if (this.nodeData.getEndDate() != null) {
            this.completeTask();
            HistoricTaskInstanceEntity hiTask = (HistoricTaskInstanceEntity)commandContext.getHistoricTaskInstanceEntityManager().findById(this.task.getId());
            if (hiTask != null) {
                hiTask.setCreateDate(this.nodeData.getCreateDate());
                hiTask.setModifyDate(this.nodeData.getCreateDate());
                hiTask.setEndTime(this.nodeData.getEndDate());
                hiTask.setDurationInMillis(Long.valueOf(this.nodeData.getEndDate().getTime() - this.nodeData.getCreateDate().getTime()));
                hiTask.setRealDurationInMillis(Long.valueOf(this.nodeData.getEndDate().getTime() - this.nodeData.getCreateDate().getTime()));
                commandContext.getHistoricTaskInstanceEntityManager().update((Entity)hiTask);
            }
        }
    }

    protected void startTask() {
        CommandContext commandContext = this.context.getCommandContext();
        this.task = TaskBehaviorUtil.buildTaskEntity((DelegateExecution)this.execution, (UserTask)((UserTask)this.flowElement));
        this.task.setCreateDate(this.nodeData.getCreateDate());
        this.task.setModifyDate(this.nodeData.getCreateDate());
        this.task.setSubject(this.nodeData.getSubject());
        TaskEntityManager taskEntityManager = commandContext.getTaskEntityManager();
        taskEntityManager.insert(this.task, this.execution);
        this.execution.setCurrentTask(this.task);
        this.execution.setCurrentTaskId(this.task.getId());
        if (WfUtils.isNotEmpty((Long)this.task.getParentTaskId()) && WfUtils.isNotEmpty((Long)this.execution.getParentId())) {
            this.execution.getParent().setCurrentTask(this.task.getParentTaskInstance());
            this.execution.getParent().setCurrentTaskId(this.task.getParentTaskId());
        }
        if (WfUtils.isNotEmptyForCollection((Collection)this.nodeData.getParticipants())) {
            this.task.addUserIdentityLinks(this.nodeData.getParticipants(), "participant");
        }
    }

    protected void completeTask() {
        CommandContext commandContext = this.context.getCommandContext();
        TaskHelper taskHelper = commandContext.getProcessEngineConfiguration().getTaskHelper();
        TaskEntityManager taskEntityManager = commandContext.getTaskEntityManager();
        boolean isSkip = "skip".equals(this.nodeData.getExecutionType()) || WfUtils.isEmpty((String)this.nodeData.getAuditNumber()) || WfUtils.isEmpty((ILocaleString)this.nodeData.getApprovalMsg());
        boolean isFirstUserTask = false;
        if (BpmnModelUtil.isSkipFirstUserTaskByPath((DelegateExecution)this.execution)) {
            isSkip = false;
            isFirstUserTask = true;
        }
        if (isSkip) {
            this.skipTask();
            return;
        }
        boolean parentAudit = BizFlowUtil.isAuditFlowExecution((ExecutionEntity)this.execution.getSuperExecution());
        if (!parentAudit || !this.flowElement.getClass().getName().equalsIgnoreCase(UserTask.class.getName())) {
            this.addComment(this.task);
        }
        this.setVariables();
        taskEntityManager.changeTaskAssignee(this.task, this.nodeData.getAssigneeId(), null);
        taskHelper.updateHistoricIdentityLinkEntities(commandContext, this.task.getId(), this.nodeData.getAssigneeId());
        if (isFirstUserTask) {
            this.markFirstUserTaskEnd();
        } else {
            this.markTaskEnd();
        }
    }

    private void skipTask() {
        CommandContext commandContext = this.context.getCommandContext();
        commandContext.getTaskEntityManager().changeTaskExecutionType(this.task, "skip");
        commandContext.getTaskHelper().deleteTaskEntity(this.task, "task skip", false, false);
        commandContext.getHistoryManager().recordActivityExecutionType(this.execution, "skip", this.nodeData.getSkipReason());
    }

    private void markFirstUserTaskEnd() {
        CommandContext commandContext = this.context.getCommandContext();
        TaskHelper taskHelper = commandContext.getProcessEngineConfiguration().getTaskHelper();
        TaskEntityManager taskEntityManager = commandContext.getTaskEntityManager();
        taskEntityManager.changeTaskExecutionType(this.task, "skip");
        taskHelper.deleteTaskEntity(this.task, "first_usertask_skip", false, false);
        commandContext.getHistoryManager().recordActivityExecutionType(this.execution, "skip", "FirstUserTask");
    }

    private void markTaskEnd() {
        CommandContext commandContext = this.context.getCommandContext();
        TaskHelper taskHelper = commandContext.getProcessEngineConfiguration().getTaskHelper();
        taskHelper.deleteTaskEntity(this.task, "task complete", false, false);
    }

    protected CommentEntity addComment(TaskEntity task) {
        CommandContext commandContext = this.context.getCommandContext();
        ILocaleString approvalMessage = this.nodeData.getApprovalMsg();
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("auditNumber", this.nodeData.getAuditNumber());
        vars.put("auditName", this.nodeData.getAuditName());
        vars.put("auditMessage", approvalMessage);
        vars.put("auditType", this.nodeData.getAuditType());
        vars.put("assignee", WfUtils.findUserName((Long)this.nodeData.getAssigneeId()));
        vars.put("auditTime", this.nodeData.getEndDate().getTime());
        TaskHelper taskHelper = commandContext.getProcessEngineConfiguration().getTaskHelper();
        CommentEntity comment = (CommentEntity)taskHelper.addComment(task.getId(), task.getProcessInstanceId(), this.nodeData.getAssigneeId(), "comment", vars);
        comment.setCreateDate(this.nodeData.getCreateDate());
        comment.setTime(this.nodeData.getCreateDate());
        commandContext.getCommentEntityManager().update((Entity)comment);
        return comment;
    }

    private void setVariables() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("auditName", this.nodeData.getAuditName());
        variables.put("auditNumber", this.nodeData.getAuditNumber());
        variables.put("auditMessage", this.nodeData.getApprovalMsg());
        variables.put("auditType", this.nodeData.getAuditType());
        Object priority = this.execution.getProcessInstance().getVariable("priority");
        if (WfUtils.isNotEmptyString((Object)priority)) {
            variables.put("priority", priority);
        }
        this.task.setVariablesLocal(variables);
    }
}

