/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.process.make.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.workflow.bpmn.model.Activity;
import kd.bos.workflow.bpmn.model.FlowElement;
import kd.bos.workflow.bpmn.model.UserTask;
import kd.bos.workflow.bpmn.model.YunzhijiaTask;
import kd.bos.workflow.devops.process.make.NodeOperation;
import kd.bos.workflow.devops.process.make.node.MultiInstanceMaker;
import kd.bos.workflow.devops.process.make.node.YunzhijiaTaskMaker;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.delegate.DelegateExecution;
import kd.bos.workflow.engine.identity.ParticipantPositionEntity;
import kd.bos.workflow.engine.impl.bpmn.behavior.TaskBehaviorUtil;
import kd.bos.workflow.engine.impl.bpmn.helper.BPMNUtil;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricTaskInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntityManager;
import kd.bos.workflow.engine.impl.util.BpmnModelUtil;
import kd.bos.workflow.engine.impl.util.ParticipantHelper;
import kd.bos.workflow.engine.process.NodeData;

public class YunzhijiaMultiInstanceMaker
extends MultiInstanceMaker {
    private static final String JOINSTR = "%s-%s";
    private TaskEntity parentTask;

    @Override
    public void doMigrate() {
        this.execution.setCurrentFlowElement(this.flowElement);
        this.loopCharacteristics = ((Activity)this.flowElement).getLoopCharacteristics();
        boolean skip = this.createParentTask((Activity)this.flowElement);
        if (skip) {
            return;
        }
        this.createInstances();
        if (this.nodeData.getEndDate() != null) {
            this.leave((Activity)this.flowElement);
        } else {
            BPMNUtil.updateExecutionActivityName((ExecutionEntity)this.execution);
            BPMNUtil.updateHitaskInstPresentAssignee((ExecutionEntity)this.execution, null);
        }
    }

    private boolean createParentTask(Activity activity) {
        CommandContext commandContext = this.context.getCommandContext();
        TaskEntityManager taskEntityManager = commandContext.getTaskEntityManager();
        ExecutionEntityManager executionEntityManager = commandContext.getExecutionEntityManager();
        YunzhijiaTask yunzhijiaTask = (YunzhijiaTask)activity;
        this.parentTask = TaskBehaviorUtil.buildTaskEntity((DelegateExecution)this.execution, (UserTask)yunzhijiaTask);
        this.parentTask.setHandleState("willApproval");
        this.execution.setCurrentTask(this.parentTask);
        ArrayList userIds = this.nodeData.getParticipants();
        if (WfUtils.isEmptyForCollection((Collection)userIds)) {
            userIds = new ArrayList(10);
            for (NodeData childNode : this.nodeData.getChildNodes()) {
                userIds.addAll(childNode.getParticipants());
            }
        }
        boolean isAllowNoneParticipant = false;
        if (yunzhijiaTask.getParticipant() == null && yunzhijiaTask.getParticipant().isAllowNoneParticipant()) {
            isAllowNoneParticipant = true;
        }
        TaskBehaviorUtil.updateParticipantVariable((TaskEntity)this.parentTask, userIds, (boolean)isAllowNoneParticipant);
        this.parentTask.setSubject(TaskBehaviorUtil.getTaskSubject((UserTask)yunzhijiaTask, (TaskEntity)this.parentTask, (String)this.execution.getBusinessKey(), (String)this.execution.getEntityNumber()));
        this.parentTask.setDisplay(!yunzhijiaTask.isHideTaskInCenter());
        this.execution.setCurrentTask(this.parentTask);
        if ("skip".equals(this.nodeData.getExecutionType())) {
            String firstApproveOptNum;
            this.recordActStart();
            commandContext.getHistoryManager().recordActivityExecutionType(this.execution, "skip", this.nodeData.getSkipReason());
            String auditNum = (String)this.execution.getCurrentTask().getTransientVariableLocal("auditNumber");
            String approveType = BpmnModelUtil.getApproveTypeByNum((FlowElement)yunzhijiaTask, (String)auditNum);
            if (("reject".equals(approveType) || "forceReject".equals(approveType)) && WfUtils.isNotEmpty((String)(firstApproveOptNum = BpmnModelUtil.getFirstApproveOptNum((FlowElement)yunzhijiaTask)))) {
                this.execution.getCurrentTask().setTransientVariableLocal("auditNumber", (Object)firstApproveOptNum);
            }
            if (this.parentTask != null && this.parentTask.isInserted()) {
                Context.getCommandContext().getTaskEntityManager().changeTaskExecutionType(this.parentTask, "skip");
                Context.getCommandContext().getTaskHelper().deleteTask(this.parentTask.getId(), "task skip", false, false);
            }
            this.recordActEnd();
        } else {
            taskEntityManager.insert(this.parentTask, this.execution);
            this.parentTask.setVariableLocal("teamMembers", (Object)WfUtils.listToString(userIds, (String)","));
            ILocaleString participantName = WfUtils.getILocaleUsersName(userIds);
            if (WfUtils.isNotEmpty((ILocaleString)participantName)) {
                this.parentTask.setVariableLocal("teamMemberNames", (Object)SerializationUtils.toJsonString((Object)participantName));
            }
            if (userIds != null && !userIds.isEmpty()) {
                ILocaleString participantNameFormater = ParticipantHelper.getUserNameFormatValue((TaskEntity)this.parentTask, userIds);
                if (WfUtils.isNotEmpty((ILocaleString)participantNameFormater)) {
                    this.parentTask.setVariableLocal("teamMemberNamesFormat", (Object)SerializationUtils.toJsonString((Object)participantNameFormater));
                }
                HashMap<Long, ParticipantPositionEntity> userPositionMap = new HashMap<Long, ParticipantPositionEntity>(userIds.size());
                for (Long userId : userIds) {
                    userPositionMap.put(userId, commandContext.getUserPosoitionCache(userId));
                }
                this.execution.setVariable("userPosition", userPositionMap);
            }
            this.execution.setCurrentTask(this.parentTask);
            this.execution.setCurrentTaskId(this.parentTask.getId());
            this.execution.setCreateDate(this.nodeData.getCreateDate());
            this.execution.setModifyDate(this.nodeData.getCreateDate());
            executionEntityManager.update((Entity)this.execution);
        }
        return "skip".equals(this.nodeData.getExecutionType());
    }

    @Override
    protected void handleTaskLeave(Activity activity) {
        HistoricTaskInstanceEntity hiParentTask;
        CommandContext commandContext = this.context.getCommandContext();
        if (WfUtils.isEmpty((String)this.nodeData.getAuditNumber()) || WfUtils.isEmpty((ILocaleString)this.nodeData.getApprovalMsg())) {
            commandContext.getTaskHelper().deleteTaskEntity(this.parentTask, "task skip", false, false);
        } else {
            this.addComment(this.parentTask);
            commandContext.getTaskHelper().deleteTaskEntity(this.parentTask, "task complete", false, false);
        }
        ExecutionEntity procinst = this.execution.getProcessInstance();
        if (procinst != null) {
            procinst.removeVariable(String.format(JOINSTR, ((YunzhijiaTask)activity).getNumber(), "yzjSubInstNum"));
            procinst.removeVariable(String.format(JOINSTR, ((YunzhijiaTask)activity).getNumber(), "yzjConsentVoteNum"));
            procinst.removeVariable(String.format(JOINSTR, ((YunzhijiaTask)activity).getNumber(), "yzjReceivedTaskUsers"));
        }
        if ((hiParentTask = (HistoricTaskInstanceEntity)commandContext.getHistoricTaskInstanceEntityManager().findById(this.parentTask.getId())) != null) {
            hiParentTask.setCreateDate(this.nodeData.getCreateDate());
            hiParentTask.setModifyDate(this.nodeData.getCreateDate());
            hiParentTask.setEndTime(this.nodeData.getEndDate());
            hiParentTask.setDurationInMillis(Long.valueOf(this.nodeData.getEndDate().getTime() - this.nodeData.getCreateDate().getTime()));
            hiParentTask.setRealDurationInMillis(Long.valueOf(this.nodeData.getEndDate().getTime() - this.nodeData.getCreateDate().getTime()));
            commandContext.getHistoricTaskInstanceEntityManager().update((Entity)hiParentTask);
        }
    }

    @Override
    protected int getInstanceCount() {
        return this.nodeData.getChildNodes().size();
    }

    @Override
    protected void planChildExecution(ExecutionEntity subExecution, int loopCounter) {
        NodeOperation operation = new NodeOperation((NodeData)this.nodeData.getChildNodes().get(loopCounter), subExecution);
        new YunzhijiaTaskMaker().migrate(this.context, operation);
    }

    @Override
    protected CommentEntity addComment(TaskEntity task) {
        CommandContext commandContext = this.context.getCommandContext();
        YunzhijiaTask yunzhijiaTask = (YunzhijiaTask)this.flowElement;
        CommentEntity comment = (CommentEntity)Context.getCommandContext().getCommentEntityManager().create();
        comment.setTaskId(this.parentTask.getId());
        comment.setGroupId(String.valueOf(this.parentTask.getId()));
        comment.setBackToBack(Boolean.valueOf(yunzhijiaTask.getBackToBackVote()));
        comment.setType("comment");
        comment.setTime(this.nodeData.getEndDate());
        comment.setProcessInstanceId(this.execution.getProcessInstanceId());
        comment.setActivityId(this.execution.getCurrentActivityId());
        comment.setDecisionType(this.nodeData.getAuditType());
        comment.setResultNumber(this.nodeData.getAuditNumber());
        comment.setResultName(this.nodeData.getAuditName());
        comment.setMessage(this.nodeData.getApprovalMsg());
        comment.setCreateDate(this.nodeData.getCreateDate());
        comment.setTime(this.nodeData.getCreateDate());
        commandContext.getCommentEntityManager().insert((Entity)comment);
        return comment;
    }
}

