/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.router;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.List;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.PageMode;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.devopos.ProcessNotExistPoJo;
import kd.bos.workflow.devops.vo.AddressProcedureVo;

public class ProcessNotExistRouter {
    private AbstractFormPlugin plugin;

    public ProcessNotExistRouter(AbstractFormPlugin plugin) {
        this.plugin = plugin;
    }

    public void showBillForm(ProcessNotExistPoJo entity) {
        if (entity.getEntityNumber() == null || entity.getBusinessKey() == null) {
            return;
        }
        BillShowParameter billParam = new BillShowParameter();
        billParam.setFormId(entity.getEntityNumber());
        try {
            Long pkId = Long.valueOf(entity.getBusinessKey());
            billParam.setPkId((Object)pkId);
        }
        catch (NumberFormatException e) {
            billParam.setPkId((Object)entity.getBusinessKey());
        }
        billParam.getOpenStyle().setShowType(ShowType.NewTabPage);
        billParam.getOpenStyle().setTargetKey("_submaintab_");
        IFormView parentView = this.plugin.getView().getParentView();
        if (parentView == null) {
            billParam.getOpenStyle().setShowType(ShowType.Modal);
            this.plugin.getView().showForm((FormShowParameter)billParam);
            return;
        }
        parentView.showForm((FormShowParameter)billParam);
        this.plugin.getView().sendFormAction(parentView);
    }

    public void showErrorAddressFrom(ProcessNotExistPoJo poJo) {
        BaseShowParameter param = new BaseShowParameter();
        param.setFormId("wf_deadletterjob");
        param.setPkId((Object)poJo.getDeadLetterId());
        param.getOpenStyle().setShowType(ShowType.NewTabPage);
        param.getOpenStyle().setTargetKey("_submaintab_");
        IFormView parentView = this.plugin.getView().getParentView();
        if (parentView == null) {
            param.getOpenStyle().setShowType(ShowType.Modal);
            this.plugin.getView().showForm((FormShowParameter)param);
            return;
        }
        parentView.showForm((FormShowParameter)param);
        this.plugin.getView().sendFormAction(parentView);
        this.plugin.getView().showForm((FormShowParameter)param);
    }

    public void toProcessDefinitionList(List<Long> processDefinitionIds) {
        ListShowParameter param = new ListShowParameter();
        param.setFormId("wf_processtreelist");
        param.setBillFormId("bpm_processmanage");
        param.setCustomParam("defaultFilter", (Object)"false");
        ListFilterParameter filter = new ListFilterParameter();
        filter.setFilter(new QFilter("id", "in", processDefinitionIds));
        param.setListFilterParameter(filter);
        IFormView parentView = this.plugin.getView().getParentView();
        if (parentView == null) {
            param.getOpenStyle().setShowType(ShowType.Modal);
            this.plugin.getView().showForm((FormShowParameter)param);
            return;
        }
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.plugin.getView().sendFormAction(parentView);
        this.plugin.getView().showForm((FormShowParameter)param);
    }

    public void showAddressPath(String entityNumber, String billNo, List<AddressProcedureVo> vos) {
        FormShowParameter param = new FormShowParameter();
        param.setFormId("wf_log_addressprocedure");
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.setCustomParam("entitynumber", (Object)entityNumber);
        param.setCustomParam("billno", (Object)billNo);
        param.setCustomParam("vo", (Object)SerializationUtils.toJsonString(vos));
        this.plugin.getView().showForm(param);
    }

    public void toDesignedProcess(String entity, List<Long> ids, String callback) {
        FormShowParameter param = new FormShowParameter();
        param.setCustomParam("entity", (Object)entity);
        if (ids == null) {
            ids = new ArrayList<Long>(0);
        }
        String join = Joiner.on((String)",").join(ids);
        param.setCustomParam("ids", (Object)join);
        param.setFormId("wf_designedprocess");
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this.plugin, callback));
        this.plugin.getView().showForm(param);
    }

    public void toAlarmMsgSendLogList(Long alarmMsgSendLogId) {
        ListShowParameter param = new ListShowParameter();
        param.setBillFormId("wf_alarmmsgsendlog");
        ListFilterParameter filter = new ListFilterParameter();
        filter.setFilter(new QFilter("id", "=", (Object)alarmMsgSendLogId));
        param.setListFilterParameter(filter);
        IFormView parentView = this.plugin.getView().getParentView();
        if (parentView == null) {
            param.getOpenStyle().setShowType(ShowType.Modal);
            this.plugin.getView().showForm((FormShowParameter)param);
            return;
        }
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.plugin.getView().sendFormAction(parentView);
        this.plugin.getView().showForm((FormShowParameter)param);
    }

    public void toOperateList(String entity, String callBackKey) {
        FormShowParameter param = new FormShowParameter();
        param.setCustomParam("entity", (Object)entity);
        param.setFormId("wf_entityoperate");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this.plugin, callBackKey);
        param.setCloseCallBack(closeCallBack);
        param.getOpenStyle().setShowType(ShowType.Modal);
        this.plugin.getView().showForm(param);
    }

    @Deprecated
    public void toEntityProcess(String entity, String callBackKey) {
        FormShowParameter param = new FormShowParameter();
        param.setFormId("wf_entityprocess");
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCustomParam("entity", (Object)entity);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this.plugin, callBackKey);
        param.setCloseCallBack(closeCallBack);
        this.plugin.getView().showForm(param);
    }

    public void toEntityProcessList(String entity, String callBackKey) {
        ListShowParameter parameter = new ListShowParameter();
        parameter.setFormId("bos_listf7");
        parameter.setBillFormId("wf_entityprocess_view");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setLookUp(true);
        parameter.setPageMode(PageMode.Default.getPageMode());
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("960px");
        styleCss.setHeight("580px");
        parameter.setShowTitle(false);
        parameter.setMultiSelect(false);
        parameter.getOpenStyle().setInlineStyleCss(styleCss);
        QFilter qFilter = new QFilter("processdefinitionid.entrabill", "=", (Object)entity);
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        listFilterParameter.setFilter(qFilter);
        parameter.setListFilterParameter(listFilterParameter);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this.plugin, callBackKey));
        parameter.setCustomParam("entity", (Object)entity);
        this.plugin.getView().showForm((FormShowParameter)parameter);
    }

    public void toWfEntityObj(String actionId) {
        FormShowParameter param = new FormShowParameter();
        param.setFormId("wf_entityobj");
        param.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this.plugin, actionId);
        param.setCloseCallBack(closeCallBack);
        this.plugin.getView().showForm(param);
    }

    public void toExceptedEntity() {
        FormShowParameter param = new FormShowParameter();
        param.setFormId("wf_notinprocess_excepted");
        param.getOpenStyle().setShowType(ShowType.Modal);
        this.plugin.getView().showForm(param);
    }

    public void toAlarmRule() {
        ListShowParameter param = new ListShowParameter();
        param.setBillFormId("wf_alarmrule");
        IFormView parentView = this.plugin.getView().getParentView();
        if (parentView == null) {
            param.getOpenStyle().setShowType(ShowType.Modal);
            this.plugin.getView().showForm((FormShowParameter)param);
            return;
        }
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.plugin.getView().sendFormAction(parentView);
        this.plugin.getView().showForm((FormShowParameter)param);
    }

    public IFormPlugin getPlugin() {
        return this.plugin;
    }

    public ProcessNotExistRouter setPlugin(AbstractFormPlugin plugin) {
        this.plugin = plugin;
        return this;
    }

    public static ProcessNotExistRouter get() {
        return new ProcessNotExistRouter();
    }

    private ProcessNotExistRouter() {
    }
}

