/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bec.engine.utils.BatchOptionResult;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.workflow.devopos.ProcessNotExistPoJo;
import kd.bos.workflow.devopos.info.IndicatorInfo;
import kd.bos.workflow.devops.api.IDataCapture;
import kd.bos.workflow.devops.cache.DevopsServiceCacheHelper;
import kd.bos.workflow.devops.cmd.CollectAndStatisticsIndicatorCmd;
import kd.bos.workflow.devops.cmd.FindExceptedEntitySetCmd;
import kd.bos.workflow.devops.cmd.GetErrorMsgToMqJobsCmd;
import kd.bos.workflow.devops.cmd.GetErrorMsgToMqJobsCountCmd;
import kd.bos.workflow.devops.cmd.GetReportDatasCmd;
import kd.bos.workflow.devops.cmd.NotifySubmitterProcessNotEnteredCmd;
import kd.bos.workflow.devops.cmd.RecoverSysErrorProcessInstanceCmd;
import kd.bos.workflow.devops.cmd.RemoveProcessNotExistLogCmd;
import kd.bos.workflow.devops.cmd.RestartProcessesCmd;
import kd.bos.workflow.devops.cmd.SaveExceptedEntityCmd;
import kd.bos.workflow.devops.cmd.SavePluginDataCmd;
import kd.bos.workflow.devops.cmd.ScanPluginClassCmd;
import kd.bos.workflow.devops.cmd.SendAlarmMessageCmd;
import kd.bos.workflow.devops.cmd.TestingMqAndScheduleStateCmd;
import kd.bos.workflow.devops.entity.AlarmMsgSendLogEntity;
import kd.bos.workflow.devops.entity.AlarmMsgSendLogEntityManager;
import kd.bos.workflow.devops.entity.AlarmRuleEntityManager;
import kd.bos.workflow.devops.entity.BehaviorCollectorEntity;
import kd.bos.workflow.devops.entity.BehaviorCollectorEntityManager;
import kd.bos.workflow.devops.entity.DevopsIndicatorEntity;
import kd.bos.workflow.devops.entity.DevopsIndicatorEntityManager;
import kd.bos.workflow.devops.entity.DevopsIndictorLibraryEntity;
import kd.bos.workflow.devops.entity.DevopsIndictorLibraryEntityManager;
import kd.bos.workflow.devops.entity.DevopsRejectBillEntity;
import kd.bos.workflow.devops.entity.DevopsRejectBillEntityManager;
import kd.bos.workflow.devops.entity.ExceptedEntity;
import kd.bos.workflow.devops.entity.ExceptedEntityManager;
import kd.bos.workflow.devops.entity.MsgJobToMqEntity;
import kd.bos.workflow.devops.entity.MsgJobToMqEntityManager;
import kd.bos.workflow.devops.entity.PluginExeDetailEntity;
import kd.bos.workflow.devops.entity.PluginExeDetailEntityManager;
import kd.bos.workflow.devops.entity.PluginProcInfoEntity;
import kd.bos.workflow.devops.entity.PluginProcInfoEntityManager;
import kd.bos.workflow.devops.entity.ProcessNotExistEntity;
import kd.bos.workflow.devops.entity.ProcessNotExistEntityImpl;
import kd.bos.workflow.devops.entity.ProcessNotExistManager;
import kd.bos.workflow.devops.enums.ReAddressType;
import kd.bos.workflow.devops.pojo.ExceptedEntityData;
import kd.bos.workflow.devops.process.make.GetProcessMakeDataCmd;
import kd.bos.workflow.devops.process.make.ProcessInstMakeCmd;
import kd.bos.workflow.devops.service.WFDevopsService;
import kd.bos.workflow.devops.statisticalanalysis.DataCaptureFactory;
import kd.bos.workflow.devops.statisticalanalysis.dto.WFDevopsDataInfo;
import kd.bos.workflow.devops.statisticalanalysis.mq.WfDevopsProducer;
import kd.bos.workflow.devops.statisticalanalysis.utils.CaptureUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.ServiceImpl;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.cmd.job.JobHandleStrategyFactory;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandConfig;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.jobexecutor.JobUtil;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobStateEnum;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.util.QueryWrapper;
import kd.bos.workflow.engine.pojo.AddressParam;
import kd.bos.workflow.engine.process.ProcessInstData;
import org.apache.commons.collections.CollectionUtils;

public class WFDevopsServiceImpl
extends ServiceImpl
implements WFDevopsService {
    private Log logger = LogFactory.getLog(WFDevopsServiceImpl.class);

    public WFDevopsServiceImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    @Override
    public DynamicObjectCollection getErrorMsgToMqJobs(int start, int limit, List<QFilter> filters, String orderBy) {
        return (DynamicObjectCollection)this.commandExecutor.execute((Command)new GetErrorMsgToMqJobsCmd(start, limit, filters, orderBy));
    }

    @Override
    public Long getErrorMsgToMqJobsCount(List<QFilter> filters) {
        return (Long)this.commandExecutor.execute((Command)new GetErrorMsgToMqJobsCountCmd(filters));
    }

    @Override
    public MsgJobToMqEntity findMsgToJobById(final Long id) {
        return (MsgJobToMqEntity)this.commandExecutor.execute((Command)new Command<MsgJobToMqEntity>(){

            public MsgJobToMqEntity execute(CommandContext commandContext) {
                return (MsgJobToMqEntity)((MsgJobToMqEntityManager)commandContext.getEntityManager(MsgJobToMqEntityManager.class)).findById(id);
            }
        });
    }

    @Override
    public Boolean isExitSameSceneAlarmRule(final String scene, final Long pkId) {
        return (Boolean)this.commandExecutor.execute((Command)new Command<Boolean>(){

            public Boolean execute(CommandContext commandContext) {
                return ((AlarmRuleEntityManager)commandContext.getEntityManager(AlarmRuleEntityManager.class)).existSameSceneRule(scene, pkId);
            }
        });
    }

    @Override
    public void sendAlarmMessage(String scene, Long monitorId, Map<String, Object> params) {
        this.commandExecutor.execute((Command)new SendAlarmMessageCmd(scene, monitorId, params));
    }

    @Override
    public void sendAlarmMessage(String scene, String group, Map<String, Object> params) {
        this.commandExecutor.execute((Command)new SendAlarmMessageCmd(scene, group, params));
    }

    @Override
    public void sendAlarmMessage(String scene, String group, ILocaleString title, ILocaleString content, Map<String, Object> params) {
        this.commandExecutor.execute((Command)new SendAlarmMessageCmd(scene, group, title, content, params));
    }

    @Override
    public AlarmMsgSendLogEntity getLastUnfinishSysErrorMessage() {
        return (AlarmMsgSendLogEntity)this.commandExecutor.execute((Command)new Command<AlarmMsgSendLogEntity>(){

            public AlarmMsgSendLogEntity execute(CommandContext commandContext) {
                List<AlarmMsgSendLogEntity> logs = ((AlarmMsgSendLogEntityManager)commandContext.getEntityManager(AlarmMsgSendLogEntityManager.class)).findUnfinishLogByScence("syserror");
                return logs.isEmpty() ? null : logs.get(0);
            }
        });
    }

    @Override
    public void testingMqAndScheduleState() {
        this.commandExecutor.execute((Command)new TestingMqAndScheduleStateCmd());
    }

    @Override
    public void abandSendLogEntityByAlarmRuleId(final Long ruleId) {
        this.commandExecutor.execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                AlarmMsgSendLogEntityManager entityManager = (AlarmMsgSendLogEntityManager)commandContext.getEntityManager(AlarmMsgSendLogEntityManager.class);
                List<AlarmMsgSendLogEntity> entitys = entityManager.findUncompleteLogsByRuleId(ruleId);
                entitys.forEach(entity -> {
                    entity.setState("suspend");
                    entityManager.update((Entity)entity);
                });
                return null;
            }
        });
    }

    @Override
    public void sendRecoverSysErrorProcessInstanceJob() {
        JobEntity job = (JobEntity)this.processEngineConfiguration.getJobEntityManager().create();
        job.setId(Long.valueOf(DB.genGlobalLongId()));
        job.setJobType("message");
        job.setRetries(0);
        job.setJobHandlerType("async-devops-recoversyserror-job");
        HashMap<String, String> payload = new HashMap<String, String>(1);
        payload.put("appId", "wf");
        job.setJobHandlerConfiguration(SerializationUtils.toJsonString(payload));
        job.setRootTraceNo(RequestContext.get().getTraceId());
        job.setSource(JobHandleStrategyFactory.getWFSource());
        job.setState(JobStateEnum.CREATED.getNumber());
        JobUtil.sendJobToMQ((JobEntity)job);
    }

    @Override
    public void updateMsgJobToMqData(final Long jobId, final String state, final String error, final String errinfo) {
        this.commandExecutor.execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                MsgJobToMqEntityManager entityManager = (MsgJobToMqEntityManager)commandContext.getEntityManager(MsgJobToMqEntityManager.class);
                MsgJobToMqEntity entity = (MsgJobToMqEntity)entityManager.findById(jobId);
                entity.setState(state);
                entity.setErrorCode(error);
                entity.setErrorInfo(errinfo);
                entity.setErrorInfoTag(errinfo);
                entityManager.update(entity);
                return null;
            }
        });
    }

    @Override
    public void repairSysErrorProcessInstance() {
        this.commandExecutor.execute((Command)new RecoverSysErrorProcessInstanceCmd());
    }

    @Override
    public void finishTestingMsgJobToMq(final Long jobId) {
        this.commandExecutor.execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                MsgJobToMqEntityManager entityManager = (MsgJobToMqEntityManager)commandContext.getEntityManager(MsgJobToMqEntityManager.class);
                MsgJobToMqEntity entity = (MsgJobToMqEntity)entityManager.findById(jobId);
                entity.setEndDate(new Date());
                entity.setState("complete");
                if (WfUtils.isEmpty((String)entity.getErrorType())) {
                    entity.setErrorType("success");
                }
                entityManager.update(entity);
                return null;
            }
        });
    }

    @Override
    public void logProcessNotExist(ProcessNotExistPoJo poJo) {
        FormConfig formConfig;
        String entityNumber = poJo.getEntityNumber();
        if (WfUtils.isNotEmpty((String)entityNumber) && (formConfig = FormMetadataCache.getFormConfig((String)entityNumber)) != null && "nocodebill".equalsIgnoreCase(formConfig.getModelType())) {
            return;
        }
        this.commandExecutor.execute(commandContext -> {
            QFilter[] qFilters;
            ProcessNotExistManager manager = (ProcessNotExistManager)commandContext.getEntityManager(ProcessNotExistManager.class);
            List byQueryFilters = manager.findByQueryFilters(qFilters = new QueryWrapper().eq("entitynumber", (Object)poJo.getEntityNumber()).eq("businesskey", (Object)poJo.getBusinessKey()).getQFilters());
            if (byQueryFilters == null || byQueryFilters.isEmpty()) {
                ProcessNotExistEntityImpl entity = new ProcessNotExistEntityImpl().formPoJo(poJo);
                manager.insert(entity);
                return null;
            }
            ProcessNotExistEntity oldValue = (ProcessNotExistEntity)byQueryFilters.get(0);
            Long id = oldValue.getId();
            Long submitterId = oldValue.getSubmitterId();
            Long oldValueAlarmMsgSendLogId = oldValue.getAlarmMsgSendLogId();
            oldValue.formPoJo(poJo);
            oldValue.setId(id);
            oldValue.setSubmitterId(submitterId);
            Long alarmMsgSendLogId = poJo.getAlarmMsgSendLogId();
            if (oldValueAlarmMsgSendLogId == null || oldValueAlarmMsgSendLogId == 0L) {
                oldValue.setAlarmMsgSendLogId(alarmMsgSendLogId);
            } else {
                oldValue.setAlarmMsgSendLogId(oldValueAlarmMsgSendLogId);
            }
            manager.update(oldValue);
            return null;
        });
    }

    @Override
    public ProcessNotExistPoJo findProcessNotExistById(Long id) {
        return (ProcessNotExistPoJo)this.commandExecutor.execute(commandContext -> {
            ProcessNotExistManager manager = (ProcessNotExistManager)commandContext.getEntityManager(ProcessNotExistManager.class);
            return Optional.ofNullable(manager.findById(id)).map(ProcessNotExistEntity::toPoJo).orElseGet(ProcessNotExistPoJo::new);
        });
    }

    @Override
    public void removeLog(String businessKey, String entityNumber) {
        this.commandExecutor.execute((Command)new RemoveProcessNotExistLogCmd(entityNumber, businessKey));
    }

    @Override
    public void deleteByIds(List<Long> ids) {
        this.commandExecutor.execute(commandContext -> {
            ProcessNotExistManager manager = (ProcessNotExistManager)commandContext.getEntityManager(ProcessNotExistManager.class);
            QFilter qFilter = new QFilter("id", "in", (Object)ids);
            manager.deleteByFilters(qFilter.toArray());
            return null;
        });
    }

    @Override
    public void sendIndicatorsToMq() {
        this.commandExecutor.execute(commandContext -> {
            DevopsIndictorLibraryEntityManager entityManager = (DevopsIndictorLibraryEntityManager)commandContext.getEntityManager(DevopsIndictorLibraryEntityManager.class);
            List<DevopsIndictorLibraryEntity> allEntity = entityManager.findInfictorHasGroup();
            HashMap<String, List> captureGroupMap = new HashMap<String, List>(allEntity.size());
            if (CaptureUtils.isEnableGroupsModel()) {
                allEntity.forEach(entity -> {
                    if (StringUtils.isBlank((CharSequence)entity.getGroup())) {
                        entity.setGroup("11");
                    }
                    List numbers = Optional.ofNullable(captureGroupMap.get(entity.getGroup())).orElseGet(ArrayList::new);
                    numbers.add(entity.getNumber());
                    captureGroupMap.put(entity.getGroup(), numbers);
                });
            } else {
                captureGroupMap.put("noGroups", new ArrayList());
            }
            captureGroupMap.forEach((group, list) -> {
                try {
                    WFDevopsDataInfo info = new WFDevopsDataInfo();
                    info.setType("indictorCapture");
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put("group", group);
                    data.put("numbers", list);
                    info.setData(data);
                    WfDevopsProducer.publish(info);
                    this.logger.info("sendIndicatorsToMq_currentgroup is :" + group);
                }
                catch (Exception e) {
                    this.logger.error("WFDevopsServiceImpl: send to MQ is error:" + WfUtils.getExceptionStacktrace((Throwable)e));
                }
            });
            return null;
        });
    }

    @Override
    public List<DevopsIndicatorEntity> getIndicatorEntitysByIds(final List<Long> list) {
        return (List)this.commandExecutor.execute((Command)new Command<List<DevopsIndicatorEntity>>(){

            public List<DevopsIndicatorEntity> execute(CommandContext commandContext) {
                return ((DevopsIndicatorEntityManager)commandContext.getEntityManager(DevopsIndicatorEntityManager.class)).findByIds(list);
            }
        });
    }

    @Override
    public void saveBehaviorInfo(final BehaviorCollectorEntity entity, final boolean isUpdate) {
        this.commandExecutor.execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                BehaviorCollectorEntityManager entityManager = (BehaviorCollectorEntityManager)commandContext.getEntityManager(BehaviorCollectorEntityManager.class);
                if (isUpdate) {
                    entityManager.update(entity);
                } else {
                    entityManager.insert(entity);
                }
                return null;
            }
        });
    }

    @Override
    public List<BehaviorCollectorEntity> findBehaviorInfoByNumberAndType(final String number, final String type) {
        return (List)this.commandExecutor.execute((Command)new Command<List<BehaviorCollectorEntity>>(){

            public List<BehaviorCollectorEntity> execute(CommandContext commandContext) {
                return ((BehaviorCollectorEntityManager)commandContext.getEntityManager(BehaviorCollectorEntityManager.class)).findByNumberAndType(number, type);
            }
        });
    }

    @Override
    public List<BehaviorCollectorEntity> findBehaviorInfoByNumberAndType(String number) {
        return this.findBehaviorInfoByNumberAndType(number, null);
    }

    @Override
    public List<DevopsRejectBillEntity> getDevopsRejectBillInfo(final String entityNumber, final String businessKey) {
        return (List)this.commandExecutor.execute((Command)new Command<List<DevopsRejectBillEntity>>(){

            public List<DevopsRejectBillEntity> execute(CommandContext commandContext) {
                return ((DevopsRejectBillEntityManager)commandContext.getEntityManager(DevopsRejectBillEntityManager.class)).findByEntityNumberAndBusinessKey(entityNumber, businessKey);
            }
        });
    }

    @Override
    public void saveDevopsRejectBillInfo(final DevopsRejectBillEntity entity, final boolean isUpdate) {
        this.commandExecutor.execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                DevopsRejectBillEntityManager entityManager = (DevopsRejectBillEntityManager)commandContext.getEntityManager(DevopsRejectBillEntityManager.class);
                if (isUpdate) {
                    entityManager.update(entity);
                } else {
                    entityManager.insert(entity);
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveDevopsIndicator(DevopsIndicatorEntity entity, boolean isNewTransaction) {
        if (isNewTransaction) {
            try (TXHandle tx = TX.requiresNew();){
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{entity.getDynamicObject()});
            }
        } else {
            this.saveDevopsIndicator(entity);
        }
    }

    @Override
    public void saveDevopsIndicator(final DevopsIndicatorEntity entity) {
        CommandConfig defaultConfig = this.processEngineConfiguration.getCommandExecutor().getDefaultConfig().transactionRequiresNew();
        this.commandExecutor.execute(defaultConfig, (Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                ((DevopsIndicatorEntityManager)commandContext.getEntityManager(DevopsIndicatorEntityManager.class)).insert(entity);
                return null;
            }
        });
    }

    @Override
    public void deleteDevopsIndicatorsByIds(final List<Long> deleteIds) {
        this.commandExecutor.execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                ((DevopsIndicatorEntityManager)commandContext.getEntityManager(DevopsIndicatorEntityManager.class)).deleteDevopsIndicatorsByIds(deleteIds);
                return null;
            }
        });
    }

    @Override
    public void batchUpdateDevopsIndicatorsSendTimes(final List<Long> ids) {
        this.commandExecutor.execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                ((DevopsIndicatorEntityManager)commandContext.getEntityManager(DevopsIndicatorEntityManager.class)).batchUpdateDevopsIndicatorsSendTimes(ids);
                return null;
            }
        });
    }

    @Override
    public void batchSaveIndictors(final List<IndicatorInfo> indicator) {
        CommandConfig defaultConfig = this.processEngineConfiguration.getCommandExecutor().getDefaultConfig().transactionRequiresNew();
        this.commandExecutor.execute(defaultConfig, (Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                ((DevopsIndicatorEntityManager)commandContext.getEntityManager(DevopsIndicatorEntityManager.class)).batchInsert(indicator);
                return null;
            }
        });
    }

    @Override
    public Long getProcInstIdById(final Long id) {
        Long procInstId = (Long)this.commandExecutor.execute((Command)new Command<Long>(){

            public Long execute(CommandContext commandContext) {
                PluginProcInfoEntity entity = (PluginProcInfoEntity)((PluginProcInfoEntityManager)commandContext.getEntityManager(PluginProcInfoEntityManager.class)).findById(id);
                PluginExeDetailEntityManager pluginExeDetailEntityManager = (PluginExeDetailEntityManager)commandContext.getEntityManager(PluginExeDetailEntityManager.class);
                List<PluginExeDetailEntity> dataList = pluginExeDetailEntityManager.getPluginExeDetailDataByCondition(entity.getPluginno(), entity.getProcessno());
                if (dataList != null && dataList.size() > 0) {
                    return dataList.get(0).getProcInstId();
                }
                return 1L;
            }
        });
        return procInstId;
    }

    @Override
    public List<ProcessNotExistPoJo> findProcessNotExistByIds(List<Long> ids) {
        return (List)this.commandExecutor.execute(commandContext -> {
            ProcessNotExistManager manager = (ProcessNotExistManager)commandContext.getEntityManager(ProcessNotExistManager.class);
            QFilter[] qFilters = new QueryWrapper().in("id", ids).getQFilters();
            List result = manager.findByQueryFilters(qFilters);
            return result.stream().map(ProcessNotExistEntity::toPoJo).collect(Collectors.toList());
        });
    }

    @Override
    public Set<String> findProcessNotExistEntityNumberById(List<Long> ids) {
        return (Set)this.commandExecutor.execute(commandContext -> {
            ProcessNotExistManager manager = (ProcessNotExistManager)commandContext.getEntityManager(ProcessNotExistManager.class);
            QFilter[] qFilters = new QueryWrapper().in("id", ids).getQFilters();
            List result = manager.findByQueryFilters(qFilters, "id,entitynumber", "id");
            return result.stream().map(ProcessNotExistEntity::getEntityNumber).collect(Collectors.toSet());
        });
    }

    @Override
    public BatchOptionResult<String> batchRestartProcess(List<AddressParam> params, ReAddressType type) {
        return (BatchOptionResult)this.commandExecutor.execute((Command)new RestartProcessesCmd(params, type));
    }

    @Override
    public Set<String> findExceptedEntitySet() {
        return (Set)this.commandExecutor.execute((Command)new FindExceptedEntitySetCmd());
    }

    @Override
    public void saveExceptedEntity(List<String> entityNumber) {
        this.commandExecutor.execute((Command)new SaveExceptedEntityCmd(entityNumber));
    }

    @Override
    public boolean existExceptedEntity(String entityNumber) {
        return (Boolean)this.commandExecutor.execute(commandContext -> {
            Object set = new FindExceptedEntitySetCmd().execute(commandContext);
            return set.contains(entityNumber);
        });
    }

    @Override
    public void removeExceptedEntityCache() {
        DevopsServiceCacheHelper.removeExceptedEntityNumber();
    }

    @Override
    public void savePluginData(IndicatorInfo indicatorInfo) {
        this.commandExecutor.execute((Command)new SavePluginDataCmd(indicatorInfo));
    }

    @Override
    public ProcessDefinitionEntity getProcessDefinitionEntityById(final Long procDefId) {
        ProcessDefinitionEntity processDefinitionEntity = (ProcessDefinitionEntity)this.commandExecutor.execute((Command)new Command<ProcessDefinitionEntity>(){

            public ProcessDefinitionEntity execute(CommandContext commandContext) {
                return (ProcessDefinitionEntity)commandContext.getProcessDefinitionEntityManager().findById(procDefId);
            }
        });
        return processDefinitionEntity;
    }

    @Override
    public List<BehaviorCollectorEntity> findBehaviorCollectorBetweenDimvalue(String number, String beginNumber, String endNumbr) {
        return (List)this.commandExecutor.execute(commandContext -> ((BehaviorCollectorEntityManager)commandContext.getEntityManager(BehaviorCollectorEntityManager.class)).findBehaviorCollectorBetweenDimvalue(number, beginNumber, endNumbr));
    }

    @Override
    public void captureIndicatorInfo(IndicatorInfo info) {
        CommandConfig defaultConfig = this.processEngineConfiguration.getCommandExecutor().getDefaultConfig().transactionRequiresNew();
        this.commandExecutor.execute(defaultConfig, commandContext -> {
            IDataCapture dataCaptureInterface = DataCaptureFactory.getDataCaptureInterface(info.getNumber());
            dataCaptureInterface.capture(info);
            return null;
        });
    }

    @Override
    public List<IndicatorInfo> fetchIndicatorInfo(String number, String dimValue) {
        try {
            return (List)this.commandExecutor.execute(commandContext -> {
                IDataCapture dataCaptureInterface = DataCaptureFactory.getDataCaptureInterface(number);
                return dataCaptureInterface.fetch(number, dimValue);
            });
        }
        catch (Exception e) {
            this.logger.info(number + dimValue + WfUtils.getExceptionStacktrace((Throwable)e));
            return new ArrayList<IndicatorInfo>(1);
        }
    }

    @Override
    public List<DevopsIndictorLibraryEntity> findDisableInfictor() {
        CommandConfig defaultConfig = this.processEngineConfiguration.getCommandExecutor().getDefaultConfig().transactionRequiresNew();
        return (List)this.commandExecutor.execute(defaultConfig, commandContext -> ((DevopsIndictorLibraryEntityManager)commandContext.getEntityManager(DevopsIndictorLibraryEntityManager.class)).findDisableInfictor());
    }

    @Override
    public Long notifySubmitterProcessNotEntered(DynamicObject businessModel, ProcessNotExistPoJo poJo) {
        return (Long)this.commandExecutor.execute((Command)new NotifySubmitterProcessNotEnteredCmd(businessModel, poJo));
    }

    @Override
    public List<ExceptedEntity> findAllExceptedEntity() {
        return (List)this.commandExecutor.execute(commandContext -> {
            ExceptedEntityManager entityManager = (ExceptedEntityManager)commandContext.getEntityManager(ExceptedEntityManager.class);
            return entityManager.findByQueryFilters(new QFilter[0]);
        });
    }

    @Override
    public void commitExceptedChanges(List<ExceptedEntityData> list) {
        this.commandExecutor.execute(commandContext -> {
            ArrayList insertList;
            List newList;
            ExceptedEntityManager entityManager = (ExceptedEntityManager)commandContext.getEntityManager(ExceptedEntityManager.class);
            List byQueryFilters = entityManager.findByQueryFilters(new QFilter[0]);
            List oldList = byQueryFilters.stream().map(ExceptedEntity::getEntityNumber).collect(Collectors.toList());
            ArrayList deleteList = (ArrayList)CollectionUtils.subtract(oldList, newList = list.stream().map(ExceptedEntityData::getEntityNumber).collect(Collectors.toList()));
            if (!deleteList.isEmpty()) {
                entityManager.batchDelete(deleteList);
                WfUtils.addOpLog((String)"wf_exceptedentity", (String)"delete", (String)ResManager.getLocaleString((String)"\u5220\u9664", (String)"ProcessExceptedEntityPlugin_3", (String)"bos-wf-devops").getLocaleValue_zh_CN(), (MultiLangEnumBridge)new MultiLangEnumBridge("\u5220\u9664\u4f8b\u5916", "ProcessExceptedEntityPlugin_4", "bos-wf-devops"), (Object[])new Object[0]);
            }
            if (!(insertList = (ArrayList)CollectionUtils.subtract(newList, oldList)).isEmpty()) {
                entityManager.batchInsert(insertList);
                WfUtils.addOpLog((String)"wf_exceptedentity", (String)"new", (MultiLangEnumBridge)new MultiLangEnumBridge("\u65b0\u589e", "ProcessExceptedEntityPlugin_2", "bos-wf-devops"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u65b0\u589e\u4f8b\u5916", "ProcessExceptedEntityPlugin_5", "bos-wf-devops"), (Object[])new Object[0]);
            }
            return null;
        });
    }

    @Override
    public Integer collectAndStatisticsIndicator(List<String> numbers, int collectLimit) {
        return (Integer)this.commandExecutor.execute(commandContext -> new CollectAndStatisticsIndicatorCmd(numbers, collectLimit).execute(commandContext));
    }

    @Override
    public Void scanPluginClass() {
        return (Void)this.commandExecutor.execute((Command)new ScanPluginClassCmd());
    }

    @Override
    public List<IndicatorInfo> getReportIndicators() {
        return (List)this.commandExecutor.execute((Command)new GetReportDatasCmd());
    }

    @Override
    public void makeProcessInst(ProcessInstData processInstData) {
        this.commandExecutor.execute((Command)new ProcessInstMakeCmd(processInstData));
    }

    @Override
    public ProcessInstData getProcessMakeData(Long procInstId, List<Long> currentActIds) {
        return (ProcessInstData)this.commandExecutor.execute((Command)new GetProcessMakeDataCmd(procInstId, currentActIds));
    }
}

