/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.statisticalanalysis;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.workflow.devopos.info.IndicatorInfo;
import kd.bos.workflow.devops.api.IDataCapture;
import kd.bos.workflow.devops.statisticalanalysis.captures.AsyncAddressMessageCapture;
import kd.bos.workflow.devops.statisticalanalysis.captures.AsyncMessageCapture;
import kd.bos.workflow.devops.statisticalanalysis.captures.AsyncMessageDailyCapture;
import kd.bos.workflow.devops.statisticalanalysis.captures.AsyncMessageMinuteConsumerCapture;
import kd.bos.workflow.devops.statisticalanalysis.captures.AsyncMessageMinuteSendCapture;
import kd.bos.workflow.devops.statisticalanalysis.captures.AsyncMessageMonthilyCapture;
import kd.bos.workflow.devops.statisticalanalysis.captures.EffectiveCustomerCapture;
import kd.bos.workflow.devops.statisticalanalysis.captures.ExceptionalProcessInstanceCapture;
import kd.bos.workflow.devops.statisticalanalysis.captures.ProcessDefinitionCapture;
import kd.bos.workflow.devops.statisticalanalysis.captures.ProcessInstanceAllCapture;
import kd.bos.workflow.devops.statisticalanalysis.captures.ProcessInstanceCapture;
import kd.bos.workflow.devops.statisticalanalysis.captures.bec.BecAsyncMessageBySubscriptionCapture;
import kd.bos.workflow.devops.statisticalanalysis.captures.bec.BecAsyncMessageCapture;
import kd.bos.workflow.devops.statisticalanalysis.captures.bec.BecAsyncMessageDailyCapture;
import kd.bos.workflow.devops.statisticalanalysis.captures.bec.BecAsyncMessageMinuteConsumerCapture;
import kd.bos.workflow.devops.statisticalanalysis.captures.bec.BecAsyncMessageMinuteSendCapture;
import kd.bos.workflow.devops.statisticalanalysis.captures.bec.BecAsyncMessageMonthilyCapture;
import kd.bos.workflow.devops.statisticalanalysis.captures.bec.BecInstanceDailyCapture;
import kd.bos.workflow.devops.statisticalanalysis.captures.bec.BecInstanceInfoDailyCapture;
import kd.bos.workflow.devops.statisticalanalysis.captures.bec.BusinessEventByAppCapture;
import kd.bos.workflow.devops.statisticalanalysis.captures.bec.BusinessEventDefCapture;
import kd.bos.workflow.devops.statisticalanalysis.captures.bec.BusinessEventDefineBySubscribedCapture;
import kd.bos.workflow.devops.statisticalanalysis.captures.bec.BusinessEventJobByEventCapture;
import kd.bos.workflow.devops.statisticalanalysis.captures.bec.BusinessEventJobByServiceCapture;
import kd.bos.workflow.devops.statisticalanalysis.captures.bec.BusinessEventJobBySubscribedCapture;
import kd.bos.workflow.devops.statisticalanalysis.captures.bec.BusinessEventJobRecordCapture;
import kd.bos.workflow.devops.statisticalanalysis.captures.bec.BusinessEventSceneCapture;
import kd.bos.workflow.devops.statisticalanalysis.captures.bec.BusinessEventSubscriptionDistributioninCapture;
import kd.bos.workflow.devops.statisticalanalysis.captures.bec.BusinessServiceBySubscribedCapture;
import kd.bos.workflow.devops.statisticalanalysis.captures.bec.BusinessServiceCapture;
import kd.bos.workflow.devops.statisticalanalysis.captures.bec.BusinessSubscriptionCapture;
import kd.bos.workflow.devops.statisticalanalysis.captures.bpm.BillRelationCapture;
import kd.bos.workflow.devops.statisticalanalysis.captures.bpm.BizProcessInstanceDailyCapture;
import kd.bos.workflow.devops.statisticalanalysis.captures.bpm.BizProcessInstanceMonthilyCapture;
import kd.bos.workflow.devops.statisticalanalysis.captures.wf.ApproveTerminalCapture;
import kd.bos.workflow.devops.statisticalanalysis.captures.wf.ExpectionProcessDailyCapture;
import kd.bos.workflow.devops.statisticalanalysis.captures.wf.HistoricProcessInstanceCapture;
import kd.bos.workflow.devops.statisticalanalysis.captures.wf.NoStartedProcessCapture;
import kd.bos.workflow.devops.statisticalanalysis.captures.wf.OperationLogCapture;
import kd.bos.workflow.devops.statisticalanalysis.captures.wf.PluginExecuteCapture;
import kd.bos.workflow.devops.statisticalanalysis.captures.wf.ProcessInstanceDailyCapture;
import kd.bos.workflow.devops.statisticalanalysis.captures.wf.ProcessInstanceMonthilyCapture;
import kd.bos.workflow.devops.statisticalanalysis.captures.wf.RejectBillsCapture;
import kd.bos.workflow.devops.statisticalanalysis.captures.wf.ScheduleStataeCapture;
import kd.bos.workflow.devops.statisticalanalysis.captures.wf.TaskCompleteCapture;
import kd.bos.workflow.devops.statisticalanalysis.captures.wf.TaskDailyCapture;
import kd.bos.workflow.devops.statisticalanalysis.captures.wf.TaskMonthilyCapture;

public class DataCaptureFactory {
    private static Map<String, IDataCapture> capturesMap = new HashMap<String, IDataCapture>();
    private static boolean initComplete = false;
    private static ReentrantLock lock = new ReentrantLock();

    private static void init() {
        BillRelationCapture billRelationCapture = new BillRelationCapture();
        capturesMap.put("billRelationGraph", billRelationCapture);
        ApproveTerminalCapture approveTerminalCapture = new ApproveTerminalCapture();
        capturesMap.put("approveTerminal", approveTerminalCapture);
        BusinessEventSceneCapture businessEventSceneCapture = new BusinessEventSceneCapture();
        capturesMap.put("businessEventEntityNumber", businessEventSceneCapture);
        EffectiveCustomerCapture effectiveCustomerCapture = new EffectiveCustomerCapture();
        capturesMap.put("effectiveCustomer", effectiveCustomerCapture);
        OperationLogCapture operationLogCapture = new OperationLogCapture();
        capturesMap.put("operationLog", operationLogCapture);
        RejectBillsCapture rejectBillsCapture = new RejectBillsCapture();
        capturesMap.put("rejectBills", rejectBillsCapture);
        BusinessEventJobRecordCapture businessEventJobRecordCapture = new BusinessEventJobRecordCapture();
        capturesMap.put("businessEventJobRecord", businessEventJobRecordCapture);
        BusinessEventSubscriptionDistributioninCapture businessEventSubscriptionCapture = new BusinessEventSubscriptionDistributioninCapture();
        capturesMap.put(" businessEventSubscriptionDistributionin", businessEventSubscriptionCapture);
        ProcessDefinitionCapture processDefinitionCapture = new ProcessDefinitionCapture();
        capturesMap.put("processDefinition", processDefinitionCapture);
        ProcessInstanceCapture processInstanceCapture = new ProcessInstanceCapture();
        capturesMap.put("processInstance", processInstanceCapture);
        HistoricProcessInstanceCapture historicProcessInstanceCapture = new HistoricProcessInstanceCapture();
        capturesMap.put("historicProcessInstance", historicProcessInstanceCapture);
        ProcessInstanceDailyCapture processInstanceDailyCapture = new ProcessInstanceDailyCapture();
        capturesMap.put("processInstanceDaily", processInstanceDailyCapture);
        ProcessInstanceAllCapture processInstanceAllCapture = new ProcessInstanceAllCapture();
        capturesMap.put("processInstanceAll", processInstanceAllCapture);
        ProcessInstanceMonthilyCapture processInstanceMonthilyCapture = new ProcessInstanceMonthilyCapture();
        capturesMap.put("processInstanceMonthily", processInstanceMonthilyCapture);
        BizProcessInstanceDailyCapture bizProcessInstanceDailyCapture = new BizProcessInstanceDailyCapture();
        capturesMap.put("bizProcessInstanceDaily", bizProcessInstanceDailyCapture);
        BizProcessInstanceMonthilyCapture bizProcessInstanceMonthlyCapture = new BizProcessInstanceMonthilyCapture();
        capturesMap.put("bizProcessInstanceMonthly", bizProcessInstanceMonthlyCapture);
        TaskDailyCapture taskDailyCapture = new TaskDailyCapture();
        capturesMap.put("taskDaily", taskDailyCapture);
        TaskMonthilyCapture taskMonthilyCapture = new TaskMonthilyCapture();
        capturesMap.put("taskMonthily", taskMonthilyCapture);
        TaskCompleteCapture taskCompleteCapture = new TaskCompleteCapture();
        capturesMap.put("taskComplete", taskCompleteCapture);
        AsyncMessageCapture asyncMessageCapture = new AsyncMessageCapture();
        capturesMap.put("asyncMessage", asyncMessageCapture);
        AsyncMessageDailyCapture asyncMessageDailyCapture = new AsyncMessageDailyCapture();
        capturesMap.put("asyncMessageDaily", asyncMessageDailyCapture);
        AsyncMessageMonthilyCapture asyncMessageMonthilyCapture = new AsyncMessageMonthilyCapture();
        capturesMap.put("asyncMessageMonthily", asyncMessageMonthilyCapture);
        BusinessEventByAppCapture businessEventByAppCapture = new BusinessEventByAppCapture();
        capturesMap.put("businessEventByApp", businessEventByAppCapture);
        BusinessEventDefCapture businessEventDefCapture = new BusinessEventDefCapture();
        capturesMap.put("businessEventDef", businessEventDefCapture);
        BusinessEventDefineBySubscribedCapture businessEventDefineBySubscribedCapture = new BusinessEventDefineBySubscribedCapture();
        capturesMap.put("businessEventDefineBySubscribed", businessEventDefineBySubscribedCapture);
        BusinessEventJobByEventCapture businessEventJobByEventCapture = new BusinessEventJobByEventCapture();
        capturesMap.put("businessEventJobByEvent", businessEventJobByEventCapture);
        BusinessEventJobByServiceCapture businessEventJobByServiceCapture = new BusinessEventJobByServiceCapture();
        capturesMap.put("businessEventJobByService", businessEventJobByServiceCapture);
        BusinessEventJobBySubscribedCapture businessEventJobBySubscribedCapture = new BusinessEventJobBySubscribedCapture();
        capturesMap.put("businessEventJobBySubscribed", businessEventJobBySubscribedCapture);
        BusinessServiceBySubscribedCapture businessServiceBySubscribedCapture = new BusinessServiceBySubscribedCapture();
        capturesMap.put("businessServiceBySubscribed", businessServiceBySubscribedCapture);
        BecAsyncMessageCapture becAsyncMessageCapture = new BecAsyncMessageCapture();
        capturesMap.put("becAsyncMessage", becAsyncMessageCapture);
        BecAsyncMessageDailyCapture becAsyncMessageDailyCapture = new BecAsyncMessageDailyCapture();
        capturesMap.put("becAsyncMessageDaily", becAsyncMessageDailyCapture);
        BecAsyncMessageMonthilyCapture becAsyncMessageMonthilyCapture = new BecAsyncMessageMonthilyCapture();
        capturesMap.put("becAsyncMessageMonthily", becAsyncMessageMonthilyCapture);
        AsyncAddressMessageCapture asyncAddressMessageCapture = new AsyncAddressMessageCapture();
        capturesMap.put("addressMessage", asyncAddressMessageCapture);
        PluginExecuteCapture pluginExecuteCapture = new PluginExecuteCapture();
        capturesMap.put("pluginExecutionInfo", pluginExecuteCapture);
        AsyncMessageMinuteSendCapture asyncMessageMinuteProductCapture = new AsyncMessageMinuteSendCapture();
        capturesMap.put("asyncMessageMinutelySend", asyncMessageMinuteProductCapture);
        AsyncMessageMinuteConsumerCapture asyncMessageMinuteConsumerCapture = new AsyncMessageMinuteConsumerCapture();
        capturesMap.put("asyncMessageMinutelyConsumer", asyncMessageMinuteConsumerCapture);
        ExceptionalProcessInstanceCapture exceptionalProcessInstanceCapture = new ExceptionalProcessInstanceCapture();
        capturesMap.put("exceptionalprocess", exceptionalProcessInstanceCapture);
        ExpectionProcessDailyCapture expectionProcessDailyCapture = new ExpectionProcessDailyCapture();
        capturesMap.put("expectionProcessDaily", expectionProcessDailyCapture);
        NoStartedProcessCapture noStartedProcessCapture = new NoStartedProcessCapture();
        capturesMap.put("noStartedProcess", noStartedProcessCapture);
        ScheduleStataeCapture scheduleStataeCapture = new ScheduleStataeCapture();
        capturesMap.put("scheduleStatae", scheduleStataeCapture);
        BusinessServiceCapture businessServiceCapture = new BusinessServiceCapture();
        capturesMap.put("businessService", businessServiceCapture);
        BusinessSubscriptionCapture businessSubscriptionCapture = new BusinessSubscriptionCapture();
        capturesMap.put("businessSubscription", businessSubscriptionCapture);
        BecInstanceDailyCapture becInstanceDailyCapture = new BecInstanceDailyCapture();
        capturesMap.put("becInstanceDaily", becInstanceDailyCapture);
        BecInstanceInfoDailyCapture becInstanceInfoDailyCapture = new BecInstanceInfoDailyCapture();
        capturesMap.put("becInstanceInfoDaily", becInstanceInfoDailyCapture);
        BecAsyncMessageMinuteConsumerCapture becAsyncMessageMinuteConsumerCapture = new BecAsyncMessageMinuteConsumerCapture();
        capturesMap.put("becAsyncMessageMinutelyConsumer", becAsyncMessageMinuteConsumerCapture);
        BecAsyncMessageMinuteSendCapture becAsyncMessageMinuteProductCapture = new BecAsyncMessageMinuteSendCapture();
        capturesMap.put("becAsyncMessageMinutelySend", becAsyncMessageMinuteProductCapture);
        BecAsyncMessageBySubscriptionCapture becAsyncMessageBySubscription = new BecAsyncMessageBySubscriptionCapture();
        capturesMap.put("BecAsyncMessageBySubscription", becAsyncMessageBySubscription);
    }

    public static IDataCapture getDataCaptureInterface(IndicatorInfo info) {
        if (info != null) {
            return DataCaptureFactory.getDataCaptureInterface(info.getNumber());
        }
        return null;
    }

    public static Map<String, IDataCapture> getCapturesMap() {
        if (initComplete) {
            return capturesMap;
        }
        lock.lock();
        try {
            if (capturesMap.isEmpty() || !capturesMap.containsKey("billRelationGraph")) {
                DataCaptureFactory.init();
                initComplete = true;
            }
        }
        finally {
            lock.unlock();
        }
        return capturesMap;
    }

    public static IDataCapture getDataCaptureInterface(String number) {
        if (initComplete) {
            return capturesMap.get(number);
        }
        lock.lock();
        try {
            if (capturesMap.isEmpty() || !capturesMap.containsKey("billRelationGraph")) {
                DataCaptureFactory.init();
                initComplete = true;
            }
        }
        finally {
            lock.unlock();
        }
        return capturesMap.get(number);
    }

    public static final void register(String key, IDataCapture capture) {
        if (StringUtils.isNotBlank((CharSequence)key) && !capturesMap.containsKey(key)) {
            capturesMap.put(key, capture);
        }
    }
}

