/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.statisticalanalysis.captures;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.workflow.devopos.info.IndicatorInfo;
import kd.bos.workflow.devops.api.IDataCapture;
import kd.bos.workflow.devops.entity.BehaviorCollectorEntity;
import kd.bos.workflow.devops.entity.BehaviorCollectorEntityManager;
import kd.bos.workflow.devops.entity.DevopsIndicatorEntity;
import kd.bos.workflow.devops.statisticalanalysis.captures.CaptureCategoryEnum;
import kd.bos.workflow.devops.statisticalanalysis.utils.CaptureUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;

public abstract class AbstractOperationCapture
implements IDataCapture {
    protected static final String PROCESSTYPE_BIZFLOW = "BizFlow";
    protected static final String PROCESSTYPE_AUDITFLOW = "AuditFlow";

    @Override
    public void capture(IndicatorInfo indicatorInfo) {
        String type = indicatorInfo.getDimValue() != null ? indicatorInfo.getDimValue().toString() : null;
        BehaviorCollectorEntityManager entityManager = (BehaviorCollectorEntityManager)Objects.requireNonNull(Context.getCommandContext()).getEntityManager(BehaviorCollectorEntityManager.class);
        List<BehaviorCollectorEntity> entitys = entityManager.findByNumberAndType(indicatorInfo.getNumber(), type);
        if (!entitys.isEmpty()) {
            entitys.get(0).setTotal(entitys.get(0).getTotal() + (long)indicatorInfo.getAddCount());
            entityManager.update(entitys.get(0));
        } else {
            if (WfUtils.isEmpty((ILocaleString)indicatorInfo.getDimDisplayValue())) {
                indicatorInfo.setDimDisplayValue(this.getDimName(type, true));
            }
            BehaviorCollectorEntity entity = CaptureUtils.buildBehaviorCollectorEntity(indicatorInfo, CaptureCategoryEnum.OPERATIONTYPE.getNumber());
            Long total = 0L;
            if (this.isNeedCollectHistoricalData(type)) {
                total = total + this.collectHistoricalDataCount(entity.getType());
            }
            total = total + entity.getTotal();
            entity.setTotal(total);
            entityManager.insert(entity);
        }
    }

    @Override
    public List<IndicatorInfo> fetch(String number, String dimValue) {
        List<BehaviorCollectorEntity> entitys = ((BehaviorCollectorEntityManager)Objects.requireNonNull(Context.getCommandContext()).getEntityManager(BehaviorCollectorEntityManager.class)).findByNumberAndType(number, dimValue);
        ArrayList<IndicatorInfo> infos = new ArrayList<IndicatorInfo>(entitys.size());
        entitys.forEach(entity -> infos.add(this.build((Entity)entity)));
        return infos;
    }

    @Override
    public IndicatorInfo build(Entity entity) {
        IndicatorInfo info = new IndicatorInfo();
        if (entity instanceof DevopsIndicatorEntity) {
            DevopsIndicatorEntity devopsIndicatorEntity = (DevopsIndicatorEntity)entity;
            info.setNumber(devopsIndicatorEntity.getNumber());
            info.setAppNumber(this.getAppNumber());
            info.setCategory(CaptureCategoryEnum.OPERATIONTYPE.getNumber());
            info.setName(this.getName());
            info.setDimDisplayValue(this.getDimName(devopsIndicatorEntity.getDimValue(), false));
            info.setDim(this.getDim());
            info.setDimValue((Object)devopsIndicatorEntity.getDimValue());
            info.setAddCount(devopsIndicatorEntity.getAddCount());
            if (StringUtils.isNotBlank((CharSequence)devopsIndicatorEntity.getParams())) {
                info.setSpecialProperty((Map)SerializationUtils.fromJsonString((String)devopsIndicatorEntity.getParams(), Map.class));
            }
            return info;
        }
        if (entity instanceof BehaviorCollectorEntity) {
            BehaviorCollectorEntity behaviorCollectorEntity = (BehaviorCollectorEntity)entity;
            info.setNumber(behaviorCollectorEntity.getNumber());
            info.setAppNumber(this.getAppNumber());
            info.setCategory(CaptureCategoryEnum.OPERATIONTYPE.getNumber());
            info.setName(this.getName());
            info.setDimDisplayValue(behaviorCollectorEntity.getTypeName());
            info.setDim(this.getDim());
            info.setDimValue((Object)behaviorCollectorEntity.getType());
            info.setTotal(behaviorCollectorEntity.getTotal());
            return info;
        }
        return null;
    }

    public abstract ILocaleString getDimName(String var1, boolean var2);

    public abstract String getDim();

    protected IndicatorInfo build(String number, String dimValue) {
        IndicatorInfo info = new IndicatorInfo();
        info.setNumber(number);
        info.setAppNumber(this.getAppNumber());
        info.setName(this.getName());
        info.setCategory(CaptureCategoryEnum.OPERATIONTYPE.getNumber());
        info.setDimValue((Object)dimValue);
        info.setDimDisplayValue(this.getDimName(dimValue, false));
        info.setDim(this.getDim());
        return info;
    }

    protected boolean isNeedCollectHistoricalData(String type) {
        return false;
    }

    protected Long collectHistoricalDataCount(String type) {
        return 0L;
    }

    protected ILocaleString getName() {
        return new LocaleString();
    }

    protected String getAppNumber() {
        return null;
    }

    public Boolean canGroupByNumberAndDim() {
        return Boolean.TRUE;
    }

    public List<IndicatorInfo> getGroupAndSelfIndicatorInfos(DevopsIndicatorEntity devopsIndicatorEntity) {
        return new ArrayList<IndicatorInfo>();
    }

    protected IndicatorInfo buildFromOtherIndicatorInfo(IndicatorInfo indicatorInfo) {
        return indicatorInfo;
    }
}

