/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.statisticalanalysis.captures;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.workflow.devopos.info.IndicatorInfo;
import kd.bos.workflow.devops.api.IDataCapture;
import kd.bos.workflow.devops.entity.BehaviorCollectorEntity;
import kd.bos.workflow.devops.entity.DevopsIndicatorEntity;
import kd.bos.workflow.devops.statisticalanalysis.captures.CaptureCategoryEnum;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;

public abstract class AbstractSqlCapture
implements IDataCapture {
    @Override
    public void capture(IndicatorInfo indicatorInfo) {
    }

    @Override
    public IndicatorInfo build(Entity entity) {
        IndicatorInfo info = new IndicatorInfo();
        if (entity instanceof DevopsIndicatorEntity) {
            DevopsIndicatorEntity devopsIndicatorEntity = (DevopsIndicatorEntity)entity;
            info.setNumber(devopsIndicatorEntity.getNumber());
            info.setAppNumber(this.getAppNumber());
            info.setCategory(CaptureCategoryEnum.SQLTYPE.getNumber());
            info.setName(this.getName());
            info.setDimDisplayValue(this.getDimName(devopsIndicatorEntity.getDimValue()));
            info.setDim(this.getDim());
            info.setDimValue((Object)devopsIndicatorEntity.getDimValue());
            info.setAddCount(devopsIndicatorEntity.getAddCount());
            if (StringUtils.isNotBlank((CharSequence)devopsIndicatorEntity.getParams())) {
                info.setSpecialProperty((Map)SerializationUtils.fromJsonString((String)devopsIndicatorEntity.getParams(), Map.class));
            }
            return info;
        }
        if (entity instanceof BehaviorCollectorEntity) {
            BehaviorCollectorEntity behaviorCollectorEntity = (BehaviorCollectorEntity)entity;
            info.setNumber(behaviorCollectorEntity.getNumber());
            info.setAppNumber(this.getAppNumber());
            info.setCategory(CaptureCategoryEnum.SQLTYPE.getNumber());
            info.setName(this.getName());
            info.setDimDisplayValue(behaviorCollectorEntity.getTypeName());
            info.setDim(this.getDim());
            info.setDimValue((Object)behaviorCollectorEntity.getType());
            info.setTotal(behaviorCollectorEntity.getTotal());
            return info;
        }
        return null;
    }

    protected IndicatorInfo build(String number, String dimValue) {
        IndicatorInfo info = new IndicatorInfo();
        info.setNumber(number);
        info.setAppNumber(this.getAppNumber());
        info.setName(this.getName());
        info.setCategory(CaptureCategoryEnum.SQLTYPE.getNumber());
        info.setDimValue((Object)dimValue);
        info.setDimDisplayValue(this.getDimName(dimValue));
        info.setDim(this.getDim());
        return info;
    }

    @Override
    public List<IndicatorInfo> fetch(String number, String dimValue) {
        ArrayList<IndicatorInfo> list = new ArrayList<IndicatorInfo>(1);
        String sql = this.getQueryCountSql(dimValue);
        Long count = this.getResultCountFromEntity(dimValue);
        if (sql != null) {
            IndicatorInfo indicatorInfo = this.build(number, dimValue);
            try (DataSet ds = DB.queryDataSet((String)"workflow_AbstractSqlCapture", (DBRoute)WfUtils.WFS, (String)sql);){
                Iterator iter = ds.iterator();
                if (iter.hasNext()) {
                    indicatorInfo.setTotal(((Row)iter.next()).getLong("count"));
                }
            }
            list.add(indicatorInfo);
        } else if (count > -1L) {
            IndicatorInfo indicatorInfo = this.build(number, dimValue);
            indicatorInfo.setTotal(count);
            list.add(indicatorInfo);
        }
        return list;
    }

    public String getCollectorType() {
        return CaptureCategoryEnum.SQLTYPE.getNumber();
    }

    protected String getQueryCountSql(String type) {
        return null;
    }

    protected Long getResultCountFromEntity(String type) {
        return -1L;
    }

    public abstract ILocaleString getDimName(String var1);

    public abstract String getDim();

    protected ILocaleString getName() {
        return new LocaleString();
    }

    protected String getAppNumber() {
        return null;
    }
}

