/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.statisticalanalysis.captures;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.workflow.devopos.info.IndicatorInfo;
import kd.bos.workflow.devops.api.IDataCapture;
import kd.bos.workflow.devops.entity.DevopsIndicatorEntity;
import kd.bos.workflow.devops.statisticalanalysis.DataCaptureFactory;
import kd.bos.workflow.devops.statisticalanalysis.captures.AbstractOperationCapture;
import kd.bos.workflow.devops.statisticalanalysis.captures.AsyncMessageDimensionEnum;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;
import kd.bos.workflow.engine.impl.persistence.entity.job.AbstractJobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.DeadLetterJobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.TimerJobEntity;

public class AsyncAddressMessageCapture
extends AbstractOperationCapture {
    public static final String NUMBER = "addressMessage";

    @Override
    public IndicatorInfo build(Entity entity) {
        if (entity instanceof AbstractJobEntity && !"address-process-event".equalsIgnoreCase(((AbstractJobEntity)entity).getJobHandlerType())) {
            return null;
        }
        if (entity instanceof TimerJobEntity && "message".equalsIgnoreCase(((TimerJobEntity)entity).getJobType())) {
            return new IndicatorInfo(NUMBER, (Object)AsyncMessageDimensionEnum.TIMING.getNumber());
        }
        if (entity instanceof DeadLetterJobEntity) {
            return new IndicatorInfo(NUMBER, (Object)AsyncMessageDimensionEnum.FAIL.getNumber());
        }
        return super.build(entity);
    }

    @Override
    public ILocaleString getDimName(String type, boolean isNeedQueryTable) {
        return null;
    }

    @Override
    public String getDim() {
        return "type";
    }

    @Override
    protected String getAppNumber() {
        return "wf,bpm";
    }

    @Override
    protected ILocaleString getName() {
        return ResManager.getLocaleString((String)"\u5bfb\u5740\u5f02\u6b65\u6d88\u606f\u6570\u91cf", (String)"AsyncAddressMessageCapture_0", (String)"bos-wf-devops");
    }

    @Override
    public List<IndicatorInfo> getGroupAndSelfIndicatorInfos(DevopsIndicatorEntity devopsIndicatorEntity) {
        ArrayList<IndicatorInfo> infos = new ArrayList<IndicatorInfo>(4);
        if (AsyncMessageDimensionEnum.SEND.getNumber().equals(devopsIndicatorEntity.getDimValue())) {
            IndicatorInfo parentIndicatorInfo = this.build(devopsIndicatorEntity);
            infos.add(parentIndicatorInfo);
            IndicatorInfo productInfo = parentIndicatorInfo.clone();
            productInfo.setDimValue((Object)AsyncMessageDimensionEnum.PRODUCT.getNumber());
            productInfo.setDimDisplayValue((ILocaleString)AsyncMessageDimensionEnum.PRODUCT.getName().toLocaleString());
            infos.add(productInfo);
            IndicatorInfo tmpInfo = parentIndicatorInfo.clone();
            tmpInfo.setDimValue((Object)("address_" + AsyncMessageDimensionEnum.PRODUCT.getNumber()));
            IDataCapture asyncMessageDaily = DataCaptureFactory.getDataCaptureInterface("asyncMessageDaily");
            IndicatorInfo asyncMessageDailyInfo = ((AbstractOperationCapture)asyncMessageDaily).buildFromOtherIndicatorInfo(tmpInfo);
            infos.add(asyncMessageDailyInfo);
            IDataCapture asyncMessageMonthily = DataCaptureFactory.getDataCaptureInterface("asyncMessageMonthily");
            IndicatorInfo asyncMessageMonthilyInfo = ((AbstractOperationCapture)asyncMessageMonthily).buildFromOtherIndicatorInfo(tmpInfo);
            infos.add(asyncMessageMonthilyInfo);
        }
        return infos;
    }
}

