/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.statisticalanalysis.captures;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.thread.ThreadTruck;
import kd.bos.workflow.devopos.info.IndicatorInfo;
import kd.bos.workflow.devops.api.IDataCapture;
import kd.bos.workflow.devops.entity.DevopsIndicatorEntity;
import kd.bos.workflow.devops.statisticalanalysis.DataCaptureFactory;
import kd.bos.workflow.devops.statisticalanalysis.captures.AbstractOperationCapture;
import kd.bos.workflow.devops.statisticalanalysis.captures.AsyncMessageDimensionEnum;
import kd.bos.workflow.devops.util.DevopsUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;
import kd.bos.workflow.engine.impl.persistence.entity.job.AbstractJobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.DeadLetterJobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntityImpl;
import kd.bos.workflow.engine.impl.persistence.entity.job.TimerJobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;

public class AsyncMessageCapture
extends AbstractOperationCapture {
    public static final String NUMBER = "asyncMessage";
    private static final String PROCDEFID = "procDefId";
    private static final String PROCESSTYPE = "processType";
    private static final String ERRORTYPE = "errorType";

    @Override
    public IndicatorInfo build(Entity entity) {
        IndicatorInfo indicatorInfo;
        JobEntityImpl job;
        if (entity instanceof AbstractJobEntity && "address-process-event".equalsIgnoreCase(((AbstractJobEntity)entity).getJobHandlerType())) {
            return null;
        }
        if (entity instanceof JobEntity && (StringUtils.isBlank((Object)(job = (JobEntityImpl)entity).getRootJobId()) || job.getId().equals(job.getRootJobId()))) {
            IndicatorInfo indicatorInfo2 = new IndicatorInfo(NUMBER, (Object)AsyncMessageDimensionEnum.PRODUCT.getNumber());
            indicatorInfo2.addToSpecialProperty(PROCDEFID, (Object)job.getProcessDefinitionId());
            indicatorInfo2.addToSpecialProperty("createDate", (Object)job.getCreateDate());
            return indicatorInfo2;
        }
        if (entity instanceof TimerJobEntity) {
            job = (TimerJobEntity)entity;
            if ("timer".equals(job.getJobType())) {
                IndicatorInfo indicatorInfo3 = new IndicatorInfo(NUMBER, (Object)AsyncMessageDimensionEnum.PRODUCT.getNumber());
                indicatorInfo3.addToSpecialProperty(PROCDEFID, (Object)job.getProcessDefinitionId());
                indicatorInfo3.addToSpecialProperty("createDate", (Object)job.getCreateDate());
                return indicatorInfo3;
            }
            if ("message".equals(job.getJobType()) && job.isInserted()) {
                IndicatorInfo indicatorInfo4 = new IndicatorInfo(NUMBER, (Object)AsyncMessageDimensionEnum.TIMING.getNumber());
                indicatorInfo4.addToSpecialProperty(PROCDEFID, (Object)job.getProcessDefinitionId());
                return indicatorInfo4;
            }
        }
        if (entity instanceof DeadLetterJobEntity) {
            indicatorInfo = new IndicatorInfo(NUMBER, (Object)AsyncMessageDimensionEnum.FAIL.getNumber());
            indicatorInfo.addToSpecialProperty(PROCESSTYPE, (Object)((DeadLetterJobEntity)entity).getProcessType());
            indicatorInfo.addToSpecialProperty(ERRORTYPE, (Object)((DeadLetterJobEntity)entity).getErrorType());
            indicatorInfo.addToSpecialProperty("createDate", (Object)entity.getCreateDate());
            return indicatorInfo;
        }
        if (entity instanceof DevopsIndicatorEntity) {
            indicatorInfo = super.build(entity);
            String dimValue = (String)Optional.ofNullable(indicatorInfo.getDimValue()).orElseGet(() -> null);
            String processType = null;
            if (StringUtils.isNotBlank((Object)indicatorInfo.getSpecialProperty(PROCESSTYPE))) {
                processType = indicatorInfo.getSpecialProperty(PROCESSTYPE).toString();
            }
            if (processType == null) {
                Object procDefId = indicatorInfo.getSpecialProperty(PROCDEFID);
                if (procDefId == null) {
                    return null;
                }
                Map procDefIds = (Map)Optional.ofNullable(ThreadTruck.get((Object)"wfProcDefIds")).orElseGet(() -> new HashMap(100));
                Object processTypeTmp = procDefIds.get(procDefId);
                if (StringUtils.isNotBlank(processTypeTmp)) {
                    processType = (String)processTypeTmp;
                } else {
                    ProcessDefinitionEntity proceDef = DevopsUtils.getWorkflowService().getRepositoryService().getProcessdefineById((Long)procDefId);
                    if (proceDef != null) {
                        processType = proceDef.getType();
                        procDefIds.put((Long)procDefId, processType);
                        ThreadTruck.put((Object)"wfProcDefIds", (Object)procDefIds);
                    }
                }
            }
            if (WfUtils.isEmpty(processType)) {
                return null;
            }
            IndicatorInfo asyncMessageInfo = indicatorInfo.clone();
            asyncMessageInfo.setDimDisplayValue(AsyncMessageDimensionEnum.getNameByNumber(dimValue));
            String type = "AuditFlow".equals(processType) ? "wf_" + dimValue : "biz_" + dimValue;
            asyncMessageInfo.setDimValue((Object)type);
            return asyncMessageInfo;
        }
        return super.build(entity);
    }

    @Override
    public ILocaleString getDimName(String type, boolean isNeedQueryTable) {
        return null;
    }

    @Override
    public String getDim() {
        return "type";
    }

    @Override
    protected String getAppNumber() {
        return "wf,bpm";
    }

    @Override
    protected ILocaleString getName() {
        return ResManager.getLocaleString((String)"\u5f02\u6b65\u6d88\u606f\u6570\u91cf", (String)"AsyncMessageCapture_0", (String)"bos-wf-devops");
    }

    @Override
    public List<IndicatorInfo> getGroupAndSelfIndicatorInfos(DevopsIndicatorEntity devopsIndicatorEntity) {
        ArrayList<IndicatorInfo> infos = new ArrayList<IndicatorInfo>();
        IndicatorInfo parentIndicationInfo = this.build(devopsIndicatorEntity);
        if (parentIndicationInfo == null) {
            return infos;
        }
        infos.add(parentIndicationInfo);
        if (AsyncMessageDimensionEnum.PRODUCT.getNumber().equals(devopsIndicatorEntity.getDimValue())) {
            IDataCapture asyncMessageDaily = DataCaptureFactory.getDataCaptureInterface("asyncMessageDaily");
            IndicatorInfo asyncMessageDailyInfo = ((AbstractOperationCapture)asyncMessageDaily).buildFromOtherIndicatorInfo(parentIndicationInfo);
            infos.add(asyncMessageDailyInfo);
            IDataCapture asyncMessageMonthily = DataCaptureFactory.getDataCaptureInterface("asyncMessageMonthily");
            IndicatorInfo asyncMessageMonthilyInfo = ((AbstractOperationCapture)asyncMessageMonthily).buildFromOtherIndicatorInfo(parentIndicationInfo);
            infos.add(asyncMessageMonthilyInfo);
        }
        if (AsyncMessageDimensionEnum.FAIL.getNumber().equals(devopsIndicatorEntity.getDimValue())) {
            IDataCapture expectionProcessDaily = DataCaptureFactory.getDataCaptureInterface("expectionProcessDaily");
            IndicatorInfo expectionProcessDailyInfo = ((AbstractOperationCapture)expectionProcessDaily).buildFromOtherIndicatorInfo(parentIndicationInfo);
            infos.add(expectionProcessDailyInfo);
        }
        return infos;
    }
}

