/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.statisticalanalysis.captures;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.devopos.info.IndicatorInfo;
import kd.bos.workflow.devops.statisticalanalysis.captures.AbstractOperationCapture;
import kd.bos.workflow.devops.statisticalanalysis.captures.AsyncMessageDailyCapture;
import kd.bos.workflow.devops.statisticalanalysis.captures.AsyncMessageDimensionEnum;
import org.apache.commons.lang.time.DateFormatUtils;

public class AsyncMessageMonthilyCapture
extends AbstractOperationCapture {
    public static final String NUMBER = "asyncMessageMonthily";
    private Log logger = LogFactory.getLog(AsyncMessageDailyCapture.class);

    @Override
    protected IndicatorInfo buildFromOtherIndicatorInfo(IndicatorInfo indicatorInfo) {
        Object createDate = indicatorInfo.getSpecialProperty("createDate");
        if (createDate != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date date = new Date();
            try {
                date = sdf.parse((String)createDate);
            }
            catch (ParseException e) {
                this.logger.info("AsyncMessageDailyCapture_capture format date error" + createDate);
            }
            String type = DateFormatUtils.format((Date)date, (String)"yyyyMM");
            IndicatorInfo info = this.build(NUMBER, type);
            info.setAddCount(indicatorInfo.getAddCount());
            info.setDimDisplayValue(null);
            info.setDimValue((Object)(indicatorInfo.getDimValue().toString().replace(AsyncMessageDimensionEnum.PRODUCT.getNumber(), "") + type));
            return info;
        }
        return null;
    }

    @Override
    public ILocaleString getDimName(String type, boolean isNeedQueryTable) {
        return null;
    }

    @Override
    public String getDim() {
        return "month";
    }

    @Override
    protected String getAppNumber() {
        return "wf,bpm";
    }

    @Override
    protected ILocaleString getName() {
        return ResManager.getLocaleString((String)"\u6bcf\u6708\u5f02\u6b65\u6d88\u606f\u6570\u91cf", (String)"AsyncMessageMonthilyCapture_0", (String)"bos-wf-devops");
    }
}

