/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.statisticalanalysis.captures;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.workflow.devopos.info.IndicatorInfo;
import kd.bos.workflow.devops.statisticalanalysis.captures.AbstractSqlCapture;
import kd.bos.workflow.engine.MultiLangEnumBridge;
import kd.bos.workflow.engine.WfUtils;

public class EffectiveCustomerCapture
extends AbstractSqlCapture {
    public static final String NUMBER = "effectiveCustomer";

    @Override
    public List<IndicatorInfo> fetch(String number, String dimValue) {
        ArrayList<IndicatorInfo> list = new ArrayList<IndicatorInfo>(1);
        String sql = null;
        if (WfUtils.isEmpty((String)dimValue)) {
            list.addAll(this.fetch(number, EffectiveCustomerType.WORKFLOWEFFECTIVECUSTOMER.getNumber()));
            list.addAll(this.fetch(number, EffectiveCustomerType.BIZFLOWEFFECTIVECUSTOMER.getNumber()));
            list.addAll(this.fetch(number, EffectiveCustomerType.BECEFFECTIVECUSTOMER.getNumber()));
            return list;
        }
        if (EffectiveCustomerType.WORKFLOWEFFECTIVECUSTOMER.getNumber().equalsIgnoreCase(dimValue)) {
            sql = "select top 1 fid id from t_wf_procdef where ftype = 'AuditFlow' and fkey != 'freeflowtpl'";
        } else if (EffectiveCustomerType.BIZFLOWEFFECTIVECUSTOMER.getNumber().equalsIgnoreCase(dimValue)) {
            sql = "select top 1 fid id from t_wf_procdef where ftype = 'BizFlow'";
        } else if (EffectiveCustomerType.BECEFFECTIVECUSTOMER.getNumber().equalsIgnoreCase(dimValue)) {
            sql = "select top 1 fid id from t_evt_jobrecord";
        }
        IndicatorInfo indicatorInfo = this.build(number, dimValue);
        indicatorInfo.setTotal(Long.valueOf(0L));
        try (DataSet ds = DB.queryDataSet((String)"workflow_EffectiveCustomerCapture", (DBRoute)WfUtils.WFS, (String)sql);){
            Iterator iter = ds.iterator();
            if (iter.hasNext() && ((Row)iter.next()).getLong("id") != null) {
                indicatorInfo.setTotal(Long.valueOf(1L));
            }
        }
        list.add(indicatorInfo);
        return list;
    }

    @Override
    public ILocaleString getDimName(String type) {
        EffectiveCustomerType terminalwayType = EffectiveCustomerType.getTerminalwayType(type);
        if (terminalwayType != null && terminalwayType.getName() != null) {
            return terminalwayType.getName().toLocaleString();
        }
        return new LocaleString();
    }

    @Override
    public String getDim() {
        return "module";
    }

    @Override
    protected ILocaleString getName() {
        return ResManager.getLocaleString((String)"\u6709\u6548\u5ba2\u6237\u6570", (String)"EffectiveCustomerCapture_4", (String)"bos-wf-devops");
    }

    @Override
    protected String getAppNumber() {
        return "wf,bpm,bec";
    }

    @Override
    public boolean isReportData() {
        return true;
    }

    static enum EffectiveCustomerType {
        WORKFLOWEFFECTIVECUSTOMER("wf", new MultiLangEnumBridge("\u5de5\u4f5c\u6d41\u6709\u6548\u5ba2\u6237", "EffectiveCustomerCapture_1", "bos-wf-devops")),
        BIZFLOWEFFECTIVECUSTOMER("bpm", new MultiLangEnumBridge("\u4e1a\u52a1\u6d41\u6709\u6548\u5ba2\u6237", "EffectiveCustomerCapture_2", "bos-wf-devops")),
        BECEFFECTIVECUSTOMER("bec", new MultiLangEnumBridge("\u4e8b\u4ef6\u4e2d\u5fc3\u6709\u6548\u5ba2\u6237", "EffectiveCustomerCapture_3", "bos-wf-devops"));

        String number;
        MultiLangEnumBridge name;

        private EffectiveCustomerType(String number, MultiLangEnumBridge name) {
            this.number = number;
            this.name = name;
        }

        public String getNumber() {
            return this.number;
        }

        public MultiLangEnumBridge getName() {
            return this.name;
        }

        public static EffectiveCustomerType getTerminalwayType(String number) {
            return Stream.of(EffectiveCustomerType.values()).filter(each -> each.getNumber().equals(number)).findFirst().orElse(null);
        }
    }
}

