/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.statisticalanalysis.captures;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.workflow.devopos.info.IndicatorInfo;
import kd.bos.workflow.devops.cache.DevopsServiceCacheHelper;
import kd.bos.workflow.devops.statisticalanalysis.captures.AbstractOperationCapture;
import kd.bos.workflow.engine.WfUtils;

public class OperationRedisCacheCapture
extends AbstractOperationCapture {
    private static int RETAINSIZE = 31;

    @Override
    public void capture(IndicatorInfo indicatorInfo) {
        DevopsServiceCacheHelper.putRedisIndicatorInfo(indicatorInfo.getNumber(), indicatorInfo.getDimValue().toString(), indicatorInfo.getAddCount(), RETAINSIZE);
    }

    @Override
    public List<IndicatorInfo> fetch(String number, String dimValue) {
        Map<String, String> redisIndicatorInfos = DevopsServiceCacheHelper.getRedisIndicatorInfos(number);
        ArrayList<IndicatorInfo> infos = new ArrayList<IndicatorInfo>(16);
        if (WfUtils.isEmptyForMap(redisIndicatorInfos)) {
            return infos;
        }
        if (StringUtils.contains((CharSequence)dimValue, (CharSequence)"-")) {
            String[] arr = dimValue.split("-");
            redisIndicatorInfos.keySet().stream().filter(tmpDimvalue -> tmpDimvalue.compareTo(arr[0]) >= 0 && tmpDimvalue.compareTo(arr[1]) < 0).sorted().forEach(key -> {
                IndicatorInfo info = this.build(number, (String)key);
                info.setTotal(Long.valueOf((String)redisIndicatorInfos.get(key)));
                infos.add(info);
            });
        } else {
            redisIndicatorInfos.keySet().stream().sorted().forEach(key -> {
                IndicatorInfo info = this.build(number, (String)key);
                info.setTotal(Long.valueOf((String)redisIndicatorInfos.get(key)));
                infos.add(info);
            });
        }
        return infos;
    }

    @Override
    public ILocaleString getDimName(String type, boolean isNeedQueryTable) {
        return null;
    }

    @Override
    public String getDim() {
        return null;
    }
}

