/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.statisticalanalysis.captures;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.devopos.info.IndicatorInfo;
import kd.bos.workflow.devops.entity.BehaviorCollectorEntity;
import kd.bos.workflow.devops.entity.BehaviorCollectorEntityManager;
import kd.bos.workflow.devops.statisticalanalysis.captures.AbstractSqlCapture;
import kd.bos.workflow.devops.statisticalanalysis.captures.CaptureCategoryEnum;
import kd.bos.workflow.devops.statisticalanalysis.captures.ProcessInstanceCapture;
import kd.bos.workflow.devops.statisticalanalysis.utils.CaptureUtils;
import kd.bos.workflow.engine.MultiLangEnumBridge;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;

public class ProcessInstanceAllCapture
extends AbstractSqlCapture {
    private Log logger = LogFactory.getLog(ProcessInstanceAllCapture.class);
    public static final String NUMBER = "processInstanceAll";

    @Override
    public void capture(IndicatorInfo indicatorInfo) {
        Object processType;
        if (indicatorInfo.getSpecialProperty() != null && StringUtils.isNotBlank(processType = indicatorInfo.getSpecialProperty().get("processType"))) {
            BehaviorCollectorEntityManager entityManager = (BehaviorCollectorEntityManager)Objects.requireNonNull(Context.getCommandContext()).getEntityManager(BehaviorCollectorEntityManager.class);
            List<BehaviorCollectorEntity> entitys = entityManager.findByNumberAndType(NUMBER, processType.toString());
            if (!entitys.isEmpty()) {
                entitys.get(0).setTotal(entitys.get(0).getTotal() + (long)indicatorInfo.getAddCount());
                entityManager.update(entitys.get(0));
            } else {
                List<IndicatorInfo> list = super.fetch(NUMBER, processType.toString());
                if (list.size() > 0) {
                    IndicatorInfo tmp = list.get(0);
                    this.logger.info("ProcessInstanceAllCapture_capture:" + tmp.getTotal());
                    tmp.setTotal(Long.valueOf(tmp.getTotal() + (long)indicatorInfo.getAddCount()));
                    entityManager.insert(CaptureUtils.buildBehaviorCollectorEntity(tmp, CaptureCategoryEnum.SQLTYPE.getNumber()));
                }
            }
        }
    }

    @Override
    public List<IndicatorInfo> fetch(String number, String dimValue) {
        List<BehaviorCollectorEntity> entitys = ((BehaviorCollectorEntityManager)Objects.requireNonNull(Context.getCommandContext()).getEntityManager(BehaviorCollectorEntityManager.class)).findByNumberAndType(number, null);
        ArrayList<IndicatorInfo> infos = new ArrayList<IndicatorInfo>(entitys.size());
        if (!entitys.isEmpty()) {
            entitys.forEach(entity -> infos.add(this.build((Entity)entity)));
            return infos;
        }
        return super.fetch(number, dimValue);
    }

    @Override
    protected String getQueryCountSql(String type) {
        StringBuilder sql = new StringBuilder("select count(1) count from t_wf_hiprocinst a WHERE a.fendtype<>'20' ");
        Optional.ofNullable(type).ifPresent(x -> sql.append("and a.fprocesstype = '").append(type).append("' "));
        return sql.toString();
    }

    @Override
    public ILocaleString getDimName(String type) {
        return ProcessInstanceCapture.WorkflowTypeEnum.WORKFLOW.getNumber().equals(type) ? ProcessInstanceCapture.WorkflowTypeEnum.WORKFLOW.getName().toLocaleString() : ProcessInstanceCapture.WorkflowTypeEnum.BIZFLOW.getName().toLocaleString();
    }

    @Override
    public String getDim() {
        return "module";
    }

    @Override
    protected ILocaleString getName() {
        return ResManager.getLocaleString((String)"\u6d41\u7a0b\u5b9e\u4f8b\u603b\u6570\u6570\u91cf", (String)"ProcessInstanceAllCapture_0", (String)"bos-wf-devops");
    }

    @Override
    protected String getAppNumber() {
        return "wf,bpm";
    }

    @Override
    public boolean isReportData() {
        return true;
    }

    static enum WorkflowTypeEnum {
        WORKFLOW("AuditFlow", new MultiLangEnumBridge("\u5de5\u4f5c\u6d41", "ProcessInstanceAllCapture_1", "bos-wf-devops")),
        BIZFLOW("BizFlow", new MultiLangEnumBridge("\u4e1a\u52a1\u6d41", "ProcessInstanceAllCapture_2", "bos-wf-devops"));

        String number;
        MultiLangEnumBridge name;

        private WorkflowTypeEnum(String number, MultiLangEnumBridge name) {
            this.number = number;
            this.name = name;
        }

        public String getNumber() {
            return this.number;
        }

        public MultiLangEnumBridge getName() {
            return this.name;
        }
    }
}

