/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.statisticalanalysis.captures;

import java.util.List;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.workflow.devopos.info.IndicatorInfo;
import kd.bos.workflow.devops.statisticalanalysis.captures.AbstractSqlCapture;
import kd.bos.workflow.devops.util.DevopsUtils;
import kd.bos.workflow.engine.MultiLangEnumBridge;

public class ProcessInstanceCapture
extends AbstractSqlCapture {
    public static final String NUMBER = "processInstance";

    @Override
    public List<IndicatorInfo> fetch(String number, String dimValue) {
        if (StringUtils.isBlank((CharSequence)dimValue)) {
            return this.fetch(number, WorkflowTypeEnum.WORKFLOW.getNumber());
        }
        return super.fetch(number, dimValue);
    }

    @Override
    protected Long getResultCountFromEntity(String type) {
        return DevopsUtils.getWorkflowService().getRuntimeService().getProcessInstanceCountByType(type);
    }

    @Override
    public ILocaleString getDimName(String type) {
        return WorkflowTypeEnum.WORKFLOW.getNumber().equals(type) ? WorkflowTypeEnum.WORKFLOW.getName().toLocaleString() : WorkflowTypeEnum.BIZFLOW.getName().toLocaleString();
    }

    @Override
    public String getDim() {
        return "module";
    }

    @Override
    protected ILocaleString getName() {
        return ResManager.getLocaleString((String)"\u6d41\u7a0b\u5b9e\u4f8b\u6570\u91cf", (String)"ProcessInstanceCapture_3", (String)"bos-wf-devops");
    }

    @Override
    public boolean isReportData() {
        return true;
    }

    @Override
    protected String getAppNumber() {
        return "wf,bpm";
    }

    static enum WorkflowTypeEnum {
        WORKFLOW("AuditFlow", new MultiLangEnumBridge("\u5de5\u4f5c\u6d41\u4f7f\u7528\u60c5\u51b5", "ProcessInstanceCapture_1", "bos-wf-devops")),
        BIZFLOW("BizFlow", new MultiLangEnumBridge("\u4e1a\u52a1\u6d41\u4f7f\u7528\u60c5\u51b5", "ProcessInstanceCapture_2", "bos-wf-devops"));

        String number;
        MultiLangEnumBridge name;

        private WorkflowTypeEnum(String number, MultiLangEnumBridge name) {
            this.number = number;
            this.name = name;
        }

        public String getNumber() {
            return this.number;
        }

        public MultiLangEnumBridge getName() {
            return this.name;
        }
    }
}

