/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.statisticalanalysis.captures.bec;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bec.engine.devops.rule.cmd.FindOvertimeDurationsCmd;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.ORM;
import kd.bos.workflow.devopos.info.IndicatorInfo;
import kd.bos.workflow.devops.api.ISpecialDataCapture;
import kd.bos.workflow.devops.entity.DevopsIndicatorEntity;
import kd.bos.workflow.devops.entity.DevopsIndicatorEntityManager;
import kd.bos.workflow.devops.entity.EventInstanceStatisticsEntity;
import kd.bos.workflow.devops.entity.EventInstanceStatisticsEntityManager;
import kd.bos.workflow.devops.statisticalanalysis.captures.bec.BusinessOperationCapture;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.context.Context;

public class BecAsyncMessageBySubscriptionCapture
extends BusinessOperationCapture
implements ISpecialDataCapture {
    public static final String NUMBER = "BecAsyncMessageBySubscription";

    @Override
    public void capture(IndicatorInfo indicatorInfo) {
        Long subscriptionId;
        String endTime = indicatorInfo.getSpecialProperty("endTime") == null ? null : indicatorInfo.getSpecialProperty("endTime").toString();
        Long l = subscriptionId = indicatorInfo.getSpecialProperty("subscriptionId") == null ? null : Long.valueOf(indicatorInfo.getSpecialProperty("subscriptionId").toString());
        if (subscriptionId == null || endTime == null) {
            return;
        }
        EventInstanceStatisticsEntityManager entityManager = (EventInstanceStatisticsEntityManager)Objects.requireNonNull(Context.getCommandContext()).getEntityManager(EventInstanceStatisticsEntityManager.class);
        int completedDuration = this.formatInt(indicatorInfo.getSpecialProperty("completedDuration"));
        ArrayList<Integer> completedDurations = (ArrayList<Integer>)indicatorInfo.getSpecialProperty("completedDurations");
        if (completedDurations == null || completedDurations.size() < 1) {
            completedDurations = new ArrayList<Integer>(1);
            if (completedDuration > 0) {
                completedDurations.add(completedDuration);
            }
        }
        if (this.updateEventInstance(entityManager, indicatorInfo, endTime, completedDurations)) {
            return;
        }
        String insertSql = "insert into t_wf_evtinstancecollect (fid,feventid,fsubscriptionid,fserviceid,ftotal,fcreatedate,fmodifydate,fnumber,fcompletedduration,fcompletedtotal,fsubfullduration,ferroredtotal,fovertimeconfig) select ?,?,?,?,?,?,?,?,?,?,?,?,? WHERE NOT EXISTS (select 1 from t_wf_evtinstancecollect where fsubscriptionid = ? and fnumber = ?)";
        Object[] param = new Object[]{ORM.create().genLongId("wf_evtinstance_statistics"), Long.valueOf(indicatorInfo.getSpecialProperty("eventId").toString()), subscriptionId, Long.valueOf(indicatorInfo.getSpecialProperty("procDefId").toString()), 0, new Date(), new Date(), endTime, this.defultObject(indicatorInfo.getSpecialProperty("completedDuration")), this.defultObject(indicatorInfo.getSpecialProperty("completedTotal")), this.defultObject(indicatorInfo.getSpecialProperty("subFullDuration")), this.defultObject(indicatorInfo.getSpecialProperty("erroredTotal")), this.defultString(this.countOvertimeConfig(null, completedDurations)), subscriptionId, endTime};
        if (entityManager.excuteSql(insertSql, param)) {
            return;
        }
        try {
            if (!this.updateEventInstance(entityManager, indicatorInfo, endTime, completedDurations)) {
                this.logger.error("BecAsyncMessageCaptureUpdate eventInstance \u5931\u8d25\u3002");
            }
        }
        catch (Throwable throwable) {
            this.logger.error(WfUtils.getExceptionStacktrace((Throwable)throwable));
        }
    }

    private String defultString(String inputString) {
        if (inputString == null) {
            return " ";
        }
        return inputString;
    }

    private Object defultObject(Object object) {
        if (object == null) {
            return 0;
        }
        return object;
    }

    private boolean updateEventInstance(EventInstanceStatisticsEntityManager entityManager, IndicatorInfo indicatorInfo, String endTime, List<Integer> completedDurations) {
        List<EventInstanceStatisticsEntity> entitys = entityManager.findByNumberAndsubscriptionid(endTime, Long.valueOf(indicatorInfo.getSpecialProperty("subscriptionId").toString()));
        if (WfUtils.isNotEmptyForCollection(entitys)) {
            int erroredTotal;
            int subFullDuration;
            int completedTotal;
            EventInstanceStatisticsEntity eventInstanceStatisticsEntity = entitys.get(0);
            int completedDuration = this.formatInt(indicatorInfo.getSpecialProperty("completedDuration"));
            if (completedDuration != 0) {
                eventInstanceStatisticsEntity.setCompletedDuration(eventInstanceStatisticsEntity.getCompletedDuration() + (long)completedDuration);
            }
            if ((completedTotal = this.formatInt(indicatorInfo.getSpecialProperty("completedTotal"))) != 0) {
                eventInstanceStatisticsEntity.setCompletedTotal(eventInstanceStatisticsEntity.getCompletedTotal() + completedTotal);
            }
            if ((subFullDuration = this.formatInt(indicatorInfo.getSpecialProperty("subFullDuration"))) != 0) {
                eventInstanceStatisticsEntity.setSubFullDuration(eventInstanceStatisticsEntity.getSubFullDuration() + (long)subFullDuration);
            }
            if ((erroredTotal = this.formatInt(indicatorInfo.getSpecialProperty("erroredTotal"))) != 0) {
                eventInstanceStatisticsEntity.setErroredTotal(eventInstanceStatisticsEntity.getErroredTotal() + erroredTotal);
            }
            if (completedDurations != null && completedDurations.size() > 0) {
                eventInstanceStatisticsEntity.setOvertimeConfig(this.countOvertimeConfig(eventInstanceStatisticsEntity.getOvertimeConfig(), completedDurations));
            }
            Object[] param = new Object[]{eventInstanceStatisticsEntity.getCompletedDuration(), eventInstanceStatisticsEntity.getCompletedTotal(), eventInstanceStatisticsEntity.getSubFullDuration(), eventInstanceStatisticsEntity.getErroredTotal(), this.defultString(eventInstanceStatisticsEntity.getOvertimeConfig()), new Date(), eventInstanceStatisticsEntity.getId()};
            String updateSql = "update t_wf_evtinstancecollect set fcompletedduration = ?,fcompletedtotal = ?,fsubfullduration = ?,ferroredtotal = ?,fovertimeconfig = ?,fmodifydate = ? where fid = ? ";
            entityManager.excuteSql(updateSql, param);
            return true;
        }
        return false;
    }

    private int formatInt(Object obj) {
        if (obj == null) {
            return 0;
        }
        try {
            return Integer.parseInt(obj.toString());
        }
        catch (Exception e) {
            return 0;
        }
    }

    @Override
    public IndicatorInfo countSpecialProperty(IndicatorInfo info, DynamicObject indicatorEntity) {
        Map paramsMap;
        DevopsIndicatorEntity devopsIndicatorEntity = (DevopsIndicatorEntity)((DevopsIndicatorEntityManager)Context.getCommandContext().getEntityManager(DevopsIndicatorEntityManager.class)).create(indicatorEntity);
        if (StringUtils.isNotBlank((CharSequence)devopsIndicatorEntity.getParams()) && info != null && StringUtils.isNotBlank((paramsMap = (Map)SerializationUtils.fromJsonString((String)devopsIndicatorEntity.getParams(), Map.class)).get("subscriptionId")) && StringUtils.isNotBlank(paramsMap.get("endTime"))) {
            info.addToSpecialProperty("endTime", paramsMap.get("endTime"));
            info.addToSpecialProperty("subscriptionId", paramsMap.get("subscriptionId"));
            info.addToSpecialProperty("eventId", paramsMap.get("eventId"));
            info.addToSpecialProperty("procDefId", paramsMap.get("procDefId"));
            if (StringUtils.isNotBlank(paramsMap.get("completedTotal"))) {
                ArrayList<Integer> completedDurations;
                int subFullDuration;
                int completedTotal;
                int completedDuration = this.formatInt(paramsMap.get("completedDuration"));
                if (completedDuration != 0) {
                    info.addToSpecialProperty("completedDuration", (Object)(completedDuration + this.formatInt(info.getSpecialProperty("completedDuration"))));
                }
                if ((completedTotal = this.formatInt(paramsMap.get("completedTotal"))) != 0) {
                    info.addToSpecialProperty("completedTotal", (Object)(completedTotal + this.formatInt(info.getSpecialProperty("completedTotal"))));
                }
                if ((subFullDuration = this.formatInt(paramsMap.get("subFullDuration"))) != 0) {
                    info.addToSpecialProperty("subFullDuration", (Object)(subFullDuration + this.formatInt(info.getSpecialProperty("subFullDuration"))));
                }
                if ((completedDurations = (ArrayList<Integer>)info.getSpecialProperty("completedDurations")) == null) {
                    int completedDurationFirst = this.formatInt(info.getSpecialProperty("completedDuration"));
                    completedDurations = new ArrayList<Integer>(1);
                    if (completedDurationFirst > 0) {
                        completedDurations.add(completedDurationFirst);
                    }
                }
                completedDurations.add(completedDuration);
                info.addToSpecialProperty("completedDurations", (Object)completedDurations);
                return info;
            }
            if (StringUtils.isNotBlank(paramsMap.get("erroredTotal"))) {
                int erroredTotal = this.formatInt(paramsMap.get("erroredTotal"));
                if (erroredTotal != 0) {
                    info.addToSpecialProperty("erroredTotal", (Object)(this.formatInt(info.getSpecialProperty("erroredTotal")) + erroredTotal));
                }
                return info;
            }
        }
        return info;
    }

    private String countOvertimeConfig(String oldConf, List<Integer> completedDurations) {
        if (completedDurations == null || completedDurations.size() < 1) {
            return oldConf;
        }
        List confList = new FindOvertimeDurationsCmd().execute(Context.getCommandContext());
        if (confList == null || confList.size() < 1) {
            return oldConf;
        }
        Map<String, Integer> overTimeConfMap = null;
        if (!WfUtils.isEmpty((String)oldConf) && !oldConf.equals("null") && (overTimeConfMap = (Map)SerializationUtils.fromJsonString((String)oldConf, Map.class)) != null && overTimeConfMap.size() > 1) {
            if (overTimeConfMap.size() != confList.size()) {
                overTimeConfMap = null;
            } else {
                for (Long conf : confList) {
                    if (overTimeConfMap.containsKey(String.valueOf(conf))) continue;
                    overTimeConfMap = null;
                    break;
                }
            }
        }
        if (overTimeConfMap == null) {
            overTimeConfMap = new LinkedHashMap(4);
        }
        for (Long conf : confList) {
            String confStr = String.valueOf(conf);
            int count = 0;
            if (overTimeConfMap.containsKey(confStr)) {
                count = (Integer)overTimeConfMap.get(confStr);
            }
            for (int number : completedDurations) {
                if ((long)number <= conf) continue;
                ++count;
            }
            overTimeConfMap.put(confStr, count);
        }
        return SerializationUtils.toJsonString(overTimeConfMap);
    }
}

