/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.statisticalanalysis.captures.bec;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.bec.engine.persistence.job.EvtDeadLetterJobEntity;
import kd.bos.bec.engine.persistence.job.EvtJobEntity;
import kd.bos.bec.engine.persistence.job.EvtTimerJobEntity;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.workflow.devopos.info.IndicatorInfo;
import kd.bos.workflow.devops.entity.DevopsIndicatorEntity;
import kd.bos.workflow.devops.statisticalanalysis.captures.AsyncMessageDimensionEnum;
import kd.bos.workflow.devops.statisticalanalysis.captures.bec.BusinessOperationCapture;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;

public class BecAsyncMessageCapture
extends BusinessOperationCapture {
    public static final String NUMBER = "becAsyncMessage";

    @Override
    public IndicatorInfo build(Entity entity) {
        EvtJobEntity job;
        if (entity instanceof EvtJobEntity && StringUtils.isBlank((Object)(job = (EvtJobEntity)entity).getServiceId()) && (StringUtils.isBlank((Object)job.getRootJobId()) || job.getId().equals(job.getRootJobId()))) {
            IndicatorInfo indicatorInfo = new IndicatorInfo(NUMBER, (Object)AsyncMessageDimensionEnum.PRODUCT.getNumber());
            indicatorInfo.addToSpecialProperty("createDate", (Object)job.getCreateDate());
            return indicatorInfo;
        }
        if (entity instanceof EvtTimerJobEntity) {
            return new IndicatorInfo(NUMBER, (Object)AsyncMessageDimensionEnum.TIMING.getNumber());
        }
        if (entity instanceof EvtDeadLetterJobEntity) {
            return new IndicatorInfo(NUMBER, (Object)AsyncMessageDimensionEnum.FAIL.getNumber());
        }
        return super.build(entity);
    }

    @Override
    public ILocaleString getDimName(String type, boolean isNeedQueryTable) {
        return AsyncMessageDimensionEnum.getNameByNumber(type);
    }

    @Override
    public String getDim() {
        return "type";
    }

    @Override
    protected String getAppNumber() {
        return "bec";
    }

    @Override
    protected ILocaleString getName() {
        return ResManager.getLocaleString((String)"\u4e1a\u52a1\u4e8b\u4ef6\u4e2d\u5fc3\u5f02\u6b65\u6d88\u606f\u6570\u91cf", (String)"BecAsyncMessageCapture_0", (String)"bos-wf-devops");
    }

    @Override
    protected Long collectHistoricalDataCount(String type) {
        if (StringUtils.isBlank((CharSequence)type)) {
            return 0L;
        }
        if (type.endsWith(AsyncMessageDimensionEnum.PRODUCT.getNumber())) {
            return this.getBusinessDataCountFromJobStatistics(null, null, null);
        }
        if (type.endsWith(AsyncMessageDimensionEnum.SUCCESS.getNumber())) {
            return this.getBusinessDataCountFromJobStatistics(null, null, "completed");
        }
        if (type.endsWith(AsyncMessageDimensionEnum.FAIL.getNumber())) {
            return this.getBusinessDataCountFromJobStatistics(null, null, "errored");
        }
        return 0L;
    }

    @Override
    protected boolean isNeedCollectHistoricalData(String type) {
        return true;
    }

    @Override
    protected IndicatorInfo buildFromOtherIndicatorInfo(IndicatorInfo indicatorInfo) {
        String dimValue = indicatorInfo.getDimValue() != null ? String.valueOf(indicatorInfo.getDimValue()) : "";
        IndicatorInfo info = this.build(NUMBER, dimValue);
        info.setAddCount(indicatorInfo.getAddCount());
        return info;
    }

    @Override
    public List<IndicatorInfo> getGroupAndSelfIndicatorInfos(DevopsIndicatorEntity devopsIndicatorEntity) {
        Map paramsMap;
        ArrayList<IndicatorInfo> infos = new ArrayList<IndicatorInfo>();
        if (StringUtils.isNotBlank((CharSequence)devopsIndicatorEntity.getParams()) && StringUtils.isNotBlank((paramsMap = (Map)SerializationUtils.fromJsonString((String)devopsIndicatorEntity.getParams(), Map.class)).get("subscriptionId")) && StringUtils.isNotBlank(paramsMap.get("endTime"))) {
            IndicatorInfo parentIndicatorInfo = this.build(devopsIndicatorEntity);
            if (parentIndicatorInfo == null) {
                return infos;
            }
            infos.add(parentIndicatorInfo);
            IndicatorInfo subsIndicatorInfo = new IndicatorInfo("BecAsyncMessageBySubscription", (Object)(paramsMap.get("subscriptionId").toString() + "##" + paramsMap.get("endTime").toString()));
            subsIndicatorInfo.setSpecialProperty(paramsMap);
            infos.add(subsIndicatorInfo);
            return infos;
        }
        return new ArrayList<IndicatorInfo>();
    }
}

