/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.statisticalanalysis.captures.bec;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.devopos.info.IndicatorInfo;
import kd.bos.workflow.devops.statisticalanalysis.captures.AsyncMessageDimensionEnum;
import kd.bos.workflow.devops.statisticalanalysis.captures.bec.BusinessOperationCapture;
import org.apache.commons.lang.time.DateFormatUtils;

public class BecAsyncMessageDailyCapture
extends BusinessOperationCapture {
    public static final String NUMBER = "becAsyncMessageDaily";
    private Log logger = LogFactory.getLog(BecAsyncMessageDailyCapture.class);

    @Override
    public ILocaleString getDimName(String type, boolean isNeedQueryTable) {
        return null;
    }

    @Override
    public String getDim() {
        return "date";
    }

    @Override
    protected String getAppNumber() {
        return "bec";
    }

    @Override
    protected ILocaleString getName() {
        return ResManager.getLocaleString((String)"\u4e1a\u52a1\u4e8b\u4ef6\u4e2d\u5fc3\u6bcf\u65e5\u5f02\u6b65\u6d88\u606f\u6570\u91cf", (String)"BecAsyncMessageDailyCapture_0", (String)"bos-wf-devops");
    }

    @Override
    protected IndicatorInfo buildFromOtherIndicatorInfo(IndicatorInfo indicatorInfo) {
        Object createDate = indicatorInfo.getSpecialProperty("createDate");
        if (createDate == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = new Date();
        try {
            date = sdf.parse((String)createDate);
        }
        catch (ParseException e) {
            this.logger.info("BecAsyncMessageDailyCapture_capture format date error" + createDate);
        }
        String type = DateFormatUtils.format((Date)date, (String)"yyyyMMdd");
        IndicatorInfo info = this.build(NUMBER, type);
        info.setAddCount(indicatorInfo.getAddCount());
        info.setDimValue((Object)(indicatorInfo.getDimValue().toString().replace(AsyncMessageDimensionEnum.PRODUCT.getNumber(), "") + type));
        return info;
    }
}

