/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.statisticalanalysis.captures.bec;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.workflow.devopos.info.IndicatorInfo;
import kd.bos.workflow.devops.entity.BehaviorCollectorEntity;
import kd.bos.workflow.devops.entity.BehaviorCollectorEntityManager;
import kd.bos.workflow.devops.statisticalanalysis.captures.bec.BusinessOperationCapture;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;
import org.apache.commons.lang.time.DateFormatUtils;

public class BecInstanceDailyCapture
extends BusinessOperationCapture {
    public static final String NUMBER = "becInstanceDaily";

    @Override
    public List<IndicatorInfo> fetch(String number, String dimValue) {
        if (StringUtils.contains((CharSequence)dimValue, (CharSequence)"-")) {
            String[] arr = dimValue.split("-");
            List<BehaviorCollectorEntity> entitys = ((BehaviorCollectorEntityManager)Objects.requireNonNull(Context.getCommandContext()).getEntityManager(BehaviorCollectorEntityManager.class)).findBehaviorCollectorBetweenDimvalue(number, arr[0], arr[1]);
            ArrayList<IndicatorInfo> infos = new ArrayList<IndicatorInfo>(entitys.size());
            entitys.forEach(entity -> infos.add(this.build((Entity)entity)));
            return infos;
        }
        return super.fetch(number, dimValue);
    }

    @Override
    public String getDim() {
        return "date";
    }

    @Override
    protected String getAppNumber() {
        return "bec";
    }

    @Override
    protected ILocaleString getName() {
        return ResManager.getLocaleString((String)"\u6bcf\u65e5\u4e8b\u4ef6\u5b9e\u4f8b\u4ea7\u751f\u6570\u91cf\u7edf\u8ba1", (String)"BecInstanceDailyCapture_0", (String)"bos-wf-devops");
    }

    @Override
    protected IndicatorInfo buildFromOtherIndicatorInfo(IndicatorInfo indicatorInfo) {
        Object createDate = indicatorInfo.getSpecialProperty("createDate");
        if (createDate == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = new Date();
        try {
            date = sdf.parse((String)createDate);
        }
        catch (ParseException e) {
            this.logger.info("BecInstanceDailyCapture_capture format date error" + createDate);
        }
        String type = DateFormatUtils.format((Date)date, (String)"yyyyMMdd");
        IndicatorInfo info = this.build(NUMBER, type);
        info.setAddCount(indicatorInfo.getAddCount());
        return info;
    }
}

