/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.statisticalanalysis.captures.bec;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.devopos.info.IndicatorInfo;
import kd.bos.workflow.devops.entity.EventInstanceStatisticsEntity;
import kd.bos.workflow.devops.entity.EventInstanceStatisticsEntityManager;
import kd.bos.workflow.devops.statisticalanalysis.captures.bec.BusinessOperationCapture;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.context.Context;
import org.apache.commons.lang.time.DateFormatUtils;

public class BecInstanceInfoDailyCapture
extends BusinessOperationCapture {
    public static final String NUMBER = "becInstanceInfoDaily";

    @Override
    public List<IndicatorInfo> fetch(String number, String dimValue) {
        ArrayList<IndicatorInfo> infos = new ArrayList<IndicatorInfo>();
        if (StringUtils.isNotBlank((CharSequence)dimValue)) {
            Date now = WfUtils.now();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(now);
            calendar.add(2, -1);
            String beginDate = new SimpleDateFormat("yyyyMMdd").format(calendar.getTime());
            EventInstanceStatisticsEntityManager entityManager = (EventInstanceStatisticsEntityManager)Objects.requireNonNull(Context.getCommandContext()).getEntityManager(EventInstanceStatisticsEntityManager.class);
            List<EventInstanceStatisticsEntity> entitys = entityManager.findAfterProduct(beginDate);
            HashMap<Long, Integer> tmpMap = new HashMap<Long, Integer>(entitys.size());
            for (EventInstanceStatisticsEntity entity : entitys) {
                if ("event".equals(dimValue)) {
                    tmpMap.put(entity.getEventId(), tmpMap.get(entity.getEventId()) != null ? (Integer)tmpMap.get(entity.getEventId()) + entity.getTotal() : entity.getTotal());
                    continue;
                }
                if ("subscribtion".equals(dimValue)) {
                    tmpMap.put(entity.getSubscriptionId(), tmpMap.get(entity.getSubscriptionId()) != null ? (Integer)tmpMap.get(entity.getSubscriptionId()) + entity.getTotal() : entity.getTotal());
                    continue;
                }
                tmpMap.put(entity.getServiceId(), tmpMap.get(entity.getServiceId()) != null ? (Integer)tmpMap.get(entity.getServiceId()) + entity.getTotal() : entity.getTotal());
            }
            String entityNumber = "event".equals(dimValue) ? "evt_event" : ("subscribtion".equals(dimValue) ? "evt_subscription" : "evt_service");
            Map<Long, ILocaleString> namesMap = this.getDisplayName(entityNumber, tmpMap.keySet());
            tmpMap.forEach((key, total) -> {
                IndicatorInfo indicatorInfo = new IndicatorInfo(NUMBER, key);
                indicatorInfo.setTotal(Long.valueOf(total.intValue()));
                indicatorInfo.setDimDisplayValue((ILocaleString)namesMap.get(key));
                infos.add(indicatorInfo);
            });
        }
        return infos;
    }

    @Override
    public void capture(IndicatorInfo indicatorInfo) {
        String dimValue = (String)Optional.ofNullable(indicatorInfo.getDimValue()).orElseGet(() -> "");
        String[] idArr = dimValue.split(",");
        if (idArr.length != 4) {
            return;
        }
        String number = idArr[0];
        Long subscriptionId = Long.valueOf(idArr[3]);
        EventInstanceStatisticsEntityManager entityManager = (EventInstanceStatisticsEntityManager)Objects.requireNonNull(Context.getCommandContext()).getEntityManager(EventInstanceStatisticsEntityManager.class);
        if (this.updateEventInstance(entityManager, indicatorInfo, number, subscriptionId)) {
            return;
        }
        String insertSql = "insert into t_wf_evtinstancecollect (fid,feventid,fsubscriptionid,fserviceid,ftotal,fcreatedate,fmodifydate,fnumber,fcompletedduration,fcompletedtotal,fsubfullduration,ferroredtotal,fovertimeconfig) select ?,?,?,?,?,?,?,?,?,?,?,?,? WHERE NOT EXISTS (select 1 from t_wf_evtinstancecollect where fsubscriptionid = ? and fnumber = ?)";
        Object[] param = new Object[]{ORM.create().genLongId("wf_evtinstance_statistics"), Long.valueOf(idArr[2]), subscriptionId, Long.valueOf(idArr[1]), indicatorInfo.getAddCount(), new Date(), new Date(), number, 0, 0, 0, 0, " ", subscriptionId, number};
        if (entityManager.excuteSql(insertSql, param)) {
            return;
        }
        try {
            if (!this.updateEventInstance(entityManager, indicatorInfo, number, subscriptionId)) {
                this.logger.error("BecInstanceInfoDailyCaptureUpdate eventInstance \u5931\u8d25\u3002");
            }
        }
        catch (Throwable throwable) {
            this.logger.error(WfUtils.getExceptionStacktrace((Throwable)throwable));
        }
    }

    private boolean updateEventInstance(EventInstanceStatisticsEntityManager entityManager, IndicatorInfo indicatorInfo, String number, Long subscriptionId) {
        List<EventInstanceStatisticsEntity> entitys = entityManager.findByNumberAndsubscriptionid(number, subscriptionId);
        if (WfUtils.isNotEmptyForCollection(entitys)) {
            EventInstanceStatisticsEntity eventInstanceStatisticsEntity = entitys.get(0);
            eventInstanceStatisticsEntity.setTotal(eventInstanceStatisticsEntity.getTotal() + indicatorInfo.getAddCount());
            Object[] param = new Object[]{eventInstanceStatisticsEntity.getTotal(), new Date(), eventInstanceStatisticsEntity.getId()};
            String updateSql = "update t_wf_evtinstancecollect set ftotal = ?,fmodifydate = ? where fid = ? ";
            entityManager.excuteSql(updateSql, param);
            return true;
        }
        return false;
    }

    private Map<Long, ILocaleString> getDisplayName(String entityNumber, Set<Long> ids) {
        DynamicObject[] objs;
        HashMap<Long, ILocaleString> nameMap = new HashMap<Long, ILocaleString>();
        QFilter filter = new QFilter("id", "in", ids);
        for (DynamicObject obj : objs = BusinessDataServiceHelper.load((String)entityNumber, (String)"id, name", (QFilter[])new QFilter[]{filter})) {
            if (!WfUtils.isEmpty((ILocaleString)((ILocaleString)nameMap.get(obj.getLong("id"))))) continue;
            nameMap.put(obj.getLong("id"), obj.getLocaleString("name"));
        }
        return nameMap;
    }

    @Override
    public String getDim() {
        return "subscriptionNumbers";
    }

    @Override
    protected ILocaleString getName() {
        return ResManager.getLocaleString((String)"\u8ba2\u9605\u4ea7\u751f\u5b9e\u4f8b\u6570\u91cf", (String)"BusinessEventJobBySubscribedCapture_0", (String)"bos-wf-devops");
    }

    @Override
    protected String getAppNumber() {
        return "bec";
    }

    @Override
    protected IndicatorInfo buildFromOtherIndicatorInfo(IndicatorInfo indicatorInfo) {
        Object createDate = indicatorInfo.getSpecialProperty("createDate");
        if (createDate == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = new Date();
        try {
            date = sdf.parse((String)createDate);
        }
        catch (ParseException e) {
            this.logger.info("BusinessEventJobBySubscribedDailyCapture_capture format date error" + createDate);
        }
        String dateType = DateFormatUtils.format((Date)date, (String)"yyyyMMdd");
        String type = dateType + "," + Optional.ofNullable(indicatorInfo.getDimValue()).orElseGet(() -> "");
        indicatorInfo.setDimValue((Object)type);
        return indicatorInfo;
    }
}

