/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.statisticalanalysis.captures.bec;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.AppMetadataCache;
import kd.bos.workflow.devopos.info.IndicatorInfo;
import kd.bos.workflow.devops.statisticalanalysis.captures.AbstractSqlCapture;
import kd.bos.workflow.engine.WfUtils;

public class BusinessEventByAppCapture
extends AbstractSqlCapture {
    public static final String NUMBER = "businessEventByApp";

    @Override
    public List<IndicatorInfo> fetch(String number, String dimValue) {
        ArrayList<IndicatorInfo> list = new ArrayList<IndicatorInfo>(1);
        StringBuilder sql = new StringBuilder();
        sql.append("select fsource fsource, count(1) count from t_evt_event where fnumber != ' ' ");
        if (StringUtils.isNotBlank((CharSequence)dimValue)) {
            sql.append("and fsource = ").append(dimValue).append(" ");
        }
        sql.append("group by fsource");
        IndicatorInfo indicatorInfo = this.build(number, dimValue);
        try (DataSet ds = DB.queryDataSet((String)"workflow_EffectiveCustomerCapture", (DBRoute)WfUtils.WFS, (String)sql.toString());){
            Iterator iter = ds.iterator();
            if (!iter.hasNext()) {
                ArrayList<IndicatorInfo> arrayList = list;
                return arrayList;
            }
            Map allAppInfos = AppMetadataCache.getAllAppInfo();
            HashMap infos = new HashMap(allAppInfos.size());
            allAppInfos.forEach((num, info) -> infos.put(info.getId(), info.getName()));
            while (iter.hasNext()) {
                Row row = (Row)iter.next();
                IndicatorInfo cloneInfo = indicatorInfo.clone();
                if (WfUtils.isEmpty((String)row.getString("fsource"))) continue;
                cloneInfo.setTotal(row.getLong("count"));
                cloneInfo.setDimValue((Object)row.getString("fsource"));
                try {
                    LocaleString name = WfUtils.isNotEmpty((ILocaleString)((ILocaleString)infos.get(row.getString("fsource")))) ? (LocaleString)infos.get(row.getString("fsource")) : new LocaleString(row.getString("fsource"));
                    cloneInfo.setDimDisplayValue((ILocaleString)name);
                }
                catch (Exception e) {
                    continue;
                }
                list.add(cloneInfo);
            }
        }
        return list;
    }

    @Override
    public ILocaleString getDimName(String type) {
        return null;
    }

    @Override
    public String getDim() {
        return "app";
    }

    @Override
    protected ILocaleString getName() {
        return ResManager.getLocaleString((String)"\u5e94\u7528\u4e0b\u4e8b\u4ef6\u6570\u91cf", (String)"BusinessEventByAppCapture_0", (String)"bos-wf-devops");
    }

    @Override
    protected String getAppNumber() {
        return "bec";
    }
}

