/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.statisticalanalysis.captures.bec;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.workflow.devopos.info.IndicatorInfo;
import kd.bos.workflow.devops.statisticalanalysis.captures.AbstractSqlCapture;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;

public class BusinessEventDefineBySubscribedCapture
extends AbstractSqlCapture {
    public static final String NUMBER = "businessEventDefineBySubscribed";

    @Override
    public List<IndicatorInfo> fetch(String number, String dimValue) {
        StringBuilder sql = new StringBuilder();
        String nameSQL = WfMultiLangUtils.getGeneralLangSQL((String)"evt_event", (String)"a", (String)"b", (String)"fname", (String)"name", (String)"name");
        sql.append("select a.fnumber number, c.count count, ");
        sql.append(nameSQL).append(" ");
        sql.append("from t_evt_event a ");
        sql.append("left join t_evt_event_l b on a.fid = b.fid ");
        sql.append("left join (select fevent fevent, count(1) count from t_evt_subscription where fstatus = '1' group by fevent) c on a.fid = c.fevent ");
        sql.append("where a.fstatus = '1' and b.flocaleid = '");
        sql.append(RequestContext.get().getLang().toString()).append("' ");
        if (StringUtils.isNotBlank((CharSequence)dimValue)) {
            sql.append("and a.fnumber = ").append(dimValue);
        }
        ArrayList<IndicatorInfo> list = new ArrayList<IndicatorInfo>();
        IndicatorInfo indicatorInfo = this.build(number, dimValue);
        try (DataSet ds = DB.queryDataSet((String)"workflow_EffectiveCustomerCapture", (DBRoute)WfUtils.WFS, (String)sql.toString());){
            for (Row row : ds) {
                if (!StringUtils.isNotBlank((CharSequence)row.getString("number")) || !StringUtils.isNotBlank((Object)row.getLong("count"))) continue;
                IndicatorInfo cloneInfo = indicatorInfo.clone();
                cloneInfo.setTotal(row.getLong("count"));
                cloneInfo.setDimValue((Object)row.getString("number"));
                cloneInfo.setDimDisplayValue((ILocaleString)new LocaleString(row.getString("name")));
                list.add(cloneInfo);
            }
        }
        return list;
    }

    @Override
    public ILocaleString getDimName(String type) {
        return null;
    }

    @Override
    public String getDim() {
        return "numberview";
    }

    @Override
    protected ILocaleString getName() {
        return ResManager.getLocaleString((String)"\u4e8b\u4ef6\u88ab\u8ba2\u9605\u6570\u91cf", (String)"BusinessEventDefineBySubscribedCapture_0", (String)"bos-wf-devops");
    }

    @Override
    protected String getAppNumber() {
        return "bec";
    }
}

