/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.statisticalanalysis.captures.bec;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.devopos.info.IndicatorInfo;
import kd.bos.workflow.devops.api.IDataCapture;
import kd.bos.workflow.devops.entity.DevopsIndicatorEntity;
import kd.bos.workflow.devops.statisticalanalysis.DataCaptureFactory;
import kd.bos.workflow.devops.statisticalanalysis.captures.AsyncMessageDimensionEnum;
import kd.bos.workflow.devops.statisticalanalysis.captures.bec.BusinessOperationCapture;
import kd.bos.workflow.engine.WfUtils;

public class BusinessEventJobByEventCapture
extends BusinessOperationCapture {
    public static final String NUMBER = "businessEventJobByEvent";
    private static final String EVENT = "event";

    @Override
    public ILocaleString getDimName(String type, boolean isNeedQueryTable) {
        if (isNeedQueryTable) {
            DynamicObject event = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(type), (String)"evt_event", (String)"name, number");
            return event.getLocaleString("name");
        }
        return null;
    }

    @Override
    public String getDim() {
        return "eventType";
    }

    @Override
    protected Long collectHistoricalDataCount(String dimValue) {
        return this.getBusinessDataCountFromJobStatistics(EVENT, dimValue, null);
    }

    @Override
    protected boolean isNeedCollectHistoricalData(String type) {
        return true;
    }

    @Override
    protected ILocaleString getName() {
        return ResManager.getLocaleString((String)"\u4e8b\u4ef6\u4ea7\u751f\u5b9e\u4f8b\u6570\u91cf", (String)"BusinessEventJobByEventCapture_0", (String)"bos-wf-devops");
    }

    @Override
    protected String getAppNumber() {
        return "bec";
    }

    @Override
    public List<IndicatorInfo> getGroupAndSelfIndicatorInfos(DevopsIndicatorEntity devopsIndicatorEntity) {
        ArrayList<IndicatorInfo> infos = new ArrayList<IndicatorInfo>(9);
        IndicatorInfo parentIndicatorInfo = this.build(devopsIndicatorEntity);
        if (parentIndicatorInfo == null) {
            return infos;
        }
        Object evtSubServiceIds = parentIndicatorInfo.getSpecialProperty("evtSubServiceIds");
        if (StringUtils.isBlank((Object)evtSubServiceIds)) {
            return infos;
        }
        Object[] evtSubServiceId = ((String)evtSubServiceIds).split(";");
        if (WfUtils.isEmptyForArrays((Object[])evtSubServiceId)) {
            return infos;
        }
        int len = evtSubServiceId.length;
        for (int i = 0; i < len; ++i) {
            Object allId = evtSubServiceId[i];
            String[] ids = ((String)allId).split(",");
            Long serviceId = Long.valueOf(ids[0]);
            Long eventId = Long.valueOf(ids[1]);
            Long subscribeId = Long.valueOf(ids[2]);
            IndicatorInfo businessEventJobByEventInfo = parentIndicatorInfo.clone();
            businessEventJobByEventInfo.setDimValue((Object)eventId);
            infos.add(businessEventJobByEventInfo);
            infos.add(new IndicatorInfo("businessEventJobByService", (Object)serviceId.toString(), parentIndicatorInfo.getAddCount()));
            infos.add(new IndicatorInfo("businessEventJobBySubscribed", (Object)subscribeId.toString(), parentIndicatorInfo.getAddCount()));
            IndicatorInfo becInstanceInfoDailyTmp = new IndicatorInfo("becInstanceInfoDaily", allId);
            becInstanceInfoDailyTmp.setSpecialProperty(parentIndicatorInfo.getSpecialProperty());
            IDataCapture becInstanceInfoDailyCapture = DataCaptureFactory.getDataCaptureInterface("becInstanceInfoDaily");
            IndicatorInfo becInstanceInfoDailyInfo = ((BusinessOperationCapture)becInstanceInfoDailyCapture).buildFromOtherIndicatorInfo(becInstanceInfoDailyTmp);
            infos.add(becInstanceInfoDailyInfo);
        }
        IDataCapture asyncMessage = DataCaptureFactory.getDataCaptureInterface("becAsyncMessage");
        IndicatorInfo becAsyncMessageInfo = ((BusinessOperationCapture)asyncMessage).buildFromOtherIndicatorInfo(new IndicatorInfo("becAsyncMessage", (Object)AsyncMessageDimensionEnum.PRODUCT.getNumber(), evtSubServiceId.length));
        infos.add(becAsyncMessageInfo);
        becAsyncMessageInfo.setSpecialProperty(parentIndicatorInfo.getSpecialProperty());
        IDataCapture asyncMessageDaily = DataCaptureFactory.getDataCaptureInterface("becAsyncMessageDaily");
        IndicatorInfo asyncMessageDailyInfo = ((BusinessOperationCapture)asyncMessageDaily).buildFromOtherIndicatorInfo(becAsyncMessageInfo);
        infos.add(asyncMessageDailyInfo);
        IDataCapture asyncMessageMonthily = DataCaptureFactory.getDataCaptureInterface("becAsyncMessageMonthily");
        IndicatorInfo asyncMessageMonthilyInfo = ((BusinessOperationCapture)asyncMessageMonthily).buildFromOtherIndicatorInfo(becAsyncMessageInfo);
        infos.add(asyncMessageMonthilyInfo);
        IndicatorInfo becInstanceDailyTmp = new IndicatorInfo("becInstanceDaily", null, evtSubServiceId.length);
        becInstanceDailyTmp.setSpecialProperty(parentIndicatorInfo.getSpecialProperty());
        IDataCapture becInstanceDailyCapture = DataCaptureFactory.getDataCaptureInterface("becInstanceDaily");
        IndicatorInfo becInstanceDailyInfo = ((BusinessOperationCapture)becInstanceDailyCapture).buildFromOtherIndicatorInfo(becInstanceDailyTmp);
        infos.add(becInstanceDailyInfo);
        infos.add(new IndicatorInfo("businessEventJobRecord", null, evtSubServiceId.length));
        return infos;
    }
}

