/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.statisticalanalysis.captures.bec;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.workflow.devopos.info.IndicatorInfo;
import kd.bos.workflow.devops.entity.BehaviorCollectorEntity;
import kd.bos.workflow.devops.entity.BehaviorCollectorEntityManager;
import kd.bos.workflow.devops.statisticalanalysis.captures.CaptureCategoryEnum;
import kd.bos.workflow.devops.statisticalanalysis.captures.bec.BusinessOperationCapture;
import kd.bos.workflow.devops.statisticalanalysis.utils.CaptureUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;

public class BusinessEventJobRecordCapture
extends BusinessOperationCapture {
    public static final String NUMBER = "businessEventJobRecord";
    private static final String QUERYCOUNTSQL = "select count(1) count from t_evt_jobstatistics tej";

    @Override
    public void capture(IndicatorInfo indicatorInfo) {
        BehaviorCollectorEntityManager entityManager = (BehaviorCollectorEntityManager)Objects.requireNonNull(Context.getCommandContext()).getEntityManager(BehaviorCollectorEntityManager.class);
        List<BehaviorCollectorEntity> entitys = entityManager.findByNumberAndType(NUMBER, null);
        if (!entitys.isEmpty()) {
            entitys.get(0).setTotal(entitys.get(0).getTotal() + (long)indicatorInfo.getAddCount());
            entityManager.update(entitys.get(0));
        } else {
            IndicatorInfo tmp = this.build(NUMBER, null);
            tmp.setTotal(Long.valueOf(this.getBusinessDataCountFromJobStatistics(null, null, null) + (long)indicatorInfo.getAddCount()));
            entityManager.insert(CaptureUtils.buildBehaviorCollectorEntity(tmp, CaptureCategoryEnum.SQLTYPE.getNumber()));
        }
    }

    @Override
    public List<IndicatorInfo> fetch(String number, String dimValue) {
        List<BehaviorCollectorEntity> entitys = ((BehaviorCollectorEntityManager)Objects.requireNonNull(Context.getCommandContext()).getEntityManager(BehaviorCollectorEntityManager.class)).findByNumberAndType(number, null);
        ArrayList<IndicatorInfo> infos = new ArrayList<IndicatorInfo>(entitys.size());
        if (!entitys.isEmpty()) {
            entitys.forEach(entity -> infos.add(this.build((Entity)entity)));
            return infos;
        }
        ArrayList<IndicatorInfo> list = new ArrayList<IndicatorInfo>(1);
        IndicatorInfo indicatorInfo = this.build(number, dimValue);
        try (DataSet ds = DB.queryDataSet((String)"workflow_EffectiveCustomerCapture", (DBRoute)WfUtils.WFS, (String)QUERYCOUNTSQL);){
            Iterator iter = ds.iterator();
            if (iter.hasNext()) {
                indicatorInfo.setTotal(((Row)iter.next()).getLong("count"));
            }
        }
        list.add(indicatorInfo);
        return list;
    }

    @Override
    protected ILocaleString getName() {
        return ResManager.getLocaleString((String)"\u4e1a\u52a1\u4e8b\u4ef6\u89e6\u53d1\u6570\u91cf", (String)"BusinessEventJobRecordCapture_0", (String)"bos-wf-devops");
    }

    @Override
    protected String getAppNumber() {
        return "bec";
    }

    @Override
    public boolean isReportData() {
        return true;
    }
}

