/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.statisticalanalysis.captures.bec;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.workflow.devopos.info.IndicatorInfo;
import kd.bos.workflow.devops.api.IDataCapture;
import kd.bos.workflow.devops.entity.DevopsIndicatorEntity;
import kd.bos.workflow.devops.statisticalanalysis.DataCaptureFactory;
import kd.bos.workflow.devops.statisticalanalysis.captures.AsyncMessageDimensionEnum;
import kd.bos.workflow.devops.statisticalanalysis.captures.bec.BusinessOperationCapture;
import kd.bos.workflow.engine.WfUtils;

public class BusinessEventSceneCapture
extends BusinessOperationCapture {
    public static final String NUMBER = "businessEventEntityNumber";
    private static final String OTHER = "other";

    @Override
    public ILocaleString getDimName(String type, boolean isNeedQueryTable) {
        if (StringUtils.isBlank((CharSequence)type) || OTHER.equals(type)) {
            return ResManager.getLocaleString((String)"\u5176\u5b83", (String)"BusinessEventSceneCapture_0", (String)"bos-wf-devops");
        }
        if (isNeedQueryTable) {
            return WfUtils.getEntityNameByNumber((String)type);
        }
        return null;
    }

    @Override
    public String getDim() {
        return "entityNumber";
    }

    @Override
    protected ILocaleString getName() {
        return ResManager.getLocaleString((String)"\u4e1a\u52a1\u4e8b\u4ef6\u89e6\u53d1\u5b9e\u4f53\u6570\u91cf", (String)"BusinessEventSceneCapture_1", (String)"bos-wf-devops");
    }

    @Override
    protected String getAppNumber() {
        return "bec";
    }

    @Override
    public List<IndicatorInfo> getGroupAndSelfIndicatorInfos(DevopsIndicatorEntity devopsIndicatorEntity) {
        ArrayList<IndicatorInfo> infos = new ArrayList<IndicatorInfo>();
        IndicatorInfo businessEventSceneInfo = this.build(devopsIndicatorEntity);
        String type = StringUtils.isNotBlank((Object)businessEventSceneInfo.getDimValue()) ? businessEventSceneInfo.getDimValue().toString() : OTHER;
        businessEventSceneInfo.setDimValue((Object)type);
        businessEventSceneInfo.setDimDisplayValue(null);
        infos.add(businessEventSceneInfo);
        IndicatorInfo clone = businessEventSceneInfo.clone();
        clone.setDimValue((Object)AsyncMessageDimensionEnum.PRODUCT.getNumber());
        IDataCapture asyncMessage = DataCaptureFactory.getDataCaptureInterface("becAsyncMessage");
        IndicatorInfo becAsyncMessageInfo = ((BusinessOperationCapture)asyncMessage).buildFromOtherIndicatorInfo(clone);
        infos.add(becAsyncMessageInfo);
        becAsyncMessageInfo.setSpecialProperty(businessEventSceneInfo.getSpecialProperty());
        IDataCapture asyncMessageDaily = DataCaptureFactory.getDataCaptureInterface("becAsyncMessageDaily");
        IndicatorInfo asyncMessageDailyInfo = ((BusinessOperationCapture)asyncMessageDaily).buildFromOtherIndicatorInfo(becAsyncMessageInfo);
        infos.add(asyncMessageDailyInfo);
        IDataCapture asyncMessageMonthily = DataCaptureFactory.getDataCaptureInterface("becAsyncMessageMonthily");
        IndicatorInfo asyncMessageMonthilyInfo = ((BusinessOperationCapture)asyncMessageMonthily).buildFromOtherIndicatorInfo(becAsyncMessageInfo);
        infos.add(asyncMessageMonthilyInfo);
        return infos;
    }
}

