/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.statisticalanalysis.captures.bec;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.workflow.devopos.info.IndicatorInfo;
import kd.bos.workflow.devops.statisticalanalysis.captures.AbstractSqlCapture;
import kd.bos.workflow.engine.WfUtils;

public class BusinessServiceBySubscribedCapture
extends AbstractSqlCapture {
    public static final String NUMBER = "businessServiceBySubscribed";

    @Override
    public List<IndicatorInfo> fetch(String number, String dimValue) {
        ArrayList<IndicatorInfo> list = new ArrayList<IndicatorInfo>(1);
        StringBuilder sql = new StringBuilder();
        sql.append("select a.fnumber number,b.fname name, c.count count from t_evt_service a ");
        sql.append("left join t_evt_service_l b on a.fid = b.fid ");
        sql.append("left join (select fservice service, count(1) count from t_evt_subscription group by fservice) c on a.fid = c.service ");
        sql.append("where b.flocaleid = ");
        sql.append(RequestContext.get().getLang().toString()).append(" ");
        if (StringUtils.isNotBlank((CharSequence)dimValue)) {
            sql.append("and a.fnumber = ").append(dimValue).append(" ");
        }
        IndicatorInfo indicatorInfo = this.build(number, dimValue);
        try (DataSet ds = DB.queryDataSet((String)"workflow_EffectiveCustomerCapture", (DBRoute)WfUtils.WFS, (String)sql.toString());){
            Iterator iter = ds.iterator();
            if (iter.hasNext() && StringUtils.isNotBlank((CharSequence)((Row)iter.next()).getString("number"))) {
                IndicatorInfo cloneInfo = indicatorInfo.clone();
                indicatorInfo.setTotal(((Row)iter.next()).getLong("count"));
                indicatorInfo.setDimValue((Object)((Row)iter.next()).getString("number"));
                indicatorInfo.setDimDisplayValue((ILocaleString)new LocaleString(((Row)iter.next()).getString("name")));
                list.add(cloneInfo);
            }
        }
        return list;
    }

    @Override
    public ILocaleString getDimName(String type) {
        return null;
    }

    @Override
    public String getDim() {
        return "serviceNumber";
    }

    @Override
    protected ILocaleString getName() {
        return ResManager.getLocaleString((String)"\u670d\u52a1\u88ab\u8ba2\u9605\u6570\u91cf", (String)"BusinessServiceBySubscribedCapture_0", (String)"bos-wf-devops");
    }

    @Override
    protected String getAppNumber() {
        return "bec";
    }
}

