/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.statisticalanalysis.captures.bpm;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.workflow.devopos.info.IndicatorInfo;
import kd.bos.workflow.devops.entity.BehaviorCollectorEntity;
import kd.bos.workflow.devops.entity.BehaviorCollectorEntityManager;
import kd.bos.workflow.devops.statisticalanalysis.captures.AbstractOperationCapture;
import kd.bos.workflow.devops.statisticalanalysis.captures.CaptureCategoryEnum;
import kd.bos.workflow.devops.statisticalanalysis.utils.CaptureUtils;
import kd.bos.workflow.engine.MultiLangEnumBridge;
import kd.bos.workflow.engine.impl.context.Context;

public class BillRelationCapture
extends AbstractOperationCapture {
    public static final String NUMBER = "billRelationGraph";

    @Override
    public void capture(IndicatorInfo indicatorInfo) {
        String type = StringUtils.isNotBlank((Object)indicatorInfo.getDimValue()) ? indicatorInfo.getDimValue().toString() : null;
        BehaviorCollectorEntityManager entityManager = (BehaviorCollectorEntityManager)Objects.requireNonNull(Context.getCommandContext()).getEntityManager(BehaviorCollectorEntityManager.class);
        List<BehaviorCollectorEntity> entitys = entityManager.findByNumberAndType(indicatorInfo.getNumber(), type);
        if (entitys.isEmpty()) {
            BehaviorCollectorEntity entity = CaptureUtils.buildBehaviorCollectorEntity(indicatorInfo, CaptureCategoryEnum.OPERATIONTYPE.getNumber());
            entity.setTotal(1L);
            entityManager.insert(entity);
        }
    }

    @Override
    public List<IndicatorInfo> fetch(String number, String dimValue) {
        List<BehaviorCollectorEntity> entitys = ((BehaviorCollectorEntityManager)Objects.requireNonNull(Context.getCommandContext()).getEntityManager(BehaviorCollectorEntityManager.class)).findByNumberAndType(number, null);
        ArrayList<IndicatorInfo> infos = new ArrayList<IndicatorInfo>(entitys.size());
        if (!entitys.isEmpty()) {
            IndicatorInfo billRelation = null;
            IndicatorInfo billBOTPRelation = null;
            int len = entitys.size();
            for (int i = 0; i < len; ++i) {
                if ("bizflow".equals(entitys.get(i).getType())) {
                    billRelation = this.build(entitys.get(i));
                    billRelation.setDimValue((Object)BILLRELATIONTYPE.BILLRELATIONTYPE.getNumber());
                    continue;
                }
                billBOTPRelation = this.build(entitys.get(i));
                billBOTPRelation.setDimValue((Object)BILLRELATIONTYPE.BILLBOTPRELATIONTYPE.getNumber());
            }
            if (billRelation != null) {
                infos.add(billRelation);
                if (billBOTPRelation != null) {
                    billBOTPRelation.setTotal(Long.valueOf(0L));
                    infos.add(billBOTPRelation);
                }
            } else if (billBOTPRelation != null) {
                billBOTPRelation.setTotal(Long.valueOf(0L));
                infos.add(billBOTPRelation);
                billRelation = billBOTPRelation.clone();
                billRelation.setDimValue((Object)BILLRELATIONTYPE.BILLRELATIONTYPE.getNumber());
                billRelation.setDimDisplayValue((ILocaleString)BILLRELATIONTYPE.BILLRELATIONTYPE.getName().toLocaleString());
                billRelation.setTotal(Long.valueOf(0L));
                infos.add(billRelation);
            }
        }
        return infos;
    }

    @Override
    public ILocaleString getDimName(String type, boolean isNeedQueryTable) {
        return BILLRELATIONTYPE.BILLBOTPRELATIONTYPE.getNumber().equals(type) ? BILLRELATIONTYPE.BILLBOTPRELATIONTYPE.getName().toLocaleString() : BILLRELATIONTYPE.BILLRELATIONTYPE.getName().toLocaleString();
    }

    @Override
    public String getDim() {
        return "type";
    }

    @Override
    protected ILocaleString getName() {
        return ResManager.getLocaleString((String)"\u5355\u636e\u5173\u7cfb\u56fe\u4f7f\u7528\u5ba2\u6237", (String)"BillRelationCapture_3", (String)"bos-wf-devops");
    }

    @Override
    protected String getAppNumber() {
        return "bpm";
    }

    @Override
    public boolean isReportData() {
        return true;
    }

    static enum BILLRELATIONTYPE {
        BILLBOTPRELATIONTYPE("billBOTPRelation", new MultiLangEnumBridge("\u4ec5\u4f7f\u7528\u5355\u636e\u5173\u7cfb\u56fe\u529f\u80fd\u7684\u5ba2\u6237\u6570", "BillRelationCapture_1", "bos-wf-devops")),
        BILLRELATIONTYPE("billRelation", new MultiLangEnumBridge("\u4f7f\u7528\u5355\u636e\u5173\u7cfb\u56fe\u529f\u80fd\u7684\u5ba2\u6237\u6570", "BillRelationCapture_2", "bos-wf-devops"));

        String number;
        MultiLangEnumBridge name;

        private BILLRELATIONTYPE(String number, MultiLangEnumBridge name) {
            this.number = number;
            this.name = name;
        }

        public String getNumber() {
            return this.number;
        }

        public MultiLangEnumBridge getName() {
            return this.name;
        }
    }
}

