/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.statisticalanalysis.captures.wf;

import java.util.stream.Stream;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.workflow.devopos.info.IndicatorInfo;
import kd.bos.workflow.devops.statisticalanalysis.captures.AbstractOperationCapture;
import kd.bos.workflow.engine.MultiLangEnumBridge;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntity;

public class ApproveTerminalCapture
extends AbstractOperationCapture {
    public static final String NUMBER = "approveTerminal";

    @Override
    public IndicatorInfo build(Entity entity) {
        if (entity instanceof CommentEntity) {
            CommentEntity comment = (CommentEntity)entity;
            String terminalWay = comment.getTerminalWay();
            if ("comment".equals(comment.getType()) && "approve".equals(comment.getDecisionType())) {
                return new IndicatorInfo(NUMBER, (Object)terminalWay);
            }
        }
        return super.build(entity);
    }

    @Override
    public ILocaleString getDimName(String type, boolean isNeedQueryTable) {
        TerminalwayType terminalway = TerminalwayType.getTerminalwayType(type);
        if (terminalway != null && terminalway.getName() != null) {
            return terminalway.getName().toLocaleString();
        }
        return new LocaleString();
    }

    @Override
    public String getDim() {
        return "terminalway";
    }

    @Override
    protected ILocaleString getName() {
        return ResManager.getLocaleString((String)"\u5ba1\u6279\u9875\u9762\u5728\u4e0d\u540c\u7ec8\u7aef\u5ba1\u6279\u6570\u91cf", (String)"ApproveTerminalCapture_15", (String)"bos-wf-devops");
    }

    @Override
    protected String getAppNumber() {
        return "wf";
    }

    static enum TerminalwayType {
        WEB("web", new MultiLangEnumBridge("\u6d88\u606f\u4e2d\u5fc3", "ApproveTerminalCapture_1", "bos-wf-devops")),
        MOBILE("mobile", new MultiLangEnumBridge("\u6d41\u7a0b\u52a9\u624b", "ApproveTerminalCapture_2", "bos-wf-devops")),
        BACKGROUND("background", new MultiLangEnumBridge("\u540e\u53f0", "ApproveTerminalCapture_3", "bos-wf-devops")),
        API("api", new MultiLangEnumBridge("API", "ApproveTerminalCapture_4", "bos-wf-devops")),
        DINGDING("mobile_dd", new MultiLangEnumBridge("\u9489\u9489", "ApproveTerminalCapture_5", "bos-wf-devops")),
        EMAIL("mobile_email", new MultiLangEnumBridge("\u90ae\u4ef6", "ApproveTerminalCapture_6", "bos-wf-devops")),
        SMS("mobile_sms", new MultiLangEnumBridge("\u77ed\u4fe1", "ApproveTerminalCapture_7", "bos-wf-devops")),
        QYWEIXIN("mobile_wxqyh", new MultiLangEnumBridge("\u4f01\u4e1a\u5fae\u4fe1", "ApproveTerminalCapture_8", "bos-wf-devops")),
        KINGDEE_QYWEIXIN("mobile_kingdee_sky", new MultiLangEnumBridge("\u516c\u6709\u4e91\u4f01\u4e1a\u5fae\u4fe1", "ApproveTerminalCapture_9", "bos-wf-devops")),
        WELINK("mobile_wl", new MultiLangEnumBridge("WeLink", "ApproveTerminalCapture_10", "bos-wf-devops")),
        YUNZHIJIA("mobile_yunzhijia", new MultiLangEnumBridge("\u4e91\u4e4b\u5bb6", "ApproveTerminalCapture_11", "bos-wf-devops")),
        YUNZHIJIAUP("mobile_yunzhijiaup", new MultiLangEnumBridge("\u65b0\u7248\u4e91\u4e4b\u5bb6", "ApproveTerminalCapture_12", "bos-wf-devops")),
        YUNZHIJIAECO("mobile_yunzhijiaeco", new MultiLangEnumBridge("\u751f\u6001\u4e91\u4e4b\u5bb6", "ApproveTerminalCapture_13", "bos-wf-devops")),
        OTHER("mobile_other", new MultiLangEnumBridge("\u5176\u5b83\u6e20\u9053", "ApproveTerminalCapture_14", "bos-wf-devops"));

        String number;
        MultiLangEnumBridge name;

        private TerminalwayType(String number, MultiLangEnumBridge name) {
            this.number = number;
            this.name = name;
        }

        public String getNumber() {
            return this.number;
        }

        public MultiLangEnumBridge getName() {
            return this.name;
        }

        public static TerminalwayType getTerminalwayType(String number) {
            if (StringUtils.isBlank((CharSequence)number)) {
                return null;
            }
            return Stream.of(TerminalwayType.values()).filter(each -> each.getNumber().equals(number)).findFirst().orElse(null);
        }
    }
}

