/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.statisticalanalysis.captures.wf;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.devopos.info.IndicatorInfo;
import kd.bos.workflow.devops.entity.BehaviorCollectorEntity;
import kd.bos.workflow.devops.entity.BehaviorCollectorEntityManager;
import kd.bos.workflow.devops.statisticalanalysis.captures.AbstractOperationCapture;
import kd.bos.workflow.engine.impl.context.Context;
import org.apache.commons.lang.time.DateFormatUtils;

public class ExpectionProcessDailyCapture
extends AbstractOperationCapture {
    private Log logger = LogFactory.getLog(ExpectionProcessDailyCapture.class);
    public static final String NUMBER = "expectionProcessDaily";
    private static final String CONNECTOR = "_#";

    @Override
    public ILocaleString getDimName(String type, boolean isNeedQueryTable) {
        return null;
    }

    @Override
    public String getDim() {
        return "date";
    }

    @Override
    protected ILocaleString getName() {
        return ResManager.getLocaleString((String)"\u5ba2\u6237\u6bcf\u5929\u4ea7\u751f\u7684\u5f02\u5e38\u6d41\u7a0b\u6570", (String)"ExpectionProcessDailyCapture_0", (String)"bos-wf-devops");
    }

    @Override
    protected IndicatorInfo buildFromOtherIndicatorInfo(IndicatorInfo indicatorInfo) {
        Object createDate = indicatorInfo.getSpecialProperty("createDate");
        if (createDate == null || StringUtils.isBlank((Object)indicatorInfo.getSpecialProperty("errorType"))) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = new Date();
        try {
            date = sdf.parse((String)createDate);
        }
        catch (ParseException e) {
            this.logger.info("ExpectionProcessDailyCapture_capture format date error" + createDate);
        }
        String errorType = (String)indicatorInfo.getSpecialProperty("errorType");
        String type = new StringJoiner(CONNECTOR).add(DateFormatUtils.format((Date)date, (String)this.getDateFormat())).add(errorType).toString();
        IndicatorInfo info = this.build(NUMBER, type);
        info.setAddCount(indicatorInfo.getAddCount());
        return info;
    }

    @Override
    public List<IndicatorInfo> fetch(String number, String dimValue) {
        if (StringUtils.contains((CharSequence)dimValue, (CharSequence)"-")) {
            String[] arr = dimValue.split("-");
            List<BehaviorCollectorEntity> entitys = ((BehaviorCollectorEntityManager)Objects.requireNonNull(Context.getCommandContext()).getEntityManager(BehaviorCollectorEntityManager.class)).findBehaviorCollectorBetweenDimvalue(NUMBER, arr[0], arr[1]);
            ArrayList<IndicatorInfo> infos = new ArrayList<IndicatorInfo>(entitys.size());
            entitys.stream().collect(Collectors.toMap(entity -> {
                String type = entity.getType();
                return type.substring(type.indexOf(CONNECTOR) + 2);
            }, entity -> {
                IndicatorInfo indicatorInfo = new IndicatorInfo(NUMBER, (Object)entity.getType().substring(entity.getType().indexOf(CONNECTOR) + 2));
                indicatorInfo.setTotal(entity.getTotal());
                return indicatorInfo;
            }, (p1, p2) -> {
                p1.setTotal(Long.valueOf(p1.getTotal() + p2.getTotal()));
                return p1;
            })).forEach((key, value) -> infos.add((IndicatorInfo)value));
            return infos;
        }
        return super.fetch(number, dimValue);
    }

    @Override
    protected String getAppNumber() {
        return "wf";
    }

    protected String getDateFormat() {
        return "yyyyMMdd";
    }
}

