/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.statisticalanalysis.captures.wf;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.devopos.ProcessNotExistReasonEnum;
import kd.bos.workflow.devopos.info.IndicatorInfo;
import kd.bos.workflow.devops.statisticalanalysis.captures.AbstractSqlCapture;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;

public class NoStartedProcessCapture
extends AbstractSqlCapture {
    private Log logger = LogFactory.getLog(this.getClass());
    public static final String NUMBER = "noStartedProcess";
    private static final String QUERYSQL = "select count(1) count, ferrorreason number from t_wf_notinprocess where fsubmittime >= ? and fsubmittime <= ? group by ferrorreason";

    @Override
    public List<IndicatorInfo> fetch(String number, String dimValue) {
        Date startDate = WfUtils.now();
        try {
            startDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(dimValue);
        }
        catch (Exception e) {
            this.logger.info(this.getClass().getName() + ":" + dimValue);
        }
        ArrayList<IndicatorInfo> infos = new ArrayList<IndicatorInfo>(3);
        try (DataSet ds = DB.queryDataSet((String)"devops.getData", (DBRoute)DBRoute.workflow, (String)QUERYSQL, (Object[])new Object[]{startDate, WfUtils.now()});){
            for (Row row : ds) {
                ILocaleString name = this.getDimName(row.getString("number"));
                if (!StringUtils.isNotBlank((Object)name)) continue;
                IndicatorInfo indicatorInfo = new IndicatorInfo(NUMBER, (Object)row.getString("number"));
                indicatorInfo.setTotal(row.getLong("count"));
                indicatorInfo.setDimDisplayValue(name);
                infos.add(indicatorInfo);
            }
        }
        return infos;
    }

    @Override
    public ILocaleString getDimName(String type) {
        if (ProcessNotExistReasonEnum.NOT_FIND.getReason().equalsIgnoreCase(type)) {
            return WfMultiLangUtils.getLocaleString((String)"\u65e0\u5339\u914d\u7684\u6d41\u7a0b", (String)"NoStartedProcessPieChartPlugin_0", (String)"bos-wf-devops", (Object[])new Object[0]);
        }
        if (ProcessNotExistReasonEnum.ERROR_ADDRESS.getReason().equalsIgnoreCase(type)) {
            return WfMultiLangUtils.getLocaleString((String)"\u5bfb\u5740\u5f02\u5e38", (String)"NoStartedProcessPieChartPlugin_1", (String)"bos-wf-devops", (Object[])new Object[0]);
        }
        if (ProcessNotExistReasonEnum.CONFLICT.getReason().equalsIgnoreCase(type)) {
            return WfMultiLangUtils.getLocaleString((String)"\u5339\u914d\u5230\u591a\u6761\u6d41\u7a0b", (String)"NoStartedProcessPieChartPlugin_2", (String)"bos-wf-devops", (Object[])new Object[0]);
        }
        return null;
    }

    @Override
    public String getDim() {
        return "type";
    }

    @Override
    protected ILocaleString getName() {
        return ResManager.getLocaleString((String)"\u672a\u8fdb\u5165\u6d41\u7a0b\u7684\u6d41\u7a0b\u7edf\u8ba1", (String)"NoStartedProcessCapture_0", (String)"bos-wf-devops");
    }

    @Override
    protected String getAppNumber() {
        return "wf";
    }
}

