/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.statisticalanalysis.captures.wf;

import java.util.stream.Stream;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.workflow.devopos.info.IndicatorInfo;
import kd.bos.workflow.devops.statisticalanalysis.captures.AbstractOperationCapture;
import kd.bos.workflow.engine.MultiLangEnumBridge;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;
import kd.bos.workflow.engine.impl.persistence.entity.operationlog.OperationLogEntityImpl;

public class OperationLogCapture
extends AbstractOperationCapture {
    public static final String NUMBER = "operationLog";
    public static final String[] OPERATIONSCOLLECTION = new String[]{"transfer", "circulation", "reminders", "terminal_f", "addsign", "delegate", "coordinateRequest", "comment", "withdraw", "jump", "billWithdraw", "suspend"};

    private boolean isNeedCollect(String operate) {
        for (int i = 0; i < OPERATIONSCOLLECTION.length; ++i) {
            if (!OPERATIONSCOLLECTION[i].equals(operate)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IndicatorInfo build(Entity entity) {
        String operation;
        if (entity instanceof OperationLogEntityImpl && this.isNeedCollect(operation = ((OperationLogEntityImpl)entity).getType())) {
            return new IndicatorInfo(NUMBER, (Object)operation);
        }
        return super.build(entity);
    }

    @Override
    public ILocaleString getDimName(String type, boolean isNeedQueryTable) {
        OperationType operationType = OperationType.getOperationType(type);
        if (operationType != null && operationType.getName() != null) {
            return operationType.getName().toLocaleString();
        }
        return new LocaleString();
    }

    @Override
    public String getDim() {
        return "type";
    }

    @Override
    protected ILocaleString getName() {
        return ResManager.getLocaleString((String)"\u5ba1\u6279\u9875\u9762\u64cd\u4f5c\u4f7f\u7528\u6570\u636e\u91cf", (String)"OperationLogCapture_5", (String)"bos-wf-devops");
    }

    @Override
    protected String getAppNumber() {
        return "wf";
    }

    @Override
    public boolean isReportData() {
        return true;
    }

    static enum OperationType {
        TRANSFER("transfer", new MultiLangEnumBridge("\u8f6c\u4ea4", "OperationLogCapture_1", "bos-wf-devops")),
        CIRCULATION("circulation", new MultiLangEnumBridge("\u4f20\u9605", "OperationLogCapture_2", "bos-wf-devops")),
        REMINDERS("reminders", new MultiLangEnumBridge("\u50ac\u529e", "OperationLogCapture_3", "bos-wf-devops")),
        ADDSIGN("addsign", new MultiLangEnumBridge("\u52a0\u7b7e", "OperationLogCapture_4", "bos-wf-devops")),
        DELEGATE("delegate", new MultiLangEnumBridge("\u59d4\u6258", "OperationLogCapture_13", "bos-wf-devops")),
        COORDINATEREQUEST("coordinateRequest", new MultiLangEnumBridge("\u534f\u529e\u8bf7\u6c42", "OperationLogCapture_6", "bos-wf-devops")),
        COMMENT("comment", new MultiLangEnumBridge("\u5ba1\u6279", "OperationLogCapture_7", "bos-wf-devops")),
        WITHDRAW("withdraw", new MultiLangEnumBridge("\u64a4\u56de", "OperationLogCapture_8", "bos-wf-devops")),
        JUMP("jump", new MultiLangEnumBridge("\u8df3\u8f6c", "OperationLogCapture_9", "bos-wf-devops")),
        BILLWITHDRAW("billWithdraw", new MultiLangEnumBridge("\u6574\u5355\u64a4\u56de", "OperationLogCapture_10", "bos-wf-devops")),
        SUSPEND("suspend", new MultiLangEnumBridge("\u6302\u8d77", "OperationLogCapture_11", "bos-wf-devops")),
        TERMINAL_F("terminal_f", new MultiLangEnumBridge("\u5f3a\u5236\u7ec8\u6b62", "OperationLogCapture_12", "bos-wf-devops"));

        String number;
        MultiLangEnumBridge name;

        private OperationType(String number, MultiLangEnumBridge name) {
            this.number = number;
            this.name = name;
        }

        public String getNumber() {
            return this.number;
        }

        public MultiLangEnumBridge getName() {
            return this.name;
        }

        public static OperationType getOperationType(String number) {
            return Stream.of(OperationType.values()).filter(each -> each.getNumber().equals(number)).findFirst().orElse(null);
        }
    }
}

