/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.statisticalanalysis.captures.wf;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.devopos.info.IndicatorInfo;
import kd.bos.workflow.devops.entity.DevopsIndicatorEntity;
import kd.bos.workflow.devops.entity.PluginExeSummaryEntity;
import kd.bos.workflow.devops.entity.PluginExeSummaryEntityManager;
import kd.bos.workflow.devops.statisticalanalysis.captures.AbstractOperationCapture;
import kd.bos.workflow.devops.util.DevopsUtils;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricActivityInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.history.HistoricProcessInstanceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class PluginExecuteCapture
extends AbstractOperationCapture {
    private static Log logger = LogFactory.getLog(PluginExecuteCapture.class);
    public static final String NUMBER = "pluginExecutionInfo";
    private static List<String> executingTimes = Stream.of("start", "end", "terminate", "node_audit_start", "node_audit_end", "withdraw_audited_proc", "calculate_participant").collect(Collectors.toList());
    private static String NODESTARTTIME = "start";
    private static String NODELEVELTIME = "end";
    private static String PROCESS_PLUGIN = "PROCESS-PLUGIN";

    @Override
    public ILocaleString getDimName(String type, boolean isNeedQueryTable) {
        return new LocaleString(type);
    }

    @Override
    public String getDim() {
        return null;
    }

    @Override
    public void capture(IndicatorInfo indicatorInfo) {
        logger.info("PluginExecuteCapture.capture begin");
        Map specialProperty = indicatorInfo.getSpecialProperty();
        if (WfUtils.isEmptyForMap((Map)specialProperty)) {
            logger.debug("specialProperty is empty!");
            return;
        }
        try {
            logger.info("PluginExecuteCapture.capture saveData");
            DevopsUtils.getWorkflowDevopsService().savePluginData(indicatorInfo);
        }
        catch (Exception e) {
            logger.warn("executed.PluginExecuteCapture.occurred.exception-{}", (Object)WfUtils.getExceptionStacktrace((Throwable)e));
        }
    }

    @Override
    public List<IndicatorInfo> fetch(String number, String dimValue) {
        PluginExeSummaryEntityManager entityManager = (PluginExeSummaryEntityManager)Context.getCommandContext().getEntityManager(PluginExeSummaryEntityManager.class);
        List<PluginExeSummaryEntity> plugins = entityManager.getTimeConsumptionTop5();
        ArrayList<IndicatorInfo> infos = new ArrayList<IndicatorInfo>(plugins.size());
        plugins.forEach(pluginExeSummaryEntity -> {
            IndicatorInfo indicatorInfo = new IndicatorInfo(NUMBER, (Object)pluginExeSummaryEntity.getPluginNo());
            indicatorInfo.setTotal(pluginExeSummaryEntity.getAverageDuration());
            indicatorInfo.setDimDisplayValue(pluginExeSummaryEntity.getPluginName());
            infos.add(indicatorInfo);
        });
        return infos;
    }

    @Override
    public IndicatorInfo build(Entity entity) {
        if (entity instanceof DevopsIndicatorEntity) {
            logger.info("executed.PluginExecuteCapture.build.begin");
            IndicatorInfo info = new IndicatorInfo();
            try {
                String specialParam = ((DevopsIndicatorEntity)entity).getParams();
                Map<String, Object> paramMap = new HashMap();
                if (WfUtils.isNotEmpty((String)specialParam)) {
                    paramMap = (Map)SerializationUtils.fromJsonString((String)specialParam, Map.class);
                }
                if (WfUtils.isNotEmptyForMap(paramMap)) {
                    HistoricProcessInstanceEntity historicProcessInstanceEntity;
                    Long procDefId = (Long)paramMap.get("procdefid");
                    ProcessDefinitionEntity processDefinitionEntity = DevopsUtils.getWorkflowDevopsService().getProcessDefinitionEntityById(procDefId);
                    paramMap.put("name", processDefinitionEntity.getName() == null ? "" : processDefinitionEntity.getName());
                    paramMap.put("processtype", processDefinitionEntity.getType() == null ? "" : processDefinitionEntity.getType());
                    paramMap.put("processno", processDefinitionEntity.getKey());
                    paramMap.put("version", processDefinitionEntity.getVersion());
                    paramMap.put("entitynumber", processDefinitionEntity.getEntraBill());
                    LocaleString entityName = new LocaleString();
                    Long procInstId = (Long)paramMap.get("procinstid");
                    if (WfUtils.isNotEmpty((Long)procInstId) && (historicProcessInstanceEntity = PluginExecuteCapture.getWorkflowService().getHistoryService().getHistoricProcessInstance(procInstId)) != null) {
                        ILocaleString proAndScmName = historicProcessInstanceEntity.getName();
                        PluginExecuteCapture.getProcessName(proAndScmName, paramMap);
                        entityName = historicProcessInstanceEntity.getEntraBillName();
                    }
                    paramMap.put("entityname", entityName);
                    if (paramMap.get("elementname") == null || paramMap.get("elementname").toString().equals("")) {
                        paramMap.put("elementname", PluginExecuteCapture.getActName(procInstId, (String)paramMap.get("elementid")));
                    }
                    String entityNumber = (String)paramMap.get("entitynumber");
                    String wfPluginJson = (String)paramMap.get("currentwfplugin");
                    Long beginTime = (Long)paramMap.get("begintime");
                    Long endTime = (Long)paramMap.get("endtime");
                    String pluginType = (String)paramMap.get("extitfcallertype");
                    String scene = PluginExecuteCapture.getScene(pluginType);
                    paramMap.put("scene", scene);
                    if (PROCESS_PLUGIN.equalsIgnoreCase(scene)) {
                        paramMap.put("elementid", PROCESS_PLUGIN);
                        paramMap.put("elementname", PROCESS_PLUGIN);
                    }
                    Map<String, Object> pluginMap = PluginExecuteCapture.getPluginParseInfo(wfPluginJson, (ILocaleString)entityName, entityNumber, pluginType);
                    paramMap.put("duration", endTime - beginTime);
                    paramMap.put("pluginname", pluginMap.get("pluginname"));
                    paramMap.put("pluginno", pluginMap.get("pluginno"));
                    paramMap.put("plugintype", PluginExecuteCapture.getPluginType(wfPluginJson));
                    info.setSpecialProperty(paramMap);
                    info.setDimValue((Object)((DevopsIndicatorEntity)entity).getDimValue());
                    info.setNumber(((DevopsIndicatorEntity)entity).getNumber());
                    info.setAddCount(((DevopsIndicatorEntity)entity).getAddCount());
                    logger.info("executed.PluginExecuteCapture.build.end");
                    return info;
                }
            }
            catch (Exception e) {
                logger.warn(String.format("executed PluginExecuteCapture.build occurred exception-[%s]", WfUtils.getExceptionStacktrace((Throwable)e)));
                return null;
            }
        }
        return super.build(entity);
    }

    private static void getProcessName(ILocaleString proAndScmName, Map<String, Object> paramMap) {
        ILocaleString name = (ILocaleString)paramMap.get("name");
        LocaleString newProcessNameL = new LocaleString();
        try {
            if (WfUtils.isNotEmpty((ILocaleString)proAndScmName)) {
                for (Map.Entry entry : proAndScmName.entrySet()) {
                    if (!WfUtils.isNotEmpty((String)((String)entry.getValue()))) continue;
                    String processName = (String)name.get(entry.getKey());
                    String schemeName = WfUtils.isEmpty((String)((String)proAndScmName.get(entry.getKey()))) ? "" : ((String)proAndScmName.get(entry.getKey())).split("/")[3];
                    newProcessNameL.put(entry.getKey(), (Object)String.format("%s/%s", processName == null ? "" : processName, schemeName));
                }
                paramMap.put("name", newProcessNameL);
            }
        }
        catch (Exception e) {
            logger.warn(String.format("getProcessName:%s \u2014\u2014occurred exception", proAndScmName));
        }
    }

    private static ILocaleString getActName(Long procInstId, String actId) {
        try {
            List hiActivityInstances = PluginExecuteCapture.getWorkflowService().getHistoryService().getHistoricActivityByProcessInstanceIdAndActivityId(procInstId, actId);
            if (WfUtils.isNotEmptyForCollection((Collection)hiActivityInstances)) {
                return ((HistoricActivityInstanceEntity)hiActivityInstances.get(0)).getActivityName();
            }
            logger.debug(String.format("procInstId\uff1a%s,actId:%s \u2014\u2014query result is empty", procInstId, actId));
        }
        catch (Exception e) {
            logger.debug(String.format("procInstId\uff1a%s,actId:%s \u2014\u2014occurred exception", procInstId, actId));
        }
        return null;
    }

    private static Map<String, Object> getPluginParseInfo(String wfPluginInfo, ILocaleString billName, String entityNumber, String type) {
        HashMap<String, Object> ret = new HashMap<String, Object>(2);
        String pluginNo = "";
        ILocaleString pluginName = null;
        if (WfUtils.isEmpty((String)wfPluginInfo)) {
            pluginNo = entityNumber + "." + type;
            ret.put("pluginno", pluginNo);
            ret.put("pluginname", pluginNo);
            return ret;
        }
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject = JSONObject.parseObject((String)wfPluginInfo);
        }
        catch (Exception e) {
            logger.error(String.format("%s %s %s %s", wfPluginInfo, "[JSON\u5b57\u7b26\u4e32\u8f6cJSONObject\u51fa\u9519]", WfUtils.getExceptionStacktrace((Throwable)e), e.getStackTrace()));
        }
        String pluginType = String.valueOf(jsonObject.get((Object)"type"));
        if ("class".equalsIgnoreCase(pluginType)) {
            pluginNo = jsonObject.get((Object)"number") == null ? String.valueOf(jsonObject.get((Object)"value")) : String.valueOf(jsonObject.get((Object)"number"));
            String pluginNameStr = String.valueOf(jsonObject.get((Object)"value"));
            pluginName = PluginExecuteCapture.getPluginName(pluginNameStr);
        } else if ("script".equalsIgnoreCase(pluginType)) {
            JSONObject jsonValue = (JSONObject)jsonObject.get((Object)"value");
            pluginNo = String.valueOf(jsonValue.get((Object)"number"));
            String idStr = String.valueOf(jsonValue.get((Object)"id"));
            String pluginNameStr = PluginExecuteCapture.getPluginScriptName(idStr, pluginNo);
            pluginName = PluginExecuteCapture.getPluginName(pluginNameStr);
        } else if ("operation".equalsIgnoreCase(pluginType)) {
            JSONObject jsonValue = (JSONObject)jsonObject.get((Object)"value");
            String forward = (String)jsonValue.get((Object)"forward");
            String withdraw = (String)jsonValue.get((Object)"withdraw");
            String operateKey = WfUtils.isEmpty((String)forward) ? withdraw : forward;
            pluginNo = entityNumber + "." + operateKey;
            pluginName = PluginExecuteCapture.getPluginName(billName, operateKey, entityNumber);
        }
        ret.put("pluginno", pluginNo);
        ret.put("pluginname", pluginName);
        return ret;
    }

    private static ILocaleString getPluginName(String pluginNameStr) {
        LocaleString pluginName = new LocaleString();
        for (Lang lang : WfMultiLangUtils.getSupportLangs()) {
            String key = lang.name();
            pluginName.put((Object)key, (Object)pluginNameStr);
        }
        return pluginName;
    }

    private static ILocaleString getPluginName(ILocaleString billName, String operateKey, String entityNumber) {
        Map name;
        Map opInfo = EntityMetadataCache.getDataEntityOperate((String)entityNumber, (String)operateKey);
        if (opInfo != null && !opInfo.isEmpty() && (name = (Map)opInfo.get("name")) != null && !name.isEmpty()) {
            ILocaleString pluginName = WfMultiLangUtils.jointILocaleString((ILocaleString)billName, (ILocaleString)LocaleString.fromMap((Map)name), (String)".");
            return pluginName;
        }
        return null;
    }

    private static String getPluginType(String wfPluginInfo) {
        String pluginType = "";
        try {
            JSONObject jsonObject = JSONObject.parseObject((String)wfPluginInfo);
            pluginType = String.valueOf(jsonObject.get((Object)"type"));
        }
        catch (Exception e) {
            logger.error(String.format("%s %s %s %s", wfPluginInfo, "[JSON\u5b57\u7b26\u4e32\u8f6cJSONObject\u51fa\u9519]", WfUtils.getExceptionStacktrace((Throwable)e), e.getStackTrace()));
        }
        return pluginType;
    }

    private static WorkflowService getWorkflowService() {
        return (WorkflowService)ServiceFactory.getService(WorkflowService.class);
    }

    private static String getPluginScriptName(String id, String pluginNo) {
        if (WfUtils.isEmpty((String)id)) {
            return pluginNo;
        }
        QFilter qFilter = new QFilter("id", "=", (Object)id);
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"ide_pluginscript", (String)"txt_scriptname", (QFilter[])new QFilter[]{qFilter});
        if (dynamicObject != null) {
            return dynamicObject.getString("txt_scriptname");
        }
        return pluginNo;
    }

    private static String getScene(String scene) {
        String resultScene = "";
        switch (scene) {
            case "calcUserIds": 
            case "filterParticipant": 
            case "PARTICIPANT": 
            case "CALCULATEPARTICIPANT": {
                resultScene = "CALCULATEPARTICIPANT";
                break;
            }
            case "hasTrueCondition": 
            case "CONDITIONALRULE": {
                resultScene = "CONDITIONALRULE";
                break;
            }
            case "parseBillSubject": 
            case "BILLSUBJECT": {
                resultScene = "BILLSUBJECT";
                break;
            }
            case "getExpireTime": 
            case "TIMECONTROL": {
                resultScene = "TIMECONTROL";
                break;
            }
            case "getCustomApprovalRecordGroup": 
            case "CUSTOMAPPROVALRECORD": {
                resultScene = "CUSTOMAPPROVALRECORD";
                break;
            }
            default: {
                resultScene = executingTimes.contains(scene) && !scene.contains("@") ? "PROCESS-PLUGIN" : (scene.startsWith(NODESTARTTIME) && scene.contains("@") ? "START-NODE" : (scene.contains(NODELEVELTIME) && scene.contains("@") ? "LEAVE-NODE" : (scene.startsWith("approverModify") || scene.startsWith("afterCreate") || scene.startsWith("afterTransfer") || scene.startsWith("afterCoordReq") || scene.startsWith("afterCoordReply") || scene.startsWith("afterCoordCancel") || scene.startsWith("Consent") || scene.startsWith("Reject") || scene.startsWith("AFTERHANDLETASK") || scene.startsWith("complete") ? "HANDLE-TASK-NODE" : ("autotask".equalsIgnoreCase(scene) ? "NODE-PLUGIN" : scene))));
            }
        }
        return resultScene;
    }

    @Override
    public Boolean canGroupByNumberAndDim() {
        return Boolean.FALSE;
    }
}

