/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.statisticalanalysis.captures.wf;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.devopos.info.IndicatorInfo;
import kd.bos.workflow.devops.api.IDataCapture;
import kd.bos.workflow.devops.entity.BehaviorCollectorEntity;
import kd.bos.workflow.devops.entity.BehaviorCollectorEntityManager;
import kd.bos.workflow.devops.statisticalanalysis.DataCaptureFactory;
import kd.bos.workflow.devops.statisticalanalysis.captures.AbstractOperationCapture;
import kd.bos.workflow.devops.statisticalanalysis.captures.CaptureCategoryEnum;
import kd.bos.workflow.devops.statisticalanalysis.utils.CaptureUtils;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import org.apache.commons.lang.time.DateFormatUtils;

public class ProcessInstanceDailyCapture
extends AbstractOperationCapture {
    private Log log = LogFactory.getLog(ProcessInstanceDailyCapture.class);
    public static final String NUMBER = "processInstanceDaily";

    @Override
    public void capture(IndicatorInfo indicatorInfo) {
        Object dimValue = indicatorInfo.getDimValue();
        if (StringUtils.isBlank((Object)dimValue)) {
            return;
        }
        BehaviorCollectorEntityManager entityManager = (BehaviorCollectorEntityManager)Objects.requireNonNull(Context.getCommandContext()).getEntityManager(BehaviorCollectorEntityManager.class);
        List<BehaviorCollectorEntity> entitys = entityManager.findByNumberAndType(indicatorInfo.getNumber(), (String)dimValue);
        if (!entitys.isEmpty()) {
            entitys.get(0).setTotal(entitys.get(0).getTotal() + (long)indicatorInfo.getAddCount());
            entityManager.update(entitys.get(0));
        } else {
            BehaviorCollectorEntity behaviorCollectorEntity = CaptureUtils.buildBehaviorCollectorEntity(indicatorInfo, CaptureCategoryEnum.OPERATIONTYPE.getNumber());
            behaviorCollectorEntity.setType((String)dimValue);
            entityManager.insert(behaviorCollectorEntity);
        }
        IDataCapture dataCaptureInterface = DataCaptureFactory.getDataCaptureInterface("processInstanceAll");
        dataCaptureInterface.capture(indicatorInfo);
    }

    @Override
    public List<IndicatorInfo> fetch(String number, String dimValue) {
        if (StringUtils.contains((CharSequence)dimValue, (CharSequence)"-")) {
            String[] arr = dimValue.split("-");
            List<BehaviorCollectorEntity> entitys = ((BehaviorCollectorEntityManager)Objects.requireNonNull(Context.getCommandContext()).getEntityManager(BehaviorCollectorEntityManager.class)).findBehaviorCollectorBetweenDimvalue(number, arr[0], arr[1]);
            ArrayList<IndicatorInfo> infos = new ArrayList<IndicatorInfo>(entitys.size());
            entitys.forEach(entity -> infos.add(this.build((Entity)entity)));
            return infos;
        }
        return super.fetch(number, dimValue);
    }

    @Override
    public IndicatorInfo build(Entity entity) {
        if (entity instanceof ExecutionEntity && "AuditFlow".equals(((ExecutionEntity)entity).getProcessType())) {
            return new IndicatorInfo(NUMBER, (Object)DateFormatUtils.format((Date)entity.getCreateDate(), (String)"yyyyMMdd"));
        }
        return super.build(entity);
    }

    @Override
    public ILocaleString getDimName(String type, boolean isNeedQueryTable) {
        return null;
    }

    @Override
    public String getDim() {
        return "date";
    }

    @Override
    protected ILocaleString getName() {
        return ResManager.getLocaleString((String)"\u5ba2\u6237\u6bcf\u65e5\u4ea7\u751f\u7684\u6d41\u7a0b\u5b9e\u4f8b\u6570", (String)"ProcessInstanceDailyCapture_0", (String)"bos-wf-devops");
    }

    @Override
    protected String getAppNumber() {
        return "wf";
    }
}

