/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.statisticalanalysis.captures.wf;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.devopos.info.IndicatorInfo;
import kd.bos.workflow.devops.entity.BehaviorCollectorEntity;
import kd.bos.workflow.devops.entity.BehaviorCollectorEntityManager;
import kd.bos.workflow.devops.entity.DevopsRejectBillEntity;
import kd.bos.workflow.devops.entity.DevopsRejectBillEntityImpl;
import kd.bos.workflow.devops.entity.DevopsRejectBillEntityManager;
import kd.bos.workflow.devops.statisticalanalysis.captures.AbstractOperationCapture;
import kd.bos.workflow.devops.statisticalanalysis.captures.CaptureCategoryEnum;
import kd.bos.workflow.devops.statisticalanalysis.utils.CaptureUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;
import kd.bos.workflow.engine.impl.persistence.entity.task.CommentEntity;

public class RejectBillsCapture
extends AbstractOperationCapture {
    private Log logger = LogFactory.getLog(RejectBillsCapture.class);
    public static final String NUMBER = "rejectBills";
    private static final String BUSINESSKEY = "businesskey";
    private static final String BILLNO = "billno";
    private static final String ENTITYNAME = "entityname";
    private static final String ENTITYNUMBER = "entitynumber";

    @Override
    public void capture(IndicatorInfo indicatorInfo) {
        Map specialProperty = indicatorInfo.getSpecialProperty();
        if (WfUtils.isEmptyForMap((Map)specialProperty)) {
            this.logger.info("RejectBillsCapture_capture\uff1a\u7f3a\u5c11\u5fc5\u8981\u7684\u53c2\u6570\uff0c\u73a9\u4e0d\u4e86\uff0c\u8bf7\u81ea\u884c\u68c0\u67e5\u4e0b");
            return;
        }
        String businessKey = StringUtils.isNotBlank(specialProperty.get(BUSINESSKEY)) ? (String)specialProperty.get(BUSINESSKEY) : null;
        String billno = StringUtils.isNotBlank(specialProperty.get(BILLNO)) ? (String)specialProperty.get(BILLNO) : null;
        String entityNumber = StringUtils.isNotBlank(specialProperty.get(ENTITYNUMBER)) ? (String)specialProperty.get(ENTITYNUMBER) : null;
        LocaleString entityName = specialProperty.get(ENTITYNAME) != null && WfUtils.isNotEmptyForMap((Map)((Map)specialProperty.get(ENTITYNAME))) ? LocaleString.fromMap((Map)((Map)specialProperty.get(ENTITYNAME))) : WfUtils.getEntityNameByNumber((String)entityNumber);
        DevopsRejectBillEntityManager rejectEntityManager = (DevopsRejectBillEntityManager)Objects.requireNonNull(Context.getCommandContext()).getEntityManager(DevopsRejectBillEntityManager.class);
        List<DevopsRejectBillEntity> devopsRejectBillEntitys = rejectEntityManager.findByEntityNumberAndBusinessKey(entityNumber, businessKey);
        if (devopsRejectBillEntitys.isEmpty()) {
            rejectEntityManager.insert(new DevopsRejectBillEntityImpl(businessKey, billno, entityNumber, indicatorInfo.getAddCount(), (ILocaleString)entityName));
            BehaviorCollectorEntityManager behaviorEntityManager = (BehaviorCollectorEntityManager)Objects.requireNonNull(Context.getCommandContext()).getEntityManager(BehaviorCollectorEntityManager.class);
            List<BehaviorCollectorEntity> entitys = behaviorEntityManager.findByNumberAndType(NUMBER, entityNumber);
            if (entitys.isEmpty()) {
                indicatorInfo.setTotal(Long.valueOf(indicatorInfo.getAddCount()));
                indicatorInfo.setDimDisplayValue((ILocaleString)entityName);
                behaviorEntityManager.insert(CaptureUtils.buildBehaviorCollectorEntity(indicatorInfo, CaptureCategoryEnum.OPERATIONTYPE.getNumber()));
            } else {
                BehaviorCollectorEntity behaviorCollectorEntity = entitys.get(0);
                behaviorCollectorEntity.setTotal(behaviorCollectorEntity.getTotal() + (long)indicatorInfo.getAddCount());
                behaviorEntityManager.update(behaviorCollectorEntity);
            }
        } else {
            DevopsRejectBillEntity devopsRejectBillEntity = devopsRejectBillEntitys.get(0);
            devopsRejectBillEntity.setRejectTimes(devopsRejectBillEntity.getRejectTimes() + indicatorInfo.getAddCount());
            rejectEntityManager.update(devopsRejectBillEntity);
        }
    }

    @Override
    public IndicatorInfo build(Entity entity) {
        CommentEntity comment;
        if (entity instanceof CommentEntity && "comment".equals((comment = (CommentEntity)entity).getType()) && "reject".equals(comment.getDecisionType())) {
            IndicatorInfo indicatorInfo = new IndicatorInfo(NUMBER, (Object)comment.getEntityNumber(), 1);
            HashMap<String, String> params = new HashMap<String, String>(3);
            params.put(BUSINESSKEY, comment.getBusinessKey());
            params.put(ENTITYNUMBER, comment.getEntityNumber());
            params.put(ENTITYNAME, (String)comment.getEntityName());
            params.put(BILLNO, comment.getBillNo());
            indicatorInfo.setSpecialProperty(params);
            return indicatorInfo;
        }
        return super.build(entity);
    }

    @Override
    public ILocaleString getDimName(String type, boolean isNeedQueryTable) {
        return new LocaleString();
    }

    @Override
    public String getDim() {
        return "entityNumber";
    }

    @Override
    protected ILocaleString getName() {
        return ResManager.getLocaleString((String)"\u88ab\u9a73\u56de\u5355\u636e", (String)"RejectBillsCapture_0", (String)"bos-wf-devops");
    }

    @Override
    protected String getAppNumber() {
        return "wf";
    }

    @Override
    public List<IndicatorInfo> fetch(String number, String dimValue) {
        String entityNumber = dimValue;
        boolean isNeedBillInfo = false;
        if (StringUtils.isNotBlank((CharSequence)dimValue) && dimValue.contains("_#billno#_")) {
            entityNumber = dimValue.replace("_#billno#_", "");
            isNeedBillInfo = true;
        }
        ArrayList<IndicatorInfo> infos = new ArrayList<IndicatorInfo>(1);
        List<BehaviorCollectorEntity> entitys = ((BehaviorCollectorEntityManager)Objects.requireNonNull(Context.getCommandContext()).getEntityManager(BehaviorCollectorEntityManager.class)).findByNumberAndType(number, entityNumber);
        if (!entitys.isEmpty()) {
            IndicatorInfo indicatorInfo = this.build(entitys.get(0));
            if (isNeedBillInfo) {
                HashMap specialProperty = new HashMap(1);
                ArrayList rejectBills = new ArrayList();
                specialProperty.put(NUMBER, rejectBills);
                List<DevopsRejectBillEntity> devopsRejectBillEntitys = ((DevopsRejectBillEntityManager)Context.getCommandContext().getEntityManager(DevopsRejectBillEntityManager.class)).findByEntityNumberAndBusinessKey(entityNumber, null);
                devopsRejectBillEntitys.forEach(entity -> {
                    HashMap<String, Object> map = new HashMap<String, Object>(2);
                    map.put(BILLNO, entity.getBillno());
                    map.put("rejectTimes", entity.getRejectTimes());
                    rejectBills.add(map);
                });
                indicatorInfo.setSpecialProperty(specialProperty);
            }
            infos.add(indicatorInfo);
        }
        return infos;
    }
}

