/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.statisticalanalysis.captures.wf;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.workflow.devopos.info.IndicatorInfo;
import kd.bos.workflow.devops.entity.BehaviorCollectorEntity;
import kd.bos.workflow.devops.entity.BehaviorCollectorEntityManager;
import kd.bos.workflow.devops.statisticalanalysis.captures.AbstractSqlCapture;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.context.Context;

public class ScheduleStataeCapture
extends AbstractSqlCapture {
    public static final String NUMBER = "scheduleStatae";
    private static final String STATE_NORMAL = "normal";
    private static final String STATE_BUSY = "busy";
    private static final String STATE_BLOCK = "block";

    @Override
    public ILocaleString getDimName(String type) {
        return null;
    }

    @Override
    public String getDim() {
        return "state";
    }

    @Override
    public List<IndicatorInfo> fetch(String number, String dimValue) {
        ArrayList<IndicatorInfo> infos = new ArrayList<IndicatorInfo>(1);
        Calendar now = Calendar.getInstance();
        Date endDate = WfUtils.now();
        now.setTime(endDate);
        now.add(12, -30);
        Date startDate = now.getTime();
        SimpleDateFormat dimFormat = new SimpleDateFormat("yyyyMMddHHmm");
        BehaviorCollectorEntityManager behaviorCollectorEntityManager = (BehaviorCollectorEntityManager)Objects.requireNonNull(Context.getCommandContext()).getEntityManager(BehaviorCollectorEntityManager.class);
        long product = behaviorCollectorEntityManager.findBehaviorCollectorBetweenDimvalue("asyncMessageMinutelySend", dimFormat.format(startDate), dimFormat.format(endDate)).stream().mapToLong(BehaviorCollectorEntity::getTotal).sum();
        long consume = behaviorCollectorEntityManager.findBehaviorCollectorBetweenDimvalue("asyncMessageMinutelyConsumer", dimFormat.format(startDate), dimFormat.format(endDate)).stream().mapToLong(BehaviorCollectorEntity::getTotal).sum();
        String type = STATE_NORMAL;
        LocaleString typeName = ResManager.getLocaleString((String)"\u8fd0\u884c\u6b63\u5e38", (String)"ScheduleCardPlugin_3", (String)"bos-wf-devops");
        if (product > consume) {
            if (consume == 0L || (double)product / (double)consume > 1.5 && (double)product / (double)consume <= 3.0) {
                typeName = ResManager.getLocaleString((String)"\u6d88\u8d39\u901f\u5ea6\u7f13\u6162", (String)"ScheduleCardPlugin_9", (String)"bos-wf-devops");
                type = STATE_BUSY;
            } else if ((double)product / (double)consume > 3.0) {
                typeName = ResManager.getLocaleString((String)"\u6d88\u8d39\u901f\u5ea6\u8d85\u6162", (String)"ScheduleCardPlugin_10", (String)"bos-wf-devops");
                type = STATE_BLOCK;
            }
        }
        IndicatorInfo info = new IndicatorInfo(NUMBER, (Object)type);
        info.setDimDisplayValue((ILocaleString)typeName);
        info.addToSpecialProperty("consume", (Object)consume);
        info.addToSpecialProperty("product", (Object)product);
        infos.add(info);
        return infos;
    }

    @Override
    protected ILocaleString getName() {
        return ResManager.getLocaleString((String)"\u5de5\u4f5c\u6d41\u8c03\u5ea6\u8fd0\u884c\u72b6\u6001", (String)"ScheduleStataeCapture_0", (String)"bos-wf-devops");
    }

    @Override
    protected String getAppNumber() {
        return "wf";
    }
}

