/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.statisticalanalysis.captures.wf;

import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.workflow.devopos.info.IndicatorInfo;
import kd.bos.workflow.devops.statisticalanalysis.captures.AbstractOperationCapture;
import kd.bos.workflow.engine.MultiLangEnumBridge;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;
import kd.bos.workflow.engine.impl.persistence.entity.task.TaskEntity;

public class TaskCompleteCapture
extends AbstractOperationCapture {
    public static final String NUMBER = "taskComplete";
    private static final String AUTOAUDIT = "autoAudit";
    private static final String MANUALAPPROVAL = "manualApproval";
    private static final String AUTOAPPROVAL = "autoApproval";
    private static final String DELETEREASON = "deleteReason";
    private static final String FROM = "from";

    @Override
    public IndicatorInfo build(Entity entity) {
        if (entity instanceof TaskEntity && !entity.isInserted()) {
            Object deleteReason = ((TaskEntity)entity).getVariable(DELETEREASON);
            Object from = ((TaskEntity)entity).getVariable(FROM);
            IndicatorInfo indicatorInfo = new IndicatorInfo();
            indicatorInfo.setNumber(NUMBER);
            if ("task skip".equals(deleteReason) || "first_usertask_skip".equals(deleteReason) || AUTOAUDIT.equals(from)) {
                indicatorInfo.setDimValue((Object)AUTOAPPROVAL);
            } else {
                indicatorInfo.setDimValue((Object)MANUALAPPROVAL);
            }
            indicatorInfo.setAddCount(1);
            return indicatorInfo;
        }
        return super.build(entity);
    }

    @Override
    public ILocaleString getDimName(String type, boolean isNeedQueryTable) {
        return ApprovalMethodEnum.MANUALAPPROVAL.getNumber().equals(type) ? ApprovalMethodEnum.MANUALAPPROVAL.getName().toLocaleString() : ApprovalMethodEnum.AUTOAPPROVAL.getName().toLocaleString();
    }

    @Override
    public String getDim() {
        return "approvalMethod";
    }

    @Override
    protected ILocaleString getName() {
        return ResManager.getLocaleString((String)"\u5b8c\u6210\u4efb\u52a1\u6570\u91cf", (String)"TaskCompleteCapture_2", (String)"bos-wf-devops");
    }

    @Override
    protected String getAppNumber() {
        return "wf";
    }

    @Override
    public boolean isReportData() {
        return true;
    }

    static enum ApprovalMethodEnum {
        MANUALAPPROVAL("manualApproval", new MultiLangEnumBridge("\u4eba\u5de5\u5b8c\u6210", "TaskCompleteCapture_0", "bos-wf-devops")),
        AUTOAPPROVAL("autoApproval", new MultiLangEnumBridge("\u81ea\u52a8\u5b8c\u6210", "TaskCompleteCapture_1", "bos-wf-devops"));

        String number;
        MultiLangEnumBridge name;

        private ApprovalMethodEnum(String number, MultiLangEnumBridge name) {
            this.number = number;
            this.name = name;
        }

        public String getNumber() {
            return this.number;
        }

        public MultiLangEnumBridge getName() {
            return this.name;
        }
    }
}

