/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.statisticalanalysis.mq;

import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.thread.ThreadTruck;
import kd.bos.workflow.devops.cache.DevopsServiceCacheHelper;
import kd.bos.workflow.devops.statisticalanalysis.dto.WFDevopsDataInfo;
import kd.bos.workflow.devops.statisticalanalysis.utils.CaptureUtils;
import kd.bos.workflow.devops.util.DevopsUtils;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;

public class WfDevopsConsumer
implements MessageConsumer {
    private Log logger = LogFactory.getLog(WfDevopsConsumer.class);
    private ReentrantLock lock = new ReentrantLock();

    public void onMessage(Object body, String messageId, boolean resend, MessageAcker acker) {
        if (body instanceof WFDevopsDataInfo) {
            WFDevopsDataInfo dataInfo = (WFDevopsDataInfo)body;
            this.consumeMessage(dataInfo);
        }
        acker.ack(messageId);
    }

    private void consumeMessage(WFDevopsDataInfo dataInfo) {
        String type;
        switch (type = dataInfo.getType()) {
            case "indictorCapture": {
                this.captureIndicatorInfos((Map)dataInfo.getData());
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void captureIndicatorInfos(Map<String, Object> captureGroupMap) {
        String group = (String)captureGroupMap.get("group");
        if (WfUtils.isEmpty((String)group)) {
            this.logger.info("WfDevopsConsumer_group is null");
            return;
        }
        if (CaptureUtils.isEnableGroupsModel() && DevopsServiceCacheHelper.containsIndcitorsCaptureGroup("noGroups")) {
            this.logger.info("WfDevopsConsumer_group enable groups model, but nogroups is running, so return");
            return;
        }
        if (!DevopsServiceCacheHelper.containsIndcitorsCaptureGroup(group) && DevopsServiceCacheHelper.putIndcitorsCaptureGroup(group) > 0) {
            try (DLock lock = DLock.create((String)DevopsServiceCacheHelper.getWholeKey("indcitorsCaptureGroup", group), (String)group).fastMode();){
                boolean lockNotNeededOrSuccess = lock.tryLock();
                if (lockNotNeededOrSuccess) {
                    List numbers = (List)captureGroupMap.get("numbers");
                    int allowDealDevopsIndicatorCount = WfConfigurationUtil.getAllowQueryDevopsIndicatorCount();
                    allowDealDevopsIndicatorCount = allowDealDevopsIndicatorCount > 0 ? allowDealDevopsIndicatorCount : 100000;
                    int onceDealCount = WfConfigurationUtil.getAllowOnceQueryDevopsIndicatorCount();
                    onceDealCount = onceDealCount > 0 ? Math.min(onceDealCount, 5000) : 5000;
                    int total = 0;
                    int jumpFlag = 0;
                    int maxExecuteTimes = allowDealDevopsIndicatorCount / onceDealCount;
                    this.logger.info(String.format("WfDevopsConsumer_\u8981\u5faa\u73af\u7684\u6b21\u6570\uff1a%s\uff0cgroup\uff1a%s", maxExecuteTimes, group));
                    try {
                        while (total <= allowDealDevopsIndicatorCount) {
                            try {
                                Integer dealCount = DevopsUtils.getWorkflowDevopsService().collectAndStatisticsIndicator(numbers, onceDealCount);
                                this.logger.info("\u5f53\u524d\u5faa\u73af\u6b21\u6570\uff1a" + ++jumpFlag + ";\u5f53\u524d\u67e5\u8be2\u51fa\u6765\u7684\u6570\u91cf\uff1a" + dealCount + "\u5df2\u5904\u7406\u603b\u6570\u91cf:" + (total += dealCount.intValue()));
                                if (dealCount == 0) return;
                                if (jumpFlag >= maxExecuteTimes) {
                                    return;
                                }
                            }
                            catch (Exception e3) {
                                this.logger.info(e3.getMessage());
                                ThreadTruck.remove((Object)"wfProcDefIds");
                                ThreadTruck.remove((Object)"indicatorGroupStartDate");
                                DevopsServiceCacheHelper.removeIndcitorsCaptureGroup(group);
                                if (lock == null) return;
                                if (var4_4 != null) {
                                    try {
                                        lock.close();
                                        return;
                                    }
                                    catch (Throwable throwable) {
                                        var4_4.addSuppressed(throwable);
                                        return;
                                    }
                                }
                                lock.close();
                                return;
                            }
                            {
                                DevopsServiceCacheHelper.putIndcitorsCaptureGroup(group);
                            }
                        }
                        return;
                    }
                    finally {
                        ThreadTruck.remove((Object)"wfProcDefIds");
                        ThreadTruck.remove((Object)"indicatorGroupStartDate");
                        DevopsServiceCacheHelper.removeIndcitorsCaptureGroup(group);
                    }
                }
                this.logger.info(String.format("WfDevopsConsumer_lock\uff1a%s", group));
                return;
            }
        }
        this.logger.info(String.format("WfDevopsConsumer_\u7f13\u5b58\u62d2\u7edd\uff1a%s", group));
    }
}

