/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.statisticalanalysis.reportdata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.portal.datalog.service.IDataCollectService;
import kd.bos.workflow.devopos.info.IndicatorInfo;
import kd.bos.workflow.devops.util.DevopsUtils;
import kd.bos.workflow.engine.WfUtils;

public class WFDevopsDataReportImpl
implements IDataCollectService {
    Log log = LogFactory.getLog(WFDevopsDataReportImpl.class);

    public Map<String, Object> collectData() {
        return null;
    }

    public List<Map<String, Object>> collectBatchData() {
        ArrayList<Map<String, Object>> datas = new ArrayList<Map<String, Object>>();
        List<IndicatorInfo> reportDatas = DevopsUtils.getWorkflowDevopsService().getReportIndicators();
        reportDatas.stream().filter(Objects::nonNull).forEach(info -> {
            HashMap<String, Object> data = new HashMap<String, Object>(5);
            if (StringUtils.isNotBlank((Object)info.getName())) {
                data.put("name", info.getName().getLocaleValue_zh_CN());
            }
            if (StringUtils.isNotBlank((Object)info.getDimValue())) {
                data.put("type", info.getDimValue());
            }
            if (WfUtils.isNotEmpty((ILocaleString)info.getDimDisplayValue())) {
                data.put("display", info.getDimDisplayValue().getLocaleValue_zh_CN());
            }
            data.put("table_name", "t_wf_behaviorcollect");
            data.put("department", "wfs");
            data.put("business_scene", info.getNumber());
            data.put("statisticNumExt1", info.getTotal());
            datas.add(data);
        });
        List<Map<String, Object>> tmpDatas = this.reportTmpData();
        if (WfUtils.isNotEmptyForCollection(tmpDatas)) {
            datas.addAll(tmpDatas);
        }
        this.log.info("WFDevopsDataReportImpl_send" + datas.size());
        return datas;
    }

    private List<Map<String, Object>> reportTmpData() {
        ArrayList<Map<String, Object>> tmpDatas = new ArrayList<Map<String, Object>>(2);
        tmpDatas.add(this.getTmpReportData("enableProcess", "select count(1) count from t_wf_procdef where fenable='enable';"));
        tmpDatas.add(this.getTmpReportData("enableProcessSubScheme", "select count(1) count from t_wf_dynconfscheme where fstate='enable' and fdefault='0';"));
        return tmpDatas;
    }

    private Map<String, Object> getTmpReportData(String number, String sql) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        try (DataSet ds = DB.queryDataSet((String)"workflow_WFDevopsDataReportImpl", (DBRoute)WfUtils.WFS, (String)sql);){
            Iterator iter = ds.iterator();
            if (iter.hasNext()) {
                data.put("table_name", "t_wf_behaviorcollect");
                data.put("department", "wfs");
                data.put("business_scene", number);
                data.put("numExt1", ((Row)iter.next()).getLong("count"));
            }
        }
        return data;
    }
}

