/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.statisticalanalysis.utils;

import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.workflow.devopos.info.IndicatorInfo;
import kd.bos.workflow.devops.entity.BehaviorCollectorEntity;
import kd.bos.workflow.devops.entity.BehaviorCollectorEntityImpl;
import kd.bos.workflow.devops.entity.DevopsIndicatorEntity;
import kd.bos.workflow.devops.entity.DevopsIndicatorEntityImpl;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;

public class CaptureUtils {
    public static final String YYYYMMDD = "yyyyMMdd";
    public static final String YYYYMM = "yyyyMM";
    public static final String YYYYMMDDHHMM = "yyyyMMddHHmm";
    public static final String YYYYMMDDHHMMSS = "yyyy-MM-dd HH:mm:ss";
    private static Log logger = LogFactory.getLog(CaptureUtils.class);

    public static IndicatorInfo buildIndicatorInfoFromIndicatorEntity(IndicatorInfo indicatorInfo, DevopsIndicatorEntity entity) {
        indicatorInfo.setDimValue((Object)entity.getDimValue());
        indicatorInfo.setDimDisplayValue(entity.getDimDisplayValue());
        if (WfUtils.isNotEmpty((String)entity.getParams())) {
            try {
                Map params = (Map)SerializationUtils.fromJsonString((String)entity.getParams(), Map.class);
                indicatorInfo.setSpecialProperty(params);
            }
            catch (Exception e) {
                logger.info("\u5e8f\u5217\u5316\u53c2\u6570\u5b57\u6bb5\u5931\u8d25\uff0c\u8be6\u60c5\uff1a" + WfUtils.getExceptionStacktrace((Throwable)e));
            }
        }
        indicatorInfo.setAddCount(entity.getAddCount());
        return indicatorInfo;
    }

    public static DevopsIndicatorEntity buildDevopsIndicatorEntity(IndicatorInfo indicatorInfo) {
        DevopsIndicatorEntityImpl entity = new DevopsIndicatorEntityImpl();
        entity.setNumber(indicatorInfo.getNumber());
        entity.setDimDisplayValue(indicatorInfo.getDimDisplayValue());
        if (indicatorInfo.getDimValue() != null) {
            entity.setDimValue(indicatorInfo.getDimValue().toString());
        }
        entity.setCreateDate(new Date());
        if (indicatorInfo.getSpecialProperty() != null) {
            entity.setParams(SerializationUtils.toJsonString((Object)indicatorInfo.getSpecialProperty()));
        }
        entity.setAddCount(indicatorInfo.getAddCount());
        return entity;
    }

    public static IndicatorInfo buildIndicatorInfoFromBehaviorCollectorEntity(IndicatorInfo indicatorInfo, BehaviorCollectorEntity entity) {
        indicatorInfo.setDimValue((Object)entity.getType());
        indicatorInfo.setDimDisplayValue(entity.getTypeName());
        indicatorInfo.setTotal(entity.getTotal());
        indicatorInfo.setDimValue((Object)entity.getType());
        indicatorInfo.setDimDisplayValue(entity.getTypeName());
        return indicatorInfo;
    }

    public static BehaviorCollectorEntity buildBehaviorCollectorEntity(IndicatorInfo indicatorInfo, String category) {
        BehaviorCollectorEntityImpl entity = new BehaviorCollectorEntityImpl();
        entity.setAppNumber(indicatorInfo.getAppNumber());
        entity.setCreateDate(new Date());
        entity.setModifyDate(new Date());
        entity.setName(indicatorInfo.getName());
        entity.setNumber(indicatorInfo.getNumber());
        if (indicatorInfo.getTotal() > 0L) {
            entity.setTotal(indicatorInfo.getTotal());
        } else {
            entity.setTotal(Long.valueOf(indicatorInfo.getAddCount()));
        }
        entity.setType(indicatorInfo.getDimValue() != null ? indicatorInfo.getDimValue().toString() : null);
        entity.setTypeName(indicatorInfo.getDimDisplayValue());
        entity.setDim(indicatorInfo.getDim());
        entity.setCategory(category);
        return entity;
    }

    public static boolean isEnableGroupsModel() {
        Object enbleIndicatorGroupsModelConf = WfConfigurationUtil.getDevopsEnbleIndicatorGroupsModel();
        if (enbleIndicatorGroupsModelConf != null) {
            return Boolean.TRUE.toString().equals(enbleIndicatorGroupsModelConf);
        }
        return Boolean.FALSE.toString().equals(LicenseServiceHelper.getPubTenantType());
    }
}

