/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.util;

import java.util.Set;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import javassist.bytecode.ClassFile;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.engine.WfUtils;

public class ClassInfoUtils {
    private static Log logger = LogFactory.getLog(ClassInfoUtils.class);

    public static Set<String> getClassRelyClass(String classPath, Set<String> set) throws NotFoundException {
        if (WfUtils.isEmpty((String)classPath)) {
            return set;
        }
        CtClass ctClass = ClassInfoUtils.getCtClass(classPath);
        if (ctClass == null) {
            return set;
        }
        ClassFile classFile = ctClass.getClassFile();
        Set classNames = classFile.getConstPool().getClassNames();
        for (String className : classNames) {
            if (className.startsWith("[L")) {
                className = className.substring(2, className.length() - 1);
            } else if (className.startsWith("[")) continue;
            className = ClassInfoUtils.getClassName(className);
            ClassInfoUtils.addClassName(set, className);
        }
        ctClass.detach();
        return set;
    }

    private static CtClass getCtClass(String classPath) throws NotFoundException {
        try {
            ClassPool classPool = new ClassPool(true);
            classPool.insertClassPath((ClassPath)new ClassClassPath(Class.forName(classPath)));
            return classPool.getCtClass(classPath);
        }
        catch (ClassNotFoundException e) {
            logger.info(e.getMessage());
            return null;
        }
    }

    private static void addClassName(Set<String> set, String className) {
        if (className.contains("kd.bos.workflow") || className.contains("kd.bos.bec")) {
            set.add(className);
        }
    }

    private static String getClassName(String className) {
        return className.replaceAll("/", ".");
    }
}

