/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.cache.PromptWordCacheNew;
import kd.bos.lang.Lang;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.workflow.devops.service.WFDevopsService;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class DevopsUtils {
    public static final String BOS_WF_DEVOPS = "bos-wf-devops";

    public static WFDevopsService getWorkflowDevopsService() {
        return (WFDevopsService)((WorkflowService)ServiceFactory.getService(WorkflowService.class)).getService(WFDevopsService.class);
    }

    public static WorkflowService getWorkflowService() {
        return (WorkflowService)ServiceFactory.getService(WorkflowService.class);
    }

    public static String millSecondConversion(Long time, String unit) {
        if (time == null || time <= 0L) {
            return "0";
        }
        double afterTime = time.doubleValue();
        switch (unit) {
            case "second": {
                afterTime /= 1000.0;
                break;
            }
            case "minute": {
                afterTime = afterTime / 1000.0 / 60.0;
                break;
            }
            case "hour": {
                afterTime = afterTime / 1000.0 / 60.0 / 60.0;
                break;
            }
        }
        BigDecimal b = BigDecimal.valueOf(afterTime);
        return b.setScale(2, 4).stripTrailingZeros().toPlainString();
    }

    public static Long converToMillSecond(Long time, String unit) {
        Long afterTime = 0L;
        if (time != null && time > 0L) {
            switch (unit) {
                case "second": {
                    afterTime = time * 1000L;
                    break;
                }
                case "minute": {
                    afterTime = time * 1000L * 60L;
                    break;
                }
                case "hour": {
                    afterTime = time * 1000L * 60L * 60L;
                    break;
                }
            }
        }
        return afterTime;
    }

    public static long getTimeDifference(Date past, Date now) {
        if (past != null && now != null) {
            return Math.abs(now.getTime() - past.getTime());
        }
        return 0L;
    }

    public static long sendAlarmMessage(ILocaleString title, ILocaleString content, String channel, List<Long> userIds) {
        return DevopsUtils.sendAlarmMessage(title, content, channel, userIds, null);
    }

    public static long sendAlarmMessage(ILocaleString title, ILocaleString content, String channel, List<Long> userIds, ILocaleString messageTag) {
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setMessageContent(content);
        messageInfo.setMessageSenderName((ILocaleString)ResManager.getLocaleString((String)"\u7cfb\u7edf\u53d1\u9001", (String)"DevopsUtils_0", (String)BOS_WF_DEVOPS));
        if (messageTag == null) {
            messageInfo.setMessageTag((ILocaleString)ResManager.getLocaleString((String)"\u6d41\u7a0b\u8fd0\u7ef4\u4e2d\u5fc3", (String)"DevopsUtils_1", (String)BOS_WF_DEVOPS));
        } else {
            messageInfo.setMessageTag(messageTag);
        }
        messageInfo.setMessageTitle(title);
        messageInfo.setMessageType("alarm");
        messageInfo.setNotifyType(channel);
        messageInfo.setOperation("auto-checking");
        messageInfo.setSenderId(Long.valueOf(0L));
        messageInfo.setSendTime(new Date());
        messageInfo.setSource("wfDevops");
        messageInfo.setUserIds(userIds);
        return MessageCenterServiceHelper.sendMessage((MessageInfo)messageInfo);
    }

    public static LocaleString getLocaleString(String description, String resourceID, String systemType, Object ... args) {
        LocaleString localeString = new LocaleString();
        for (Lang lang : Lang.values()) {
            localeString.setItem(lang.toString(), (Object)PromptWordCacheNew.getPromptWord((String)description, (String)resourceID, (Lang)lang, (String)systemType, (Object[])args));
        }
        return localeString;
    }

    public static List<Long> formatArrStrToSLongList(String str, String separator) {
        if (WfUtils.isNotEmpty((String)str)) {
            String[] receiverArr = str.split(separator);
            ArrayList<Long> userIds = new ArrayList<Long>(receiverArr.length);
            for (int i = 0; i < receiverArr.length; ++i) {
                userIds.add(Long.valueOf(receiverArr[i]));
            }
            return userIds;
        }
        return new ArrayList<Long>();
    }

    public static Date getDateOfDayBegin() {
        Date now = WfUtils.now();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getDateOfWeekBegin() {
        Date now = WfUtils.now();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        calendar.set(7, 2);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getDateOyMonthBegin() {
        Date now = WfUtils.now();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        calendar.set(calendar.get(1), calendar.get(2), 1, 0, 0, 0);
        return calendar.getTime();
    }

    public static Date getDateBeforeThreeMonths() {
        Date now = WfUtils.now();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        calendar.add(2, -3);
        return calendar.getTime();
    }
}

