/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.impl;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.workflow.devopos.ProcessNotExistPoJo;
import kd.bos.workflow.devopos.WorkflowDevopsService;
import kd.bos.workflow.devopos.info.IndicatorInfo;
import kd.bos.workflow.devops.api.IDataCapture;
import kd.bos.workflow.devops.cache.DevopsServiceCacheHelper;
import kd.bos.workflow.devops.cmd.RegistToScheduleCheckCmd;
import kd.bos.workflow.devops.entity.DevopsIndictorLibraryEntity;
import kd.bos.workflow.devops.statisticalanalysis.DataCaptureFactory;
import kd.bos.workflow.devops.statisticalanalysis.captures.OperationRedisCacheCapture;
import kd.bos.workflow.devops.statisticalanalysis.utils.CaptureUtils;
import kd.bos.workflow.devops.util.DevopsUtils;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;
import kd.bos.workflow.engine.process.ProcessInstData;

public class WorkflowDevopsServiceImpl
implements WorkflowDevopsService {
    private Log logger = LogFactory.getLog(WorkflowDevopsServiceImpl.class);

    public void registToScheduleCheck(Boolean isSuccess, String exception) {
        new RegistToScheduleCheckCmd(isSuccess, exception).execute();
    }

    public void updateMsgJobToMqData(Long jobId, String state, String error, String errinfo) {
        DynamicObject entity = BusinessDataServiceHelper.loadSingle((Object)jobId, (String)"wf_schedulemqmanage");
        entity.set("state", (Object)state);
        entity.set("errorcode", (Object)error);
        entity.set("errorinfo_tag", (Object)errinfo);
        SaveServiceHelper.update((DynamicObject)entity);
    }

    public void repairSysErrorProcessInstance() {
        DevopsUtils.getWorkflowDevopsService().repairSysErrorProcessInstance();
    }

    public void finishTestingMsgJobToMq(Long jobId) {
        DevopsUtils.getWorkflowDevopsService().finishTestingMsgJobToMq(jobId);
    }

    public void logProcessNotExist(ProcessNotExistPoJo poJo) {
        DevopsUtils.getWorkflowDevopsService().logProcessNotExist(poJo);
    }

    public void removeLog(String businessKey, String entityNumber) {
        DevopsUtils.getWorkflowDevopsService().removeLog(businessKey, entityNumber);
    }

    public void exceutionDataCollection(IndicatorInfo indicator) {
        try {
            if (WfConfigurationUtil.isEnableDevopsDataCollected()) {
                Map<String, String> disableIndicators = this.getDisableIndicator();
                if (WfUtils.isNotEmptyForMap(disableIndicators) && disableIndicators.containsKey(indicator.getNumber())) {
                    return;
                }
                IDataCapture capture = DataCaptureFactory.getDataCaptureInterface(indicator.getNumber());
                if (capture instanceof OperationRedisCacheCapture) {
                    ((OperationRedisCacheCapture)capture).capture(indicator);
                    return;
                }
                if (indicator.isNewTranstion()) {
                    DevopsUtils.getWorkflowDevopsService().saveDevopsIndicator(CaptureUtils.buildDevopsIndicatorEntity(indicator), true);
                } else {
                    DevopsUtils.getWorkflowDevopsService().saveDevopsIndicator(CaptureUtils.buildDevopsIndicatorEntity(indicator));
                }
            }
        }
        catch (Exception e) {
            this.logger.info(WfUtils.getExceptionStacktrace((Throwable)e));
        }
    }

    public void exceutionDataCollectionFromEntity(Entity entity) {
        try {
            if (WfConfigurationUtil.isEnableDevopsDataCollected()) {
                Map<String, String> disableIndicators = this.getDisableIndicator();
                Map<String, IDataCapture> capturesMap = DataCaptureFactory.getCapturesMap();
                capturesMap.forEach((key, capture) -> Optional.ofNullable(capture.build(entity)).ifPresent(info -> {
                    if (info.getNumber() != null && (WfUtils.isEmptyForMap((Map)disableIndicators) || !disableIndicators.containsKey(info.getNumber()))) {
                        DevopsUtils.getWorkflowDevopsService().saveDevopsIndicator(CaptureUtils.buildDevopsIndicatorEntity(info));
                    }
                }));
            }
        }
        catch (Exception e) {
            this.logger.info(WfUtils.getExceptionStacktrace((Throwable)e));
        }
    }

    public void batchExceutionDataCollection(List<IndicatorInfo> indicators) {
        try {
            if (WfConfigurationUtil.isEnableDevopsDataCollected()) {
                Map<String, String> disableIndicators = this.getDisableIndicator();
                List<IndicatorInfo> enableIndiactorInfos = indicators.stream().filter(info -> WfUtils.isEmptyForMap((Map)disableIndicators) || !disableIndicators.containsKey(info.getNumber())).collect(Collectors.toList());
                DevopsUtils.getWorkflowDevopsService().batchSaveIndictors(enableIndiactorInfos);
            }
        }
        catch (Exception e) {
            this.logger.info(WfUtils.getExceptionStacktrace((Throwable)e));
        }
    }

    private Map<String, String> getDisableIndicator() {
        Map<String, String> disableIndictors = DevopsServiceCacheHelper.getDisableIndictor();
        if (WfUtils.isEmptyForMap(disableIndictors)) {
            List<DevopsIndictorLibraryEntity> disableInfictors = DevopsUtils.getWorkflowDevopsService().findDisableInfictor();
            if (WfUtils.isNotEmptyForCollection(disableInfictors)) {
                disableIndictors = disableInfictors.stream().collect(Collectors.toMap(DevopsIndictorLibraryEntity::getNumber, DevopsIndictorLibraryEntity::getNumber));
            } else {
                disableIndictors.put("emptyMap", "emptyMap");
            }
            DevopsServiceCacheHelper.putDisableIndictor(disableIndictors);
        }
        return disableIndictors;
    }

    public boolean needLogProcessNotExist(String entityNumber) {
        try {
            return !DevopsUtils.getWorkflowDevopsService().existExceptedEntity(entityNumber);
        }
        catch (Throwable error) {
            this.logger.warn(error);
            return true;
        }
    }

    public Long notifySubmitterProcessNotEntered(DynamicObject businessModel, ProcessNotExistPoJo poJo) {
        try {
            return DevopsUtils.getWorkflowDevopsService().notifySubmitterProcessNotEntered(businessModel, poJo);
        }
        catch (Throwable error) {
            this.logger.warn(error);
            return 0L;
        }
    }

    public void makeProcessInst(ProcessInstData processInstData) {
        DevopsUtils.getWorkflowDevopsService().makeProcessInst(processInstData);
    }

    public void sendAlarmMessage(String scene, String group, ILocaleString title, ILocaleString content, Map<String, Object> params) {
        DevopsUtils.getWorkflowDevopsService().sendAlarmMessage(scene, group, title, content, params);
    }
}

