/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.testing;

import java.util.Date;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.control.Button;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.workflow.devops.cache.DevopsServiceCacheHelper;
import kd.bos.workflow.devops.enums.DevopsErrorCode;
import kd.bos.workflow.devops.service.WFDevopsService;
import kd.bos.workflow.devops.util.DevopsUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;

public class MqAndScheduleTestPlugin
extends AbstractFormPlugin {
    Log logger = LogFactory.getLog(MqAndScheduleTestPlugin.class);
    private static final String STATE = "state";
    private static final String PARENTID = "parentid";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"buttonap", "buttonap1", "buttonap3", "buttonap31", "buttonap32", "buttonap5", "buttonap6"});
        super.registerListener(e);
    }

    public void click(EventObject evt) {
        Button source = (Button)evt.getSource();
        String itemKey = source.getKey();
        try {
            switch (itemKey) {
                case "buttonap": {
                    this.testSchedule();
                    break;
                }
                case "buttonap1": {
                    this.testMqError();
                    break;
                }
                case "buttonap3": {
                    this.testMqSlow();
                    break;
                }
                case "buttonap31": {
                    this.testMqBlock();
                    break;
                }
                case "buttonap32": {
                    this.testMqDown();
                    break;
                }
                case "buttonap5": {
                    WFDevopsService wFDevopsService = DevopsUtils.getWorkflowDevopsService();
                    wFDevopsService.testingMqAndScheduleState();
                    break;
                }
                case "buttonap6": {
                    WfCacheHelper.removeJobSourceOfAppId((String)"ai");
                    break;
                }
            }
        }
        catch (Exception e) {
            this.logger.info(WfUtils.getExceptionStacktrace((Throwable)e));
        }
        super.click(evt);
    }

    private void testMqDown() {
        Date date = new Date(System.currentTimeMillis() - 2400000L);
        long id = DB.genGlobalLongId();
        this.saveData(id, null, "begin", null, date);
    }

    private void testMqBlock() {
        Date date = new Date(System.currentTimeMillis() - 900000L);
        long id = DB.genGlobalLongId();
        this.saveData(id, null, "begin", null, date);
    }

    private void testMqSlow() {
        Date date = new Date(System.currentTimeMillis() - 180000L);
        long id = DB.genGlobalLongId();
        this.saveData(id, null, "begin", null, date);
    }

    private void testMqError() {
        long id = DB.genGlobalLongId();
        this.saveData(id, null, "error", WfUtils.getExceptionStacktrace((Throwable)new NullPointerException("test mq error")), new Date());
        this.addNewUnUseJob(id);
    }

    private void testSchedule() {
        this.saveData(DB.genGlobalLongId(), null, "error", WfUtils.getExceptionStacktrace((Throwable)new NullPointerException("test schedule error")), new Date());
    }

    private void addNewUnUseJob(long id) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"sch_task");
        DynamicObject entity = new DynamicObject((DynamicObjectType)dataEntityType);
        entity.set("id", (Object)String.valueOf(id));
        entity.set("job", (Object)String.valueOf(id));
        entity.set("status", (Object)"COMPLETED");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{entity});
        String sql = "insert into t_sch_errorjob (fjobid, ftaskid, ferrorreason) values (?,?,?)";
        DB.execute((DBRoute)DBRoute.basedata, (String)sql, (Object[])new Object[]{String.valueOf(id), String.valueOf(id), "test mq error"});
    }

    private void saveData(long id, DevopsErrorCode code, String state, String errorStack, Date time) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"wf_schedulemqmanage");
        DynamicObject entity = new DynamicObject((DynamicObjectType)dataEntityType);
        entity.set("id", (Object)id);
        AppInfo appInfo = AppMetadataCache.getAppInfo((String)"wf");
        entity.set("appname", (Object)appInfo.getName());
        entity.set("appid", (Object)"wf");
        entity.set("startdate", (Object)time);
        entity.set(STATE, (Object)state);
        if (code != null) {
            entity.set("errorcode", (Object)code.getErrorNumber());
            entity.set("errortype", (Object)code.getErrorType());
            entity.set("errorinfo", (Object)code.getErrorDesc());
        }
        if (WfUtils.isNotEmpty((String)errorStack)) {
            entity.set("errorinfo_tag", (Object)errorStack);
        }
        Long parentId = this.getCurrentMonitorParentId();
        entity.set(PARENTID, (Object)parentId);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{entity});
    }

    protected Long getCurrentMonitorParentId() {
        String parentId = DevopsServiceCacheHelper.getMqAndScheduleMnoitorId();
        if (StringUtils.isNotBlank((CharSequence)parentId)) {
            return Long.valueOf(parentId);
        }
        Object[] entitys = BusinessDataServiceHelper.load((String)"wf_schedulemqmanage", (String)PARENTID, null, (String)"id desc", (int)1);
        Long pid = WfUtils.isNotEmptyForArrays((Object[])entitys) ? Long.valueOf(entitys[0].getLong(PARENTID)) : Long.valueOf(DB.genGlobalLongId());
        DevopsServiceCacheHelper.putMqAndScheduleMnoitorId(String.valueOf(pid));
        return pid;
    }
}

