/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.message;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.channel.cache.MsgServiceCache;
import kd.bos.message.channel.model.MsgChannelInfo;
import kd.bos.message.service.utils.MessageUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.util.PhoneI18nValidator;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.HttpClientUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.msg.ctx.MessageContext;
import kd.bos.workflow.engine.msg.handler.AbstractServiceHandler;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.bos.workflow.engine.msg.info.ToDoInfo;
import kd.bos.workflow.engine.msg.model.yzj.MessageUser;
import kd.bos.workflow.engine.msg.util.yzj.YunzhijiaToDoUtil;
import kd.bos.workflow.exception.WFErrorCode;
import kd.bos.workflow.exception.WFMessageServiceException;
import org.apache.commons.lang.math.NumberUtils;

public class WeiGouTongSMSServiceHandler
extends AbstractServiceHandler {
    private static final Log logger = LogFactory.getLog(WeiGouTongSMSServiceHandler.class);
    private static final String PARAM_ACTION = "action";
    private static final String SEND = "send";
    private static final String PARAM_ACCOUNT = "account";
    private static final String PARAM_EXTNO = "extno";
    private static final String PARAM_RT = "rt";
    private static final String JSON_STR = "json";
    private static final String PARAM_MOBILE = "mobile";
    private static final String PARAM_CONTENT = "content";
    private static final String ACCEPT = "Accept";
    private static final String ACCEPT_VAL = "application/json;charset=UTF-8";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String CONTENT_TYPE_VAL = "application/json;charset=UTF-8";
    private static final int CONNECTIONTIMEOUT = 5000;
    private static final int READTIMEOUT = 10000;
    public static final String TYPE = "weigoutongsms";

    public String getServiceType() {
        return TYPE;
    }

    public boolean inspectChannelInfo(MsgChannelInfo msgChannelInfo) {
        String weiGouTongSMSApiUrl = msgChannelInfo.getWeiGouTongSmsApiUrl();
        String weiGouTongClientId = msgChannelInfo.getWeiGouTongClientId();
        String weiGouTongClientsecret = msgChannelInfo.getWeiGouTongClientSecret();
        String weiGouTongExtNo = msgChannelInfo.getWeiGouTongExtNo();
        return WfUtils.isNotEmpty((String)weiGouTongSMSApiUrl) && WfUtils.isNotEmpty((String)weiGouTongClientId) && WfUtils.isNotEmpty((String)weiGouTongClientsecret) && WfUtils.isNotEmpty((String)weiGouTongExtNo);
    }

    protected void clearMessageUserCollection(ToDoInfo todoInfo, MessageInfo messageInfo) {
        List userIds;
        super.clearMessageUserCollection(todoInfo, messageInfo);
        if (WfUtils.isNullObject((Object)messageInfo)) {
            return;
        }
        List list = userIds = WfUtils.isNullObject((Object)todoInfo) ? messageInfo.getUserIds() : todoInfo.getUserIds();
        if (WfUtils.isEmptyForCollection((Collection)userIds)) {
            this.handlePhoneSingleBackUp(todoInfo, messageInfo);
            return;
        }
        this.handleUserIdBackUp(todoInfo, messageInfo);
    }

    public List<MessageUser> getMessageUser(MessageInfo messageInfo) {
        ArrayList backupUserIds = new ArrayList(messageInfo.getUserIds());
        List<MessageUser> messageUsers = this.getMessageUserImapping(messageInfo);
        for (MessageUser messageUser : messageUsers) {
            backupUserIds.remove(messageUser.getUserId());
        }
        if (backupUserIds.isEmpty()) {
            return messageUsers;
        }
        messageInfo.getUserIds().removeAll(backupUserIds);
        logger.debug(String.format("message user[%s] no openIds, and traceId[%s]", backupUserIds, RequestContext.get().getTraceId()));
        Map params = messageInfo.getParams();
        Map userFilter = (Map)params.get("userFilter");
        if (userFilter.containsKey("noOpenId")) {
            List noOpenUserIds = (List)userFilter.get("noOpenId");
            noOpenUserIds.addAll(backupUserIds);
        } else {
            userFilter.put("noOpenId", backupUserIds);
        }
        return messageUsers;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected List<MessageUser> getMessageUserImapping(MessageInfo message) {
        List userIds = message.getUserIds();
        ArrayList<MessageUser> messageUsers = new ArrayList<MessageUser>(userIds.size());
        if (userIds.isEmpty()) {
            Map param = message.getParams();
            Object openIds = param.get("phone");
            if (openIds == null) return messageUsers;
            List oIds = (List)openIds;
            for (String oId : oIds) {
                if (WfUtils.isEmpty((String)oId)) continue;
                PhoneI18nValidator validator = new PhoneI18nValidator(oId, false);
                String errorMsg = validator.getErrorMsg();
                if (WfUtils.isNotEmpty((String)errorMsg)) {
                    Map verifyInfo = (Map)message.getParams().get("msgVerifyInfo");
                    verifyInfo.put(oId, errorMsg);
                    continue;
                }
                messageUsers.add(new MessageUser(Long.valueOf(0L), oId, null, null));
            }
            return messageUsers;
        } else {
            try {
                QFilter[] filters = new QFilter[]{new QFilter("id", "in", (Object)userIds)};
                DynamicObjectCollection userDatas = QueryServiceHelper.query((String)"bos_user", (String)"id,phone,email,useropenid,eid", (QFilter[])filters);
                if (userDatas == null || userDatas.isEmpty()) return messageUsers;
                for (DynamicObject user : userDatas) {
                    String openId = user.getString("phone");
                    if (WfUtils.isEmpty((String)openId)) continue;
                    messageUsers.add(new MessageUser(Long.valueOf(user.getLong("id")), openId, null, null));
                }
                return messageUsers;
            }
            catch (Exception e) {
                logger.error(String.format("%s", WfUtils.getExceptionStacktrace((Throwable)e)));
            }
        }
        return messageUsers;
    }

    public void beforePostMessage(MessageInfo message) {
        String msgContent = this.getMessageUrlForFixed(message.getContent());
        message.setContent(msgContent);
    }

    public void sendMessage(MessageContext ctx, MessageInfo message) {
        try {
            super.sendMessage(ctx, message);
            kd.bos.workflow.engine.msg.util.MessageUtils.wrapMessageContent((MessageInfo)message, (String)TYPE);
            List<MessageUser> messageUsers = this.getMessageUser(message);
            if (messageUsers.isEmpty()) {
                throw new WFMessageServiceException(null, WFErrorCode.smsSendMsgError(), new Object[]{"message userIds has no openIds all"});
            }
            List messages = this.rebuildMessageInfos(message);
            if (kd.bos.workflow.engine.msg.util.MessageUtils.isBlankMessage((List)messages)) {
                logger.info("SMSServiceHandler-- messagecontent is blank");
                throw new WFMessageServiceException(null, WFErrorCode.sendMsgWithoutContentError(), new Object[0]);
            }
            this.sendServiceMessage(messages, messageUsers, true);
        }
        catch (Exception e) {
            throw new WFMessageServiceException((Throwable)e, WFErrorCode.smsSendMsgError(), new Object[]{WfUtils.getExceptionStacktrace((Throwable)e)});
        }
    }

    public Map<String, Object> postMessage(MessageInfo messageInfo, List<MessageUser> messageUsers) {
        String phones = messageUsers.stream().map(MessageUser::getOpenId).collect(Collectors.joining(","));
        return this.sendWeiGouTongSMS(phones, messageInfo.getContent());
    }

    public void createToDo(MessageContext ctx, ToDoInfo info) {
        super.createToDo(ctx, info);
        try {
            info.setUrl(info.getUrl() + "&ado=view");
            List toDoInfos = YunzhijiaToDoUtil.rebuildToDoInfo((ToDoInfo)info);
            for (ToDoInfo toDoInfo : toDoInfos) {
                List phones;
                Map<String, Object> res;
                toDoInfo.setUrl(toDoInfo.getUrl() + "&ado=view");
                String infoContent = this.getMessageUrlForFixed(toDoInfo.getContent());
                toDoInfo.setContent(infoContent);
                Map map = kd.bos.workflow.engine.msg.util.MessageUtils.getPhonesByParamsForSms((ToDoInfo)toDoInfo, null);
                Object phonesObj = null;
                if (WfUtils.isNotEmptyForMap((Map)map)) {
                    phonesObj = map.get("phones");
                }
                if (!((Boolean)(res = this.sendWeiGouTongSMS(StringUtils.join((Object[])new Object[]{",", phones = phonesObj != null ? (List)phonesObj : null}), toDoInfo.getContent())).get("result")).booleanValue()) {
                    throw new WFMessageServiceException(null, WFErrorCode.smsSendMsgError(), new Object[]{"take MessageHandler has exception " + res.get("description")});
                }
                logger.info(String.format("[%s]\u53d1\u9001\u77ed\u4fe1\u5f85\u529e\u6d88\u606f\u6210\u529f", RequestContext.get().getTraceId()));
            }
        }
        catch (Exception e) {
            logger.info(e.getMessage());
            throw new WFMessageServiceException((Throwable)e, WFErrorCode.smsSendTodoError(), new Object[]{e.getMessage()});
        }
    }

    public void dealToDo(MessageContext ctx, ToDoInfo info) {
        logger.info(String.format("nothing to do for[%s] when dealing sms todo", info.getTaskId()));
    }

    public void deleteToDo(MessageContext ctx, ToDoInfo info) {
        logger.info(String.format("nothing to do for[%s] when deleting sms todo", info.getTaskId()));
    }

    private boolean isUserPhoneInternational(String phone) {
        if (WfUtils.isEmpty((String)phone) || !phone.contains("-")) {
            return Boolean.FALSE;
        }
        String[] num = phone.split("-");
        if (num.length < NumberUtils.INTEGER_ONE || Objects.equals(num[NumberUtils.INTEGER_ZERO], "86")) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private void handlePhoneSingleBackUp(ToDoInfo todoInfo, MessageInfo messageInfo) {
        Map params;
        boolean isMsg = WfUtils.isNullObject((Object)todoInfo);
        Map map = params = isMsg ? messageInfo.getParams() : todoInfo.getParams();
        if (WfUtils.isEmptyForMap((Map)params) || !params.containsKey("phone")) {
            return;
        }
        Object phoneObj = params.get("phone");
        if (!(phoneObj instanceof List)) {
            return;
        }
        List phone = (List)phoneObj;
        Map<Boolean, List<String>> collect = phone.stream().collect(Collectors.groupingBy(this::isUserPhoneInternational));
        List<String> afterClearPhones = collect.get(Boolean.FALSE);
        params.put("phone", afterClearPhones);
        List<String> backupUserPhones = collect.get(Boolean.TRUE);
        this.handleBackUpParam(messageInfo, "internationalPhoneNumbers", backupUserPhones);
    }

    private void handleUserIdBackUp(ToDoInfo todoInfo, MessageInfo messageInfo) {
        Map map = kd.bos.workflow.engine.msg.util.MessageUtils.getPhonesByParamsForSms((ToDoInfo)todoInfo, (MessageInfo)messageInfo);
        if (WfUtils.isEmptyForMap((Map)map) || !map.containsKey("useridAndPhone")) {
            return;
        }
        Object uIdAndPhoneObj = map.get("useridAndPhone");
        if (!(uIdAndPhoneObj instanceof Map)) {
            return;
        }
        Map uIdAndPhone = (Map)uIdAndPhoneObj;
        Map collect = uIdAndPhone.entrySet().stream().collect(Collectors.groupingBy(t -> this.isUserPhoneInternational((String)t.getKey()), Collectors.mapping(Map.Entry::getValue, Collectors.toList())));
        List afterClearUserIds = collect.get(Boolean.FALSE);
        List backupUserIds = collect.get(Boolean.TRUE);
        if (WfUtils.isNotNullObject((Object)todoInfo)) {
            todoInfo.setUserIds(afterClearUserIds);
            return;
        }
        messageInfo.setUserIds(afterClearUserIds);
        this.handleBackUpParam(messageInfo, "internationalPhoneNumbersUsers", backupUserIds);
    }

    private <T> void handleBackUpParam(MessageInfo messageInfo, String key, List<T> backup) {
        if (WfUtils.isEmptyForCollection(backup)) {
            return;
        }
        Map params = messageInfo.getParams();
        if (WfUtils.isNullObject((Object)params)) {
            params = Maps.newHashMapWithExpectedSize((int)NumberUtils.INTEGER_ONE);
            messageInfo.setParams(params);
        }
        Map userFilter = params.getOrDefault("userFilter", Maps.newHashMapWithExpectedSize((int)NumberUtils.INTEGER_ONE));
        List internationalPhone = userFilter.getOrDefault("internationalPhoneNumbers", Lists.newArrayListWithExpectedSize((int)backup.size()));
        internationalPhone.addAll(backup);
        userFilter.put(key, internationalPhone);
        params.put("userFilter", userFilter);
    }

    private String getMessageUrlForFixed(String content) {
        String[] contentParams = content.split("http");
        StringBuilder msgNewContent = new StringBuilder(contentParams[0]);
        if (contentParams.length > 1) {
            for (int i = 1; i < contentParams.length; ++i) {
                String data = "http" + contentParams[i];
                String u = WeiGouTongSMSServiceHandler.findUrlByStr(data);
                String uNew = WeiGouTongSMSServiceHandler.wrapUrl(u);
                int startIndex = data.indexOf(u);
                String s1 = data.substring(0, startIndex);
                String s2 = data.substring(startIndex + u.length(), data.length());
                String pNew = s1 + uNew + s2;
                msgNewContent.append(pNew);
            }
        }
        return msgNewContent.toString();
    }

    private static String wrapUrl(String url) {
        StringBuilder sb = new StringBuilder();
        String[] params = url.split("&");
        for (int i = 0; i < params.length; ++i) {
            String p = params[i];
            if (p.contains("pCaption") || p.contains("mCaption")) continue;
            if (i != params.length - 1) {
                sb.append(p).append('&');
                continue;
            }
            sb.append(p);
        }
        String urlNew = sb.toString();
        urlNew = urlNew.endsWith("&") ? urlNew.substring(0, urlNew.length() - 1) : urlNew;
        return urlNew;
    }

    private static String findUrlByStr(String data) {
        Pattern pattern = Pattern.compile("https?://[-A-Za-z0-9+&@#/%?=~_|!:,.;]+[-A-Za-z0-9+&@#/%=~_|]");
        Matcher matcher = pattern.matcher(data);
        if (matcher.find()) {
            return matcher.group();
        }
        return "";
    }

    private static Map<String, Object> getWeiGouTongPostBody(MsgChannelInfo msgChannelInfo, String allPhone, String encodeContent) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)PARAM_ACTION, (Object)SEND);
        builder.put((Object)PARAM_ACCOUNT, (Object)msgChannelInfo.getWeiGouTongClientId());
        builder.put((Object)"password", (Object)msgChannelInfo.getWeiGouTongClientSecret());
        builder.put((Object)PARAM_EXTNO, (Object)msgChannelInfo.getWeiGouTongExtNo());
        builder.put((Object)PARAM_RT, (Object)JSON_STR);
        builder.put((Object)PARAM_MOBILE, (Object)allPhone);
        builder.put((Object)PARAM_CONTENT, (Object)encodeContent);
        return builder.build();
    }

    private Map<String, Object> sendWeiGouTongSMS(String phones, String content) {
        logger.debug("sendWeiGouTongShortMessage--into messageHandler begine start");
        ImmutableMap header = ImmutableMap.of((Object)ACCEPT, (Object)"application/json;charset=UTF-8", (Object)CONTENT_TYPE, (Object)"application/json;charset=UTF-8");
        MsgChannelInfo msgChannelInfo = MsgServiceCache.getMsgChannel((String)"sms");
        try {
            Map<String, Object> body = WeiGouTongSMSServiceHandler.getWeiGouTongPostBody(msgChannelInfo, phones, content);
            logger.debug("weiGouTong sms everything is ready, go !!!");
            String urlPart = msgChannelInfo.getWeiGouTongSmsApiUrl();
            String result = HttpClientUtils.post((String)urlPart, (Map)header, body, (int)5000, (int)10000);
            logger.debug("weiGouTong sms result : " + result);
        }
        catch (Exception e) {
            logger.warn(MessageFormat.format("push weiGouTong sms is error [{0}]", kd.bos.message.utils.MessageUtils.getExceptionStacktrace((Throwable)e)));
            return MessageUtils.wrapResult((String)e.getMessage());
        }
        return MessageUtils.wrapResult((String)"success");
    }
}

