/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bak;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.AbstractMobBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.utils.MobileFormInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.metadata.entity.Entity;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.SubEntryEntity;
import kd.bos.metadata.entity.businessfield.AmountField;
import kd.bos.metadata.entity.commonfield.DateField;
import kd.bos.metadata.entity.commonfield.DateTimeField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.StringUtils;
import kd.bos.workflow.engine.BillPagePluginUtil;
import kd.bos.workflow.engine.WFMultiLangConstants;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;
import kd.bos.workflow.taskcenter.plugin.util.ApprovalPluginUtil;
import kd.bos.workflow.taskcenter.plugin.util.PictureResourceEnum;

public class WfBillSummaryMob
extends AbstractMobBillPlugIn
implements RowClickEventListener {
    private Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private static final String MOBILECONTAINER = "mobilecontainer";
    private static final String MOBILECONTAINER_HIDE = "mobilecontainer_hide";
    private static final String FLEXPANELAP_ATTACHMENT = "flexpanelap_attachment";
    private static final String ENTRYENTITYFORATTACHMENT = "entryentity_attachment";
    private static final String ATTACHMENT_PICTUREFIELD = "picturefield_attachment";
    private static final String ATTACHMENT_TEXTFIELD_NAME = "textfield_name_attachment";
    private static final String ATTACHMENT_TEXTFIELD_SIZE = "textfield_size_attachment";
    private static final String FLEXPANELAP_ENTRYINFO = "flexpanelap_entryinfo";
    private static final String BUTTONAP_BILLDETAIL = "buttonap_billdetail";
    private static final String FLEXPANELAP_APPLIERINFO = "flexpanelap_applierinfo";
    private static final String ENTRYENTITY_APPLIER = "entryentity_applier";
    private static final String PICTUREFIELD_APPLIER = "picturefield_applier";
    private static final String TEXTFIELD_APPLIER_NAME = "textfield_applier_name";
    private static final String TEXTFIELD_APPLIER_ORG = "textfield_applier_org";
    private static final String FLEXPANELAP_NOTIFY = "flexpanelap_notify";
    private static final String NOTIFY_VIEW_MORE = "notifyviewmore";
    private static final String NOTIFY_VIEW_LESS = "notifyviewless";
    private static final String FILEID = "fileId";
    private static final String FILENAME = "fileName";
    private static final String FILESIZE = "fileSize";
    private static final String FILEEXT = "fileExt";
    private static final String FILETIME = "fileTime";
    private static final String FILESHOWBYINSTRUCTIONS = "fileShowByInstructions";
    private static final String DOWNLOADURL = "downloadUrl";
    private static final int DEFAULTCOUNT = 8;
    private static final String BUSINESSNUMBER = "businessNumber";
    private static final String BUSINESSPKID = "businessPkId";
    private static final String BILLSUMMARYNUMBER = "billSummaryNumber";
    private static final String CLOSECALLBACK = "closeCallBack";
    private static final String ENTITYKEY = "entitykey";
    private static final String ENTITYNAME = "entityname";
    private static final String ENTITYTITLES = "entitytitles";
    private static final String BOSMOBILEFORMCONFIG = "bos_mobileformconfig";
    private static final String BILLTYPEID = "billtype_Id";
    private static final String GRIDTITLE = "gridtitle";
    private static final String FIELDKEY = "fieldkey";
    private static final String ENTRYNAME = "entryName";
    private static final String FIELDS = "fields";
    private static final String ENTRYLOCATION = "entrylocation";
    private static final String FONTCOLOR = "fontcolor";
    private static final String FONTSIZE = "fontsize";
    private static final String FIELDPERCENT = "fieldpercent";
    private static final String ISHEADFIELD = "isheadfield";
    private static final String GOHEADER = "goHeader";

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        JSONObject jsonObj;
        MobileFormInfo utis;
        FormShowParameter showParameter = (FormShowParameter)e.getSource();
        FlexPanelAp uiHeadMeta = new FlexPanelAp();
        uiHeadMeta.setKey("headAp");
        FlexPanelAp uiHeadMetaHide = new FlexPanelAp();
        uiHeadMetaHide.setKey("headApHide");
        if (showParameter.getCustomParam(CLOSECALLBACK) instanceof JSONObject && (utis = (MobileFormInfo)JSONObject.toJavaObject((JSON)(jsonObj = (JSONObject)showParameter.getCustomParam(CLOSECALLBACK)), MobileFormInfo.class)).getCallBackClass().containsKey("className")) {
            try {
                Class<?> clazz = Class.forName((String)utis.getCallBackClass().get("className"));
                utis.setCallBack((ICloseCallBack)clazz.newInstance());
            }
            catch (Exception e1) {
                this.getView().showErrorNotification(e1.getMessage());
            }
        }
        FlexPanelAp flexApGridMeta = new FlexPanelAp();
        flexApGridMeta.setKey("flexapgrids");
        String number = (String)showParameter.getCustomParam(BUSINESSNUMBER);
        String billId = (String)showParameter.getCustomParam(BUSINESSPKID);
        String billSummaryNumber = (String)showParameter.getCustomParam(BILLSUMMARYNUMBER);
        if (number != null) {
            this.createMetaNotByConfig1(uiHeadMeta, uiHeadMetaHide, flexApGridMeta, number, (List)showParameter.getCustomParam("disVisbleNumber"), billId, billSummaryNumber);
        }
        showParameter.setCustomParam("schemeDesign", (Object)Boolean.TRUE);
        HashMap<String, String> mapHead = new HashMap<String, String>();
        mapHead.put("id", MOBILECONTAINER);
        mapHead.put("items", (String)uiHeadMeta.createControl().get("items"));
        e.getItems().add(mapHead);
        HashMap<String, String> mapHeadHide = new HashMap<String, String>();
        mapHeadHide.put("id", MOBILECONTAINER_HIDE);
        mapHeadHide.put("items", (String)uiHeadMetaHide.createControl().get("items"));
        e.getItems().add(mapHeadHide);
        HashMap<String, String> mapEntry = new HashMap<String, String>();
        mapEntry.put("id", "flexentryentity");
        mapEntry.put("items", (String)flexApGridMeta.createControl().get("items"));
        e.getItems().add(mapEntry);
    }

    public void createNewData(BizDataEventArgs e) {
        MobileFormShowParameter showParameter = (MobileFormShowParameter)this.getView().getFormShowParameter();
        String billId = (String)showParameter.getCustomParam(BUSINESSNUMBER);
        if (billId != null) {
            this.loadDataByNoConfig(e);
        } else {
            this.loadData(e);
        }
    }

    private void loadDataByNoConfig(BizDataEventArgs e) {
        DynamicObject summarymobData = new DynamicObject((DynamicObjectType)this.getModel().getDataEntityType());
        MobileFormShowParameter showParameter = (MobileFormShowParameter)this.getView().getFormShowParameter();
        String pkId = (String)showParameter.getCustomParam(BUSINESSPKID);
        String billId = (String)showParameter.getCustomParam(BUSINESSNUMBER);
        String billSummaryNumber = (String)showParameter.getCustomParam(BILLSUMMARYNUMBER);
        if (pkId != null) {
            DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)billId);
            List<String> entityName = this.getEntryName(billSummaryNumber);
            boolean goHead = this.getHeader(pkId, billId, entityName);
            this.setValue(bill.getDataEntityType(), summarymobData, bill, billId, entityName, billSummaryNumber);
            if (goHead && entityName.size() <= 1) {
                DynamicObjectCollection col = (DynamicObjectCollection)bill.get(entityName.get(0));
                DynamicObject dyn = (DynamicObject)col.get(0);
                this.setValue(dyn.getDataEntityType(), summarymobData, dyn, billId, entityName, billSummaryNumber);
                this.getView().setVisible(Boolean.FALSE, new String[]{FLEXPANELAP_ENTRYINFO});
            } else {
                ArrayList entityTitles = new ArrayList(entityName.size());
                for (String eName : entityName) {
                    DynamicObjectCollection rows = (DynamicObjectCollection)summarymobData.get(eName);
                    rows.addAll((Collection)bill.get(eName));
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put(ENTITYKEY, eName);
                    map.put(ENTITYNAME, ((IDataEntityProperty)bill.getDataEntityType().getProperties().get((Object)eName)).getDisplayName().getLocaleValue());
                    entityTitles.add(map);
                }
                this.getPageCache().put(ENTITYTITLES, SerializationUtils.toJsonString(entityTitles));
            }
            e.setDataEntity((Object)summarymobData);
        } else {
            this.getView().showErrorNotification(WFMultiLangConstants.getEntityNullTip());
        }
    }

    public void setValue(IDataEntityType type, DynamicObject target, DynamicObject src, String number, List<String> entryNames, String billSummaryNumber) {
        List<String> fields = this.getFields(billSummaryNumber);
        DataEntityPropertyCollection dc = type.getProperties();
        String relateOrg = null;
        for (IDataEntityProperty p : dc) {
            if (p == null) continue;
            String pName = p.getName();
            try {
                if (!fields.contains(pName)) continue;
                if (DateProp.class.isInstance(p) && WfUtils.isNotEmpty((String)(relateOrg = ((DateProp)p).getRelateOrg())) && null == target.get(relateOrg)) {
                    target.set(relateOrg, src.get(relateOrg));
                }
                target.set(pName, src.get(pName));
            }
            catch (Exception e1) {
                this.log.error(e1.getMessage());
            }
        }
    }

    private void loadData(BizDataEventArgs e) {
        MobileFormShowParameter showParameter = (MobileFormShowParameter)this.getView().getFormShowParameter();
        DynamicObject mobileConfig = BusinessDataServiceHelper.loadSingle((Object)showParameter.getCustomParam("mobileConfigId"), (String)BOSMOBILEFORMCONFIG);
        Object pkId = this.getPkId(mobileConfig.getString(BILLTYPEID));
        if (pkId != null) {
            DynamicObject dataEntity = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)mobileConfig.getString(BILLTYPEID));
            e.setDataEntity((Object)dataEntity);
        } else {
            this.getView().showErrorNotification(WFMultiLangConstants.getEntityNullTip());
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Object customParam = this.getView().getFormShowParameter().getCustomParam("schemeDesign");
        if (customParam.equals(Boolean.TRUE)) {
            FlexPanelAp uiHeadMeta = new FlexPanelAp();
            uiHeadMeta.setKey("headAp");
            FlexPanelAp uiHeadMetaHide = new FlexPanelAp();
            uiHeadMetaHide.setKey("headApHide");
            FlexPanelAp flexApGridMeta = new FlexPanelAp();
            flexApGridMeta.setKey("flexapgrids");
            FormShowParameter showParameter = this.getView().getFormShowParameter();
            String number = (String)showParameter.getCustomParam(BUSINESSNUMBER);
            String billId = (String)showParameter.getCustomParam(BUSINESSPKID);
            if (showParameter.getCustomParam(CLOSECALLBACK) instanceof JSONObject) {
                JSONObject jsonObj = (JSONObject)showParameter.getCustomParam(CLOSECALLBACK);
                JSONObject.toJavaObject((JSON)jsonObj, MobileFormInfo.class);
            }
            Integer showCount = null;
            if (number != null) {
                String billSummaryNumber = (String)showParameter.getCustomParam(BILLSUMMARYNUMBER);
                showCount = this.createMetaNotByConfig1(uiHeadMeta, uiHeadMetaHide, flexApGridMeta, number, (List)showParameter.getCustomParam("disVisbleNumber"), billId, billSummaryNumber);
                this.getPageCache().put("showCount", showCount.toString());
            }
            this.showOtherComponent(showCount, Boolean.FALSE);
            String entityTitles = this.getPageCache().get(ENTITYTITLES);
            if (entityTitles != null) {
                List list = SerializationUtils.fromJsonStringToList((String)entityTitles, Map.class);
                ArrayList<ComboItem> modelItems = new ArrayList<ComboItem>(list.size());
                String defaultGridValue = null;
                boolean flag = true;
                for (Map map : list) {
                    String entryKey = (String)map.get(ENTITYKEY);
                    modelItems.add(new ComboItem(new LocaleString((String)map.get(ENTITYNAME)), entryKey));
                    if (flag) {
                        defaultGridValue = (String)map.get(ENTITYKEY);
                        flag = false;
                        this.getView().setVisible(Boolean.TRUE, new String[]{entryKey});
                        continue;
                    }
                    this.getView().setVisible(Boolean.FALSE, new String[]{entryKey});
                }
                ComboEdit comboEdit = (ComboEdit)this.getView().getControl(GRIDTITLE);
                comboEdit.setComboItems(modelItems);
                this.getModel().setValue(GRIDTITLE, defaultGridValue);
                if (list.size() == 1) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{GRIDTITLE});
                } else {
                    HashMap<String, Integer> prop = new HashMap<String, Integer>(1);
                    prop.put("l", 0);
                    this.getView().updateControlMetadata(GRIDTITLE, prop);
                }
            }
            Container c = (Container)this.getControl(MOBILECONTAINER);
            c.getItems().addAll(((Container)uiHeadMeta.buildRuntimeControl()).getItems());
            this.getView().createControlIndex(c.getItems());
            Container cHide = (Container)this.getControl(MOBILECONTAINER_HIDE);
            cHide.getItems().addAll(((Container)uiHeadMetaHide.buildRuntimeControl()).getItems());
            this.getView().createControlIndex(cHide.getItems());
            Container flexentryentity = (Container)this.getControl("flexentryentity");
            List controls = ((Container)flexApGridMeta.buildRuntimeControl()).getItems();
            if (controls != null && !controls.isEmpty()) {
                for (Control fieldEdit : controls) {
                    EntryGrid entryGrid = (EntryGrid)fieldEdit;
                    entryGrid.setEntryKey(entryGrid.getKey());
                    flexentryentity.getItems().add(entryGrid);
                }
            }
            if (showCount != null && showCount > 8 || controls == null || controls.isEmpty()) {
                this.getView().setVisible(Boolean.FALSE, new String[]{FLEXPANELAP_ENTRYINFO});
            }
            this.getView().createControlIndex(flexentryentity.getItems());
            this.setEntryEntityForApplier();
        }
    }

    private void createEntry(FlexPanelAp uiContainerMeta, String entryKey, Map<String, EntryAp> entryMap) {
        EntryAp uiMetaEntry = new EntryAp();
        uiMetaEntry.setKey(entryKey);
        uiMetaEntry.setId(entryKey);
        uiMetaEntry.setEntryId(entryKey);
        uiMetaEntry.setShrink(0);
        uiMetaEntry.setGrow(0);
        entryMap.put(entryKey, uiMetaEntry);
        uiContainerMeta.getItems().add(uiMetaEntry);
    }

    private DynamicObjectCollection getDynConfig(String formNumber) {
        QFilter filter = new QFilter("number", "=", (Object)formNumber);
        DynamicObject idObj = QueryServiceHelper.queryOne((String)BOSMOBILEFORMCONFIG, (String)"id", (QFilter[])new QFilter[]{filter});
        if (null == idObj) {
            return null;
        }
        DynamicObject doj = BusinessDataServiceHelper.loadSingle((Object)idObj.getLong("id"), (String)BOSMOBILEFORMCONFIG);
        DynamicObjectCollection entryCollections = null;
        if (doj != null) {
            entryCollections = doj.getDynamicObjectCollection("entryentity");
            entryCollections.sort(new Comparator(){

                public int compare(Object o1, Object o2) {
                    DynamicObject d1 = (DynamicObject)o1;
                    DynamicObject d2 = (DynamicObject)o2;
                    return d1.getInt("seq") - d2.getInt("seq");
                }
            });
        }
        return entryCollections;
    }

    private Integer createMetaNotByConfig1(FlexPanelAp uiHeadMeta, FlexPanelAp uiHeadMetaHide, FlexPanelAp flexApGrids, String number, List<String> disVisibleNumbers, String billId, String billSummaryNumber) {
        Integer showCount = 0;
        List<String> entrys = this.getEntryName(billSummaryNumber);
        ArrayList<String> fields = new ArrayList<String>();
        DynamicObjectCollection dynamicObjectCollection = this.getDynConfig(billSummaryNumber);
        HashMap<String, DynamicObject> keyDynCollections = new HashMap<String, DynamicObject>();
        if (dynamicObjectCollection != null) {
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                keyDynCollections.put(dynamicObject.getString(FIELDKEY), dynamicObject);
                fields.add(dynamicObject.getString(FIELDKEY));
            }
            if (this.getPageCache() != null) {
                this.getPageCache().put(ENTRYNAME, SerializationUtils.toJsonString(entrys));
                this.getPageCache().put(FIELDS, SerializationUtils.toJsonString(fields));
            }
        }
        boolean goHeader = this.getHeader(billId, number, entrys);
        MetadataReader reader = new MetadataReader();
        String fid = reader.loadIdByNumber(number, MetaCategory.Entity);
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)fid, (MetaCategory)MetaCategory.Entity);
        List entities = entityMetadata.getRootEntity().getItems();
        int colSize = 8;
        DynamicObject dyn = null;
        HashMap<String, EntryAp> entryApMap = new HashMap<String, EntryAp>();
        for (String key : fields) {
            Integer n;
            Integer n2;
            dyn = (DynamicObject)keyDynCollections.get(key);
            String entryLocation = dyn.getString(ENTRYLOCATION);
            if (WfUtils.isNotEmpty((String)entryLocation) && entrys.contains(entryLocation)) {
                EntryAp entryAp = null;
                if (entryApMap.get(entryLocation) == null && !goHeader) {
                    entryAp = new EntryAp();
                    String entryId = this.getEntryIdByKey(entryLocation, entityMetadata);
                    entryAp.setId(entryId);
                    entryAp.setKey(entryLocation);
                    entryAp.setName(new LocaleString(entryLocation));
                    entryAp.setParentId(flexApGrids.getId());
                    flexApGrids.getItems().add(entryAp);
                    entryApMap.put(entryLocation, entryAp);
                } else {
                    entryAp = (EntryAp)entryApMap.get(entryLocation);
                }
                EntityItem<?> enItem = this.findEntityItem(entities, entryLocation);
                if (enItem != null) {
                    EntryEntity entry = (EntryEntity)enItem;
                    if ((enItem = this.findEntityItem(entry.getItems(), key)) != null) {
                        if (goHeader && entrys.size() <= 1) {
                            Integer n3;
                            Integer n4;
                            if (showCount < 8) {
                                this.addDynamicFieldAp(enItem, uiHeadMeta);
                                n4 = showCount;
                                n3 = showCount = Integer.valueOf(showCount + 1);
                                continue;
                            }
                            this.addDynamicFieldAp(enItem, uiHeadMetaHide);
                            n4 = showCount;
                            n3 = showCount = Integer.valueOf(showCount + 1);
                            continue;
                        }
                        this.addDynamicEntryFiledAp(colSize, entryLocation, enItem, entryAp, dyn);
                        continue;
                    }
                    this.log.error(key + " not found!");
                    continue;
                }
                this.log.error(entryLocation + " not found!");
                continue;
            }
            EntityItem<?> enItem = this.findEntityItem(entities, key);
            if (enItem == null) continue;
            if (showCount < 8) {
                this.addDynamicFieldAp(enItem, uiHeadMeta);
                n2 = showCount;
                n = showCount = Integer.valueOf(showCount + 1);
                continue;
            }
            this.addDynamicFieldAp(enItem, uiHeadMetaHide);
            n2 = showCount;
            n = showCount = Integer.valueOf(showCount + 1);
        }
        return showCount;
    }

    private String getEntryIdByKey(String entryKey, EntityMetadata entityMetadata) {
        String entryId = null;
        List entries = entityMetadata.getEntitys();
        for (Entity entry : entries) {
            if (!entryKey.equals(entry.getKey())) continue;
            entryId = entry.getId();
            break;
        }
        return entryId;
    }

    private void addDynamicEntryFiledAp(int size, String entryKey, EntityItem<?> item, EntryAp uiContainerMeta, DynamicObject config) {
        String fieldkey = item.getKey();
        EntryFieldAp entryFldAp = new EntryFieldAp();
        entryFldAp.setId(fieldkey);
        entryFldAp.setKey(fieldkey);
        entryFldAp.setName(item.getName());
        entryFldAp.setFireUpdEvt(false);
        entryFldAp.setNoDisplayScaleZero(true);
        if (item instanceof DateField || item instanceof DateTimeField) {
            entryFldAp.setDisplayFormatString("YYYY-MM-DD");
            entryFldAp.setFieldForeColor("#707070");
        } else if (item instanceof AmountField) {
            entryFldAp.setNoDisplayScaleZero(false);
            ((AmountField)item).setScale(2);
        }
        if (config != null && StringUtils.isNotEmpty((String)config.getString(FONTCOLOR))) {
            entryFldAp.setFieldForeColor(config.getString(FONTCOLOR));
        } else {
            entryFldAp.setFieldForeColor("#4c4c4c");
        }
        if (config != null && config.getInt(FONTSIZE) != 0) {
            entryFldAp.setFieldFontSize(config.getInt(FONTSIZE));
        } else {
            entryFldAp.setFieldFontSize(11);
        }
        entryFldAp.setFieldTextAlign("center");
        entryFldAp.setField((Field)item);
        entryFldAp.setShowTitle(false);
        LocaleString width = new LocaleString();
        LocaleString height = new LocaleString();
        if (size == 6 || size == 8) {
            if (config != null && StringUtils.isNotEmpty((String)config.getString(FIELDPERCENT))) {
                width.setLocaleValue(config.getString(FIELDPERCENT));
            }
            height.setLocaleValue("50%");
        }
        if (WfUtils.isNotEmpty((String)width.getLocaleValue())) {
            entryFldAp.setWidth(width);
        }
        entryFldAp.setHeight(height);
        uiContainerMeta.getItems().add(entryFldAp);
    }

    private EntityItem<?> findEntityItem(List<EntityItem<?>> entities, String key) {
        for (EntityItem<?> item : entities) {
            if (!item.getKey().equalsIgnoreCase(key)) continue;
            return item;
        }
        return null;
    }

    private void createMeta(FlexPanelAp uiHeadMeta, FlexPanelAp uiContainerMeta, FormShowParameter showParameter) {
        DynamicObject mobileConfig = BusinessDataServiceHelper.loadSingle((Object)showParameter.getCustomParam("mobileConfigId"), (String)BOSMOBILEFORMCONFIG);
        String number = mobileConfig.getString(BILLTYPEID);
        MetadataReader reader = new MetadataReader();
        String fid = reader.loadIdByNumber(number, MetaCategory.Entity);
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)fid, (MetaCategory)MetaCategory.Entity);
        List entities = entityMetadata.getRootEntity().getItems();
        HashMap<String, EntryAp> entryMap = new HashMap<String, EntryAp>();
        HashMap<String, Integer> fieldIndex = new HashMap<String, Integer>();
        HashMap<String, Integer> entryFieldNumber = new HashMap<String, Integer>();
        for (EntityItem entityItem : entities) {
            if (!(entityItem instanceof EntryEntity)) continue;
            this.createEntry(uiContainerMeta, entityItem.getKey(), entryMap);
            fieldIndex.put(entityItem.getKey(), 1);
            entryFieldNumber.put(entityItem.getKey(), 0);
        }
        DynamicObjectCollection entries = mobileConfig.getDynamicObjectCollection("entryentity");
        FieldAp fieldAp = null;
        for (DynamicObject dynamicObject : entries) {
            String entryKey = dynamicObject.getString(ENTRYLOCATION);
            if (dynamicObject.getBoolean(ISHEADFIELD)) continue;
            entryFieldNumber.put(entryKey, (Integer)entryFieldNumber.get(entryKey) + 1);
        }
        for (DynamicObject object : entries) {
            String fieldkey = object.getString(FIELDKEY);
            String entryKey = object.getString(ENTRYLOCATION);
            if (object.getBoolean(ISHEADFIELD)) {
                fieldAp = new FieldAp();
                fieldAp.setId(fieldkey);
                fieldAp.setKey(fieldkey);
                fieldAp.setName(new LocaleString(object.getString("fieldname")));
                fieldAp.setBackColor("#FFFFFF");
                for (EntityItem entity : entities) {
                    if (!(entity instanceof Field) || !fieldkey.equals(entity.getKey())) continue;
                    fieldAp.setField((Field)entity);
                }
                uiHeadMeta.getItems().add(fieldAp);
                continue;
            }
            EntryFieldAp entryFldAp = new EntryFieldAp();
            entryFldAp.setId(fieldkey);
            entryFldAp.setKey(fieldkey);
            object.getString("fieldtype");
            entryFldAp.setName(new LocaleString(object.getString("fieldname")));
            entryFldAp.setFireUpdEvt(false);
            for (EntityItem entity : entities) {
                if (!(entity instanceof EntryEntity)) continue;
                EntryEntity entry = (EntryEntity)entity;
                int size = (Integer)entryFieldNumber.get(entryKey) > 6 ? 6 : (Integer)entryFieldNumber.get(entryKey);
                for (EntityItem item : entry.getItems()) {
                    if (!fieldkey.equals(item.getKey()) || item instanceof SubEntryEntity) continue;
                    if ((Integer)fieldIndex.get(entryKey) < 7) {
                        if (item instanceof DateField || item instanceof DateTimeField) {
                            entryFldAp.setDisplayFormatString("MM-dd");
                            entryFldAp.setFieldForeColor("#707070");
                        } else if (item instanceof AmountField) {
                            entryFldAp.setNoDisplayScaleZero(true);
                        }
                        if (!StringUtils.isBlank((String)object.getString(FONTCOLOR))) {
                            entryFldAp.setFieldForeColor(object.getString(FONTCOLOR));
                        } else {
                            entryFldAp.setFieldForeColor("#4c4c4c");
                        }
                        if (object.getInt(FONTSIZE) > 0) {
                            entryFldAp.setFontSize(object.getInt(FONTSIZE));
                            entryFldAp.setFieldFontSize(object.getInt(FONTSIZE));
                        } else {
                            entryFldAp.setFontSize(16);
                            entryFldAp.setFieldFontSize(16);
                        }
                        entryFldAp.setFieldTextAlign("center");
                        entryFldAp.setField((Field)item);
                        entryFldAp.setShowTitle(false);
                        LocaleString width = new LocaleString();
                        LocaleString height = new LocaleString();
                        switch (size) {
                            case 1: {
                                if (!StringUtils.isBlank((String)object.getString(FIELDPERCENT))) {
                                    width.setLocaleValue(object.getString(FIELDPERCENT));
                                } else {
                                    width.setLocaleValue("100%");
                                }
                                height.setLocaleValue("100%");
                                break;
                            }
                            case 2: {
                                if (!StringUtils.isBlank((String)object.getString(FIELDPERCENT))) {
                                    width.setLocaleValue(object.getString(FIELDPERCENT));
                                } else {
                                    width.setLocaleValue("50%");
                                }
                                height.setLocaleValue("100%");
                                break;
                            }
                            case 4: {
                                if (!StringUtils.isBlank((String)object.getString(FIELDPERCENT))) {
                                    width.setLocaleValue(object.getString(FIELDPERCENT));
                                } else {
                                    width.setLocaleValue("50%");
                                }
                                height.setLocaleValue("50%");
                                break;
                            }
                            case 3: {
                                if (!StringUtils.isBlank((String)object.getString(FIELDPERCENT))) {
                                    width.setLocaleValue(object.getString(FIELDPERCENT));
                                } else {
                                    width.setLocaleValue("33.3%");
                                }
                                height.setLocaleValue("100%");
                                break;
                            }
                            case 5: {
                                if (!StringUtils.isBlank((String)object.getString(FIELDPERCENT))) {
                                    width.setLocaleValue(object.getString(FIELDPERCENT));
                                } else {
                                    width.setLocaleValue("33.3%");
                                }
                                if ((Integer)fieldIndex.get(entryKey) == 3) {
                                    height.setLocaleValue("60%");
                                    Style style = new Style();
                                    Padding padding = new Padding();
                                    padding.setTop("12%");
                                    style.setPadding(padding);
                                    entryFldAp.setStyle(style);
                                    break;
                                }
                                height.setLocaleValue("33%");
                                break;
                            }
                            case 6: {
                                if (!StringUtils.isBlank((String)object.getString(FIELDPERCENT))) {
                                    width.setLocaleValue(object.getString(FIELDPERCENT));
                                } else {
                                    width.setLocaleValue("33.3%");
                                }
                                height.setLocaleValue("50%");
                                break;
                            }
                        }
                        entryFldAp.setHeight(height);
                        entryFldAp.setWidth(width);
                    } else {
                        entryFldAp.setField((Field)item);
                        entryFldAp.setVisible("");
                    }
                    fieldIndex.put(entryKey, (Integer)fieldIndex.get(entryKey) + 1);
                }
            }
            ((EntryAp)entryMap.get(entryKey)).getItems().add(entryFldAp);
        }
    }

    private Object getPkId(String entityName) {
        ORM orm = ORM.create();
        Object pkId = null;
        DynamicObjectCollection dynColl = orm.query(entityName, null);
        if (dynColl != null && !dynColl.isEmpty()) {
            pkId = ((DynamicObject)dynColl.get(0)).get("Id");
        }
        return pkId;
    }

    public void initialize() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRYENTITYFORATTACHMENT);
        entryGrid.addRowClickListener((RowClickEventListener)this);
        this.addClickListeners(new String[]{NOTIFY_VIEW_MORE, NOTIFY_VIEW_LESS, BUTTONAP_BILLDETAIL});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if (GRIDTITLE.equals(key)) {
            String value = (String)this.getModel().getValue(GRIDTITLE);
            List entityTitles = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get(ENTITYTITLES), Map.class);
            for (Map map : entityTitles) {
                String entityKey = (String)map.get(ENTITYKEY);
                if (value.equals(entityKey)) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{entityKey});
                    continue;
                }
                this.getView().setVisible(Boolean.FALSE, new String[]{entityKey});
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        Object evtSource = evt.getSource();
        if (CardEntry.class.isInstance(evtSource)) {
            CardEntry entry = (CardEntry)evtSource;
            String entryId = entry.getEntryKey();
            int selectRow = entry.getSelectRows()[0];
            if (ENTRYENTITYFORATTACHMENT.equals(entryId)) {
                this.showAttachment(entryId, selectRow);
            }
        }
    }

    public void click(EventObject evt) {
        if (evt.getSource() instanceof Control) {
            Control c = (Control)evt.getSource();
            String key = c.getKey();
            Integer showCount = Integer.valueOf(this.getPageCache().get("showCount"));
            switch (key) {
                case "notifyviewmore": {
                    this.showOtherComponent(showCount, Boolean.TRUE);
                    break;
                }
                case "notifyviewless": {
                    this.showOtherComponent(showCount, Boolean.FALSE);
                    break;
                }
                case "buttonap_billdetail": {
                    this.showBillDetail();
                    break;
                }
            }
        }
    }

    private void showBillDetail() {
        String value = (String)this.getModel().getValue(GRIDTITLE);
        List entityTitles = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get(ENTITYTITLES), Map.class);
        String gridName = null;
        for (Map map : entityTitles) {
            if (!value.equals(map.get(ENTITYKEY))) continue;
            gridName = (String)map.get(ENTITYNAME);
            break;
        }
        IFormView parentView = this.getView().getParentView();
        parentView.executeClientCommand("setCaption", new Object[]{gridName});
        this.getView().sendFormAction(parentView);
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.invokeControlMethod(value, "gridFullScreen", new Object[0]);
    }

    public void customEvent(CustomEventArgs e) {
        String eventName = e.getEventName();
        if ("gridExitFullScreen".equals(eventName)) {
            IFormView parentView = this.getView().getParentView();
            parentView.executeClientCommand("setCaption", new Object[]{ResManager.loadKDString((String)"\u5355\u636e\u8be6\u60c5", (String)"WfBillSummaryMob_2", (String)"bos-wf-formplugin", (Object[])new Object[0])});
            this.getView().sendFormAction(parentView);
        }
    }

    private void showNotification(Boolean showMore) {
        this.getView().setVisible(showMore, new String[]{NOTIFY_VIEW_MORE});
        this.getView().setVisible(Boolean.valueOf(showMore == false), new String[]{NOTIFY_VIEW_LESS});
    }

    private void addDynamicFieldAp(EntityItem<?> entityItem, FlexPanelAp uiHeadMeta) {
        FieldAp fieldAp = new FieldAp();
        Field field = null;
        if (entityItem instanceof Field) {
            field = (Field)entityItem;
            if (AmountField.class.isInstance(entityItem)) {
                ((AmountField)field).setScale(2);
            }
            fieldAp.setField(field);
        }
        fieldAp.setId(entityItem.getKey());
        fieldAp.setKey(entityItem.getKey());
        LocaleString width = new LocaleString();
        width.setLocaleValue("97px");
        fieldAp.setLock("edit");
        fieldAp.setLabelWidth(width);
        fieldAp.setTextAlign("right");
        fieldAp.setForeColor("#768893");
        fieldAp.setFontSize(14);
        fieldAp.setName(entityItem.getName());
        fieldAp.setBackColor("#FFFFFF");
        fieldAp.setQuickAddNew(true);
        Style style = new Style();
        Padding padding = new Padding();
        padding.setBottom("0px");
        padding.setTop("10px");
        style.setPadding(padding);
        fieldAp.setStyle(style);
        fieldAp.setFieldTextAlign("left");
        fieldAp.setFieldFontSize(16);
        fieldAp.setFieldForeColor("#1D1D1D");
        uiHeadMeta.getItems().add(fieldAp);
    }

    private void showAttachment(String entryId, int selectRow) {
        String pagecache = this.getPageCache().get(entryId + selectRow);
        if (WfUtils.isNotEmpty((String)pagecache)) {
            Map attachementInfo = (Map)SerializationUtils.fromJsonString((String)pagecache, Map.class);
            IClientViewProxy iClientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            iClientViewProxy.addAction("previewAttachment", (Object)attachementInfo);
        }
    }

    private void showOtherComponent(Integer showCount, Boolean isShowMore) {
        if (null != showCount) {
            Boolean isHaveAttachment;
            Boolean isShowPanelForNotify = null;
            if (showCount < 8 && !isShowMore.booleanValue()) {
                this.getView().setVisible(Boolean.FALSE, new String[]{MOBILECONTAINER_HIDE});
                isHaveAttachment = this.loadAttachmentInfo(Boolean.TRUE);
                Boolean isShowEntryEntity = Boolean.TRUE;
                if (isHaveAttachment.booleanValue() && (showCount = Integer.valueOf(showCount + 1)) >= 8) {
                    isShowEntryEntity = Boolean.FALSE;
                }
                Boolean isHaveEntryEntity = this.loadEntryEntityInfo(isShowEntryEntity);
                isShowPanelForNotify = isShowEntryEntity == false && isHaveEntryEntity != false;
            } else {
                isHaveAttachment = this.loadAttachmentInfo(isShowMore);
                Boolean isHaveEntryEntity = this.loadEntryEntityInfo(isShowMore);
                if (showCount == 8) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{MOBILECONTAINER_HIDE});
                } else {
                    this.getView().setVisible(isShowMore, new String[]{MOBILECONTAINER_HIDE});
                }
                isShowPanelForNotify = isHaveAttachment != false || isHaveEntryEntity != false || showCount > 8;
            }
            this.getView().setVisible(isShowPanelForNotify, new String[]{FLEXPANELAP_NOTIFY});
            if (isShowPanelForNotify.booleanValue()) {
                this.showNotification(isShowMore == false);
            }
            Boolean isShowPanelForApplier = Boolean.TRUE;
            if (isShowPanelForNotify.booleanValue() && !isShowMore.booleanValue()) {
                isShowPanelForApplier = Boolean.FALSE;
            }
            this.getView().setVisible(isShowPanelForApplier, new String[]{FLEXPANELAP_APPLIERINFO});
        }
    }

    private Boolean loadAttachmentInfo(Boolean isShowMore) {
        Boolean isHaveAttachment = Boolean.TRUE;
        if (isShowMore.booleanValue()) {
            String isLoadAttachmentInfo = this.getPageCache().get("loadAttachmentInfo");
            if (WfUtils.isEmpty((String)isLoadAttachmentInfo)) {
                List<Map<String, Object>> entryData = this.getAttachmentInfos();
                if (!entryData.isEmpty()) {
                    this.setEntryEntityForAttachment(entryData);
                } else {
                    isHaveAttachment = Boolean.FALSE;
                }
                this.getPageCache().put("loadAttachmentInfo", isHaveAttachment.toString());
            } else {
                isHaveAttachment = Boolean.valueOf(isLoadAttachmentInfo);
            }
        }
        this.getView().setVisible(Boolean.valueOf(isShowMore != false && isHaveAttachment != false), new String[]{FLEXPANELAP_ATTACHMENT});
        return isHaveAttachment;
    }

    private Boolean loadEntryEntityInfo(Boolean isShowMore) {
        List list;
        Boolean isHaveEntryEntity = Boolean.FALSE;
        String entityTitles = this.getPageCache().get(ENTITYTITLES);
        if (entityTitles != null && (list = SerializationUtils.fromJsonStringToList((String)entityTitles, Map.class)) != null && !list.isEmpty()) {
            isHaveEntryEntity = Boolean.TRUE;
        }
        if (isHaveEntryEntity.booleanValue()) {
            this.getView().setVisible(isShowMore, new String[]{FLEXPANELAP_ENTRYINFO});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{FLEXPANELAP_ENTRYINFO});
        }
        return isHaveEntryEntity;
    }

    private List<Map<String, Object>> getAttachmentInfos() {
        List attachmentsForField;
        ArrayList<Map<String, Object>> entryData = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> data = null;
        MobileFormShowParameter showParameter = (MobileFormShowParameter)this.getView().getFormShowParameter();
        String formId = (String)showParameter.getCustomParam(BUSINESSNUMBER);
        String pkId = (String)showParameter.getCustomParam(BUSINESSPKID);
        List attachmentsForPanel = BillPagePluginUtil.getAttachments((String)formId, (Object)pkId);
        Timestamp ts = null;
        if (!attachmentsForPanel.isEmpty()) {
            for (DynamicObject obj : attachmentsForPanel) {
                ts = (Timestamp)obj.get("fcreatetime");
                data = new HashMap<String, Object>();
                data.put(FILEID, obj.getString("id"));
                data.put(FILENAME, obj.get("fattachmentname"));
                data.put(FILESIZE, Integer.valueOf(obj.getString("fattachmentsize")));
                data.put(FILEEXT, obj.get("fextname"));
                data.put(DOWNLOADURL, obj.get("ffileid"));
                data.put(FILETIME, ts.getTime());
                data.put(FILESHOWBYINSTRUCTIONS, Boolean.TRUE);
                entryData.add(data);
            }
        }
        if (!(attachmentsForField = BillPagePluginUtil.getAttachment((String)formId, (Object)pkId)).isEmpty()) {
            for (DynamicObject obj : attachmentsForField) {
                ts = (Timestamp)obj.get("createtime");
                data = new HashMap();
                data.put(FILEID, obj.getString("id"));
                data.put(FILENAME, obj.get("name"));
                data.put(FILESIZE, Integer.valueOf(obj.getString("size")));
                data.put(FILEEXT, obj.get("type"));
                data.put(DOWNLOADURL, obj.get("url"));
                data.put(FILETIME, ts.getTime());
                data.put(FILESHOWBYINSTRUCTIONS, Boolean.TRUE);
                entryData.add(data);
            }
        }
        return entryData;
    }

    private void setEntryEntityForAttachment(List<Map<String, Object>> entryData) {
        IDataModel model = this.getModel();
        String entryName = ENTRYENTITYFORATTACHMENT;
        ApprovalPluginUtil.showClearEntryEntity((IDataModel)model, (String)entryName, (IFormView)this.getView());
        int i = 0;
        this.getView().setVisible(Boolean.TRUE, new String[]{entryName});
        model.batchCreateNewEntryRow(entryName, entryData.size());
        HashMap<String, String> pageCacheMap = new HashMap<String, String>(entryData.size());
        for (Map<String, Object> data : entryData) {
            model.setValue(ATTACHMENT_PICTUREFIELD, this.getImageUrlByExtName((String)data.get(FILEEXT)), i);
            model.setValue(ATTACHMENT_TEXTFIELD_NAME, data.get(FILENAME), i);
            model.setValue(ATTACHMENT_TEXTFIELD_SIZE, (Object)this.getFileSize((Integer)data.get(FILESIZE)), i);
            pageCacheMap.put(entryName + i, SerializationUtils.toJsonString(data));
            ++i;
        }
        this.getPageCache().put(pageCacheMap);
    }

    private String getFileSize(Integer size) {
        long kb = 1024L;
        long mb = kb * 1024L;
        long gb = mb * 1024L;
        if ((long)size.intValue() >= gb) {
            return String.format("%.1f GB", (double)size.intValue() / (double)gb);
        }
        if ((long)size.intValue() >= mb) {
            double f = (double)size.intValue() / (double)mb;
            return String.format(f > 100.0 ? "%.0f MB" : "%.1f MB", f);
        }
        if ((long)size.intValue() >= kb) {
            double f = (double)size.intValue() / (double)kb;
            return String.format(f > 100.0 ? "%.0f KB" : "%.1f KB", f);
        }
        return String.format("%d B", size);
    }

    private Object getImageUrlByExtName(String extName) {
        String imageUrl = null;
        imageUrl = "zip,wim,tar,gz,xz".contains(extName) ? PictureResourceEnum.MOBILE_ZIP.getValue() : (extName.contains("xl") ? PictureResourceEnum.MOBILE_EXCEL.getValue() : (extName.contains("do") ? PictureResourceEnum.MOBILE_WORD.getValue() : (extName.contains("pp") || extName.contains("po") ? PictureResourceEnum.MOBILE_PPT.getValue() : (extName.contains("pdf") ? PictureResourceEnum.MOBILE_PDF.getValue() : ("bmp,jpg,png,tif,gif,pcx,tga,exif,fpx,svg,psd,cdr,pcd,dxf,ufo,eps,ai,raw,WMF,webp".contains(extName) ? PictureResourceEnum.MOBILE_IMAGE.getValue() : PictureResourceEnum.MOBILE_DEFAULT.getValue())))));
        return imageUrl;
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType oldMainType = e.getOriginalEntityType();
        MainEntityType newMainType = null;
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("LoadCustomControlMetasSample", exp.getMessage()), new Object[0]);
        }
        this.registDynamicBillProps(newMainType);
        e.setNewEntityType(newMainType);
    }

    private void registDynamicBillProps(MainEntityType summarymob) {
        MobileFormShowParameter showParameter = (MobileFormShowParameter)this.getView().getFormShowParameter();
        String pkId = (String)showParameter.getCustomParam(BUSINESSPKID);
        String billId = (String)showParameter.getCustomParam(BUSINESSNUMBER);
        String billSummaryNumber = (String)showParameter.getCustomParam(BILLSUMMARYNUMBER);
        if (pkId != null) {
            MainEntityType billEntityType = EntityMetadataCache.getDataEntityType((String)billId);
            this.registEntityType((DynamicObjectType)billEntityType, (DynamicObjectType)summarymob);
            List<String> entrysNames = this.getEntryName(billSummaryNumber);
            boolean goHeader = this.getHeader(pkId, billId, entrysNames);
            if (goHeader && entrysNames.size() <= 1) {
                if (!entrysNames.isEmpty()) {
                    for (String entryName : entrysNames) {
                        EntryProp prop = (EntryProp)billEntityType.getProperty(entryName);
                        this.registEntityType(prop.getDynamicCollectionItemPropertyType(), (DynamicObjectType)summarymob);
                    }
                }
            } else {
                this.registEntryEntity(billEntityType, summarymob, billId, billSummaryNumber);
            }
        } else {
            this.getView().showErrorNotification(WFMultiLangConstants.getEntityNullTip());
        }
    }

    private boolean getHeader(String pkId, String billId, List<String> entryNames) {
        if (entryNames == null || entryNames.size() > 1) {
            return false;
        }
        boolean goHead = false;
        if (this.getPageCache() != null && this.getPageCache().get(GOHEADER) != null) {
            goHead = Boolean.parseBoolean(this.getPageCache().get(GOHEADER));
        } else {
            DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)billId);
            DynamicObjectCollection col = bill.getDynamicObjectCollection(entryNames.get(0));
            boolean bl = goHead = col != null && col.size() == 1;
            if (this.getPageCache() != null) {
                this.getPageCache().put(GOHEADER, String.valueOf(goHead));
            }
        }
        return goHead;
    }

    public List<String> getFields(String number) {
        if (this.getPageCache() != null && this.getPageCache().get(FIELDS) != null) {
            String nms = this.getPageCache().get(FIELDS);
            return SerializationUtils.fromJsonStringToList((String)nms, String.class);
        }
        ArrayList<String> ret = new ArrayList<String>();
        ArrayList<String> fields = new ArrayList<String>();
        DynamicObjectCollection dynamicObjectCollection = this.getDynConfig(number);
        if (dynamicObjectCollection != null) {
            String entryLocation = null;
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                fields.add(dynamicObject.getString(FIELDKEY));
                entryLocation = dynamicObject.getString(ENTRYLOCATION);
                if (!WfUtils.isNotEmpty((String)entryLocation) || ret.contains(entryLocation)) continue;
                ret.add(entryLocation);
            }
        }
        if (this.getPageCache() != null) {
            this.getPageCache().put(ENTRYNAME, SerializationUtils.toJsonString(ret));
            this.getPageCache().put(FIELDS, SerializationUtils.toJsonString(fields));
        }
        return fields;
    }

    public List<String> getEntryName(String number) {
        if (this.getPageCache() != null && this.getPageCache().get(ENTRYNAME) != null) {
            String nms = this.getPageCache().get(ENTRYNAME);
            return SerializationUtils.fromJsonStringToList((String)nms, String.class);
        }
        ArrayList<String> ret = new ArrayList<String>();
        ArrayList<String> fields = new ArrayList<String>();
        DynamicObjectCollection dynamicObjectCollection = this.getDynConfig(number);
        if (dynamicObjectCollection != null) {
            String entryLocation = null;
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                fields.add(dynamicObject.getString(FIELDKEY));
                entryLocation = dynamicObject.getString(ENTRYLOCATION);
                if (!WfUtils.isNotEmpty((String)entryLocation) || ret.contains(entryLocation)) continue;
                ret.add(entryLocation);
            }
        }
        if (this.getPageCache() != null) {
            this.getPageCache().put(ENTRYNAME, SerializationUtils.toJsonString(ret));
            this.getPageCache().put(FIELDS, SerializationUtils.toJsonString(fields));
        }
        return ret;
    }

    private void registEntryEntity(MainEntityType srcMainType, MainEntityType targetMainType, String number, String billSummaryNumber) {
        Map billEntities = srcMainType.getAllEntities();
        Set billEntrySet = billEntities.entrySet();
        Iterator billIterator = billEntrySet.iterator();
        Map.Entry billEntry = null;
        EntityType billEntityType = null;
        List<String> entrys = this.getEntryName(billSummaryNumber);
        while (billIterator.hasNext()) {
            billEntry = billIterator.next();
            billEntityType = (EntityType)billEntry.getValue();
            if (!EntryType.class.isInstance(billEntityType) || !entrys.contains(billEntityType.getName())) continue;
            this.registEntryEntity(targetMainType, billEntityType, billEntityType.getName());
        }
    }

    private void registEntryEntity(MainEntityType targetMainType, EntityType billEntityType, String entryKey) {
        EntryType entryType = new EntryType();
        entryType.setName(billEntityType.getName());
        this.registEntityType1(entryKey, entryType, billEntityType);
        entryType.setKeyEntry(true);
        EntryProp entryProp = new EntryProp(entryKey, (DynamicObjectType)entryType);
        targetMainType.addProperty((DynamicProperty)entryProp);
    }

    private void registEntityType1(String entryKey, EntryType entryType, EntityType billEntityType) {
        MobileFormShowParameter showParameter = (MobileFormShowParameter)this.getView().getFormShowParameter();
        String billSummaryNumber = (String)showParameter.getCustomParam(BILLSUMMARYNUMBER);
        DynamicObjectCollection dynamicObjectCollection = this.getDynConfig(billSummaryNumber);
        try {
            entryType.addProperty((DynamicProperty)billEntityType.getProperty("id").clone());
            entryType.addProperty((DynamicProperty)billEntityType.getProperty("seq").clone());
        }
        catch (CloneNotSupportedException e1) {
            this.log.error("\u8f6c\u6362\u51fa\u9519\u7684\u5b57\u6bb5\uff1a" + entryKey);
        }
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            String entrylocation;
            boolean isHeadField = dynamicObject.getBoolean(ISHEADFIELD);
            if (isHeadField || !entryKey.equals(entrylocation = dynamicObject.getString(ENTRYLOCATION))) continue;
            String fieldKey = dynamicObject.getString(FIELDKEY);
            DynamicProperty property = billEntityType.getProperty(fieldKey);
            try {
                entryType.addProperty((DynamicProperty)property.clone());
            }
            catch (CloneNotSupportedException e) {
                this.log.error("\u8f6c\u6362\u51fa\u9519\u7684\u5b57\u6bb5\uff1a" + fieldKey);
            }
        }
    }

    public void registEntityType(DynamicObjectType src, DynamicObjectType dest) {
        DataEntityPropertyCollection target = dest.getProperties();
        DataEntityPropertyCollection srcEntityTypeCol = src.getProperties();
        MobileFormShowParameter showParameter = (MobileFormShowParameter)this.getView().getFormShowParameter();
        List<String> fields = this.getFields((String)showParameter.getCustomParam(BILLSUMMARYNUMBER));
        String relateOrg = null;
        IDataEntityProperty extProp = null;
        IDataEntityProperty extPropClone = null;
        for (IDataEntityProperty p : srcEntityTypeCol) {
            String pName = p.getName();
            try {
                IDataEntityProperty tmp;
                if (!fields.contains(pName) || target.get((Object)pName) != null) continue;
                if (DateProp.class.isInstance(p) && WfUtils.isNotEmpty((String)(relateOrg = ((DateProp)p).getRelateOrg())) && null != (extProp = (IDataEntityProperty)srcEntityTypeCol.get((Object)relateOrg)) && !target.contains((Object)(extPropClone = (IDataEntityProperty)extProp.clone()))) {
                    target.add((Object)extPropClone);
                }
                if ((tmp = (IDataEntityProperty)p.clone()) instanceof MuliLangTextProp) {
                    MuliLangTextProp langTextProp = new MuliLangTextProp();
                    langTextProp.setName(tmp.getName());
                    langTextProp.setAlias(tmp.getAlias());
                    dest.addProperty((DynamicProperty)langTextProp);
                    DynamicObjectType localeDt = dest.getOrCreateLocaleType();
                    TextProp sp = new TextProp();
                    sp.setName(tmp.getName());
                    sp.setAlias(tmp.getAlias());
                    sp.setDbIgnore(StringUtils.isBlank((String)tmp.getAlias()));
                    sp.setDefaultValue((Object)"");
                    localeDt.registerSimpleProperty((DynamicSimpleProperty)sp);
                    continue;
                }
                if (tmp instanceof BasedataProp) {
                    BasedataProp o = (BasedataProp)tmp;
                    LongProp longProp = new LongProp();
                    longProp.setName(o.getRefIdProp().getName());
                    longProp.setAlias(o.getRefIdProp().getAlias());
                    o.setRefIdProp((IDataEntityProperty)longProp);
                    dest.addProperty((DynamicProperty)longProp);
                    dest.addProperty((DynamicProperty)o);
                    continue;
                }
                if (tmp instanceof DateProp) {
                    ((DateProp)tmp).setRelateOrg(null);
                    dest.addProperty((DynamicProperty)tmp);
                    continue;
                }
                if (tmp instanceof DateTimeProp) {
                    ((DateTimeProp)tmp).setRelateOrg(null);
                    dest.addProperty((DynamicProperty)tmp);
                    continue;
                }
                dest.addProperty((DynamicProperty)tmp);
            }
            catch (CloneNotSupportedException e1) {
                this.log.info("convert error:" + pName);
            }
        }
        DynamicCollectionProperty prop = dest.getLocaleProperty();
        if (prop != null) {
            for (IDataEntityProperty p : prop.getItemType().getProperties()) {
                DynamicProperty mp = dest.getProperty(p.getName());
                if (!(mp instanceof MuliLangTextProp)) continue;
                ((MuliLangTextProp)mp).setLocaleProperty((IDataEntityProperty)prop, (DynamicSimpleProperty)p);
            }
        }
    }

    private void setEntryEntityForApplier() {
        IDataModel model = this.getModel();
        String entryName = ENTRYENTITY_APPLIER;
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObjectCollection entrys = (DynamicObjectCollection)dataEntity.get(entryName);
        if (entrys != null && !entrys.isEmpty()) {
            entrys.clear();
            this.getView().updateView(entryName);
        }
        int i = 0;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String applier = (String)customParams.get("bizApplier");
        if (WfUtils.isNotEmpty((String)applier)) {
            Long applierId = Long.valueOf(applier);
            model.batchCreateNewEntryRow(entryName, 1);
            WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
            Map userInfo = wfService.getTaskService().getUserInfosByUserId(applierId);
            String applierName = (String)customParams.get("bizApplierName");
            model.setValue(PICTUREFIELD_APPLIER, userInfo.get("avatar"), i);
            model.setValue(TEXTFIELD_APPLIER_NAME, (Object)applierName, i);
            model.setValue(TEXTFIELD_APPLIER_ORG, (Object)this.getUserMainOrgName(UserServiceHelper.getUserMainOrgId((long)applierId)), i);
        }
    }

    private String getUserMainOrgName(long userMainOrgId) {
        String displayName = null;
        QFilter viewFilter = new QFilter("view.treetype", "=", (Object)"01");
        QFilter isDefaultViewFilter = new QFilter("view.isdefault", "=", (Object)"1");
        QFilter orgFilter = new QFilter("org", "=", (Object)userMainOrgId);
        DynamicObject orgObj = QueryServiceHelper.queryOne((String)"bos_org_structure", (String)"org.name,fullname", (QFilter[])new QFilter[]{viewFilter, isDefaultViewFilter, orgFilter});
        if (null != orgObj) {
            String orgName = orgObj.getString("org.name");
            String orgFullName = orgObj.getString("fullname");
            String formateName = null;
            String compName = null;
            if (orgFullName.contains(orgName)) {
                int orgIndex = orgFullName.lastIndexOf(orgName) - 1;
                if (orgIndex > 0) {
                    compName = orgFullName.substring(0, orgIndex);
                }
            } else {
                compName = orgFullName;
            }
            if (WfUtils.isEmpty((String)compName)) {
                displayName = orgName;
            } else {
                formateName = compName != null && compName.contains("_") ? compName.replaceAll("_", "\\\\") : compName;
                displayName = orgName + "(" + formateName + ")";
            }
        }
        return displayName;
    }
}

