/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.bak;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.designer.property.alias.IPropertyConverter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.workflow.bpmn.model.BpmnModel;
import kd.bos.workflow.bpmn.model.Process;
import kd.bos.workflow.design.plugin.AbstractWorkflowConfigurePlugin;
import kd.bos.workflow.design.property.alias.AliasConverterFactory;
import kd.bos.workflow.design.util.DesignerModelUtil;
import kd.bos.workflow.design.util.DesignerPluginUtil;
import kd.bos.workflow.engine.RepositoryService;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.extitf.ExternalInterfaceUtil;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ResourceEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class WorkflowEventSubProcessConfigurePlugin
extends AbstractWorkflowConfigurePlugin {
    private static final String NAME = "name";
    private static final String SUBPROCESSNAME = "subprocessname";
    private static final String SUBPROCESSID = "subprocessid";
    private static final String OPERATION = "operation";
    private static final String FLOWRECORDFORMATTER = "flowrecordformatter";

    public void initialize() {
        super.initialize();
        this.addExclusiveProperty(new String[]{OPERATION, FLOWRECORDFORMATTER});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{SUBPROCESSNAME, OPERATION, FLOWRECORDFORMATTER});
    }

    public void click(EventObject evt) {
        String key;
        Control ctrl = (Control)evt.getSource();
        switch (key = ctrl.getKey()) {
            case "subprocessname": {
                this.showSubProcess();
                break;
            }
            case "operation": {
                this.showOperation();
                break;
            }
            case "flowrecordformatter": {
                this.showPageForFlowRecordFormatter();
                break;
            }
            default: {
                super.click(evt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCreateNewData(EventObject e) {
        try {
            this.beginInit();
            super.afterCreateNewData(e);
            JSONObject properties = this.getCellProperties();
            String subProcessId = properties.getString("subProcessId");
            if (WfUtils.isNotEmpty((String)subProcessId)) {
                WorkflowService wfService = (WorkflowService)ServiceFactory.getService((String)"WorkflowService");
                ModelEntity model = (ModelEntity)wfService.getRepositoryService().getModel(Long.valueOf(subProcessId));
                IPropertyConverter converter = AliasConverterFactory.create((String)"wf_formoperation");
                HashMap<String, String> context = new HashMap<String, String>();
                context.put("entityId", model.getEntraBillId());
                converter.setContext(context, null);
                Object alias = converter.convert(DesignerModelUtil.getProperty((Map)properties, (String)OPERATION));
                this.getModel().setValue(OPERATION, alias);
            }
            IPropertyConverter flowRecordConverter = AliasConverterFactory.create((String)"wf_external_interface");
            Object flowRecordAlias = flowRecordConverter.convert(DesignerModelUtil.getProperty((Map)properties, (String)"flowRecordFormatter"));
            this.getModel().setValue(FLOWRECORDFORMATTER, flowRecordAlias);
        }
        catch (Exception ex) {
            this.showInitErrorMessage(ex);
        }
        finally {
            this.initComplete(WorkflowEventSubProcessConfigurePlugin.class);
        }
    }

    private void showSubProcess() {
        try {
            JSONObject processProps = this.getProcessProperties();
            HashMap<String, String> processProperties = new HashMap<String, String>();
            processProperties.put("process_id", processProps.getString("process_id"));
            processProperties.put("entraBillId", processProps.getString("entraBillId"));
            HashMap<String, HashMap<String, String>> context = new HashMap<String, HashMap<String, String>>();
            context.put("processProperties", processProperties);
            HashMap<String, HashMap<String, HashMap<String, String>>> params = new HashMap<String, HashMap<String, HashMap<String, String>>>();
            params.put("context", context);
            FormShowParameter showParameter = this.getShowParameter("subprocess", "wf_selectsubprocess");
            showParameter.setCustomParams(params);
            this.getView().showForm(showParameter);
        }
        catch (Exception e) {
            this.log.warn(String.format("\u521d\u59cb\u5316\u5b50\u6d41\u7a0b\u76f8\u5173\u4fe1\u606f\u51fa\u9519--\u6a21\u578b\u8f6c\u6362\u51fa\u9519\uff01 %s %s", e.getMessage(), e.getStackTrace()));
        }
    }

    private void showOperation() {
        try {
            JSONObject processProps = this.getProcessProperties();
            HashMap<String, String> processProperties = new HashMap<String, String>();
            processProperties.put("process_id", processProps.getString("process_id"));
            processProperties.put("entraBill", processProps.getString("entraBill"));
            HashMap<String, HashMap<String, String>> context = new HashMap<String, HashMap<String, String>>();
            context.put("processProperties", processProperties);
            HashMap<String, HashMap<String, HashMap<String, String>>> params = new HashMap<String, HashMap<String, HashMap<String, String>>>();
            params.put("context", context);
            FormShowParameter showParameter = this.getShowParameter(OPERATION, "wf_formoperation");
            showParameter.setCustomParams(params);
            this.getView().showForm(showParameter);
        }
        catch (Exception e) {
            this.log.warn(String.format("\u521d\u59cb\u5316\u64cd\u4f5c\u76f8\u5173\u4fe1\u606f\u51fa\u9519--\u6a21\u578b\u8f6c\u6362\u51fa\u9519\uff01 %s %s", e.getMessage(), e.getStackTrace()));
        }
    }

    private void showPageForFlowRecordFormatter() {
        JSONObject properties = this.getCellProperties();
        try {
            String subProcessId = (String)DesignerModelUtil.getProperty((Map)properties, (String)"subProcessId");
            if (subProcessId != null) {
                String types = ExternalInterfaceUtil.getTypes((String[])new String[]{"class", "script"});
                String value = (String)DesignerModelUtil.getProperty((Map)properties, (String)"flowRecordFormatter");
                RepositoryService service = this.getRepositoryService();
                ProcessDefinitionEntity entity = (ProcessDefinitionEntity)service.findEntityById(Long.valueOf(subProcessId), "wf_processdefinition");
                ResourceEntity resource = (ResourceEntity)service.findEntityById(entity.getResourceId(), "wf_resource");
                String bpmnJson = resource.getData();
                BpmnModel bpmnModel = DesignerModelUtil.getBpmnModel((String)bpmnJson);
                Process process = bpmnModel.getMainProcess();
                DesignerPluginUtil.openExternalInterface((IFormView)this.getView(), (IFormPlugin)this, (String)types, (String)process.getEntraBillId(), (String)value);
            }
        }
        catch (Exception e) {
            this.log.warn(String.format("\u521d\u59cb\u5916\u90e8\u63a5\u53e3\u76f8\u5173\u4fe1\u606f\u51fa\u9519--\u6a21\u578b\u8f6c\u6362\u51fa\u9519\uff01 %s %s", e.getMessage(), e.getStackTrace()));
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (returnData == null) {
            return;
        }
        switch (actionId) {
            case "subprocess": {
                this.setCloseDataForSubProcess((Map)returnData);
                break;
            }
            case "operation": {
                this.setCloseDataForOperation((Map)returnData);
                break;
            }
            case "externalInterface": {
                this.setCloseDataForFlowRecord(returnData);
                break;
            }
            default: {
                super.closedCallBack(evt);
            }
        }
    }

    private void setCloseDataForSubProcess(Map<String, String> evtData) {
        this.getModel().setValue(NAME, (Object)String.format(ResManager.loadKDString((String)"%s\u5b50\u6d41\u7a0b", (String)"WorkflowEventSubProcessConfigurePlugin_2", (String)"bos-wf-unittest", (Object[])new Object[0]), evtData.get("operation-alias")));
        this.getModel().setValue(OPERATION, (Object)evtData.get("operation-alias"));
        this.getModel().setValue(SUBPROCESSNAME, (Object)evtData.get(NAME));
        this.setProperty(SUBPROCESSID, evtData.get("id"));
        this.setProperty(OPERATION, evtData.get(OPERATION));
    }

    private void setCloseDataForOperation(Map<String, String> operationData) {
        this.getModel().setValue(NAME, (Object)String.format(ResManager.loadKDString((String)"%s\u5b50\u6d41\u7a0b", (String)"WorkflowEventSubProcessConfigurePlugin_2", (String)"bos-wf-unittest", (Object[])new Object[0]), operationData.get(NAME)));
        this.getModel().setValue(OPERATION, (Object)operationData.get(NAME));
    }

    private void setCloseDataForFlowRecord(Object returnData) {
        if (WfUtils.isNotEmptyString((Object)returnData)) {
            this.getModel().setValue(FLOWRECORDFORMATTER, (Object)ExternalInterfaceUtil.getFormattedShowValue((String)((String)returnData)));
            this.setProperty(FLOWRECORDFORMATTER, returnData);
        }
    }
}

